/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sqlobject;

import ca.sqlpower.object.AbstractSPListener;
import ca.sqlpower.object.ObjectDependentException;
import ca.sqlpower.object.SPChildEvent;
import ca.sqlpower.object.SPListener;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.annotation.Accessor;
import ca.sqlpower.object.annotation.Constructor;
import ca.sqlpower.object.annotation.ConstructorParameter;
import ca.sqlpower.object.annotation.Mutator;
import ca.sqlpower.object.annotation.NonProperty;
import ca.sqlpower.object.annotation.Transient;
import ca.sqlpower.sql.CachedRowSet;
import ca.sqlpower.sqlobject.ForeignKeyColumnUpdaterPoolingSPListener;
import ca.sqlpower.sqlobject.LockedColumnException;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.SQLIndex;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLObjectRuntimeException;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.util.SQLPowerUtils;
import ca.sqlpower.util.SessionNotFoundException;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SQLRelationship
extends SQLObject
implements Serializable {
    public static final List<Class<? extends SPObject>> allowedChildTypes = Collections.singletonList(ColumnMapping.class);
    private static Logger logger = Logger.getLogger(SQLRelationship.class);
    private List<ColumnMapping> mappings = new ArrayList<ColumnMapping>();
    private boolean isDisconnecting = false;
    private SQLImportedKey foreignKey;
    public static final int ZERO = 1;
    public static final int ONE = 2;
    public static final int MANY = 4;
    public static final int PKCOLUMN = 4;
    public static final int FKCOLUMN = 5;
    protected UpdateDeleteRule updateRule = UpdateDeleteRule.NO_ACTION;
    protected UpdateDeleteRule deleteRule = UpdateDeleteRule.NO_ACTION;
    protected Deferrability deferrability = Deferrability.NOT_DEFERRABLE;
    protected int pkCardinality = 2;
    protected int fkCardinality = 7;
    protected boolean identifying;
    private String textForParentLabel = "";
    private String textForChildLabel = "";
    protected SPListener fkColumnUpdater = new ForeignKeyColumnUpdaterPoolingSPListener(this);

    public static List<SQLRelationship> getExportedKeys(List<SQLImportedKey> foreignKeys) {
        ArrayList<SQLRelationship> primaryKeys = new ArrayList<SQLRelationship>();
        for (SQLImportedKey k : foreignKeys) {
            primaryKeys.add(k.getRelationship());
        }
        return primaryKeys;
    }

    public SQLRelationship() {
        this.setName("New SQL Relationship");
        this.setPopulated(true);
        this.foreignKey = new SQLImportedKey(this);
    }

    @Constructor
    public SQLRelationship(@ConstructorParameter(parameterType=ConstructorParameter.ParameterType.PROPERTY, propertyName="parent") SQLTable pkTable) {
        this.setName("New SQL Relationship");
        this.setPopulated(true);
        this.setParent(pkTable);
    }

    public SQLRelationship(SQLRelationship relationshipToCopy) throws SQLObjectException {
        this();
        this.updateToMatch(relationshipToCopy);
    }

    @Override
    @Mutator
    public void setName(String name) {
        super.setName(name);
        this.setPhysicalName(name);
    }

    @Override
    public final void updateToMatch(SQLObject source) throws SQLObjectException {
        this.updateToMatch(source, false);
    }

    public final void updateToMatch(SQLObject source, boolean ignoreColumnMappings) throws SQLObjectException {
        SQLRelationship relationshipToCopy = (SQLRelationship)source;
        this.setName(relationshipToCopy.getName());
        this.setIdentifying(relationshipToCopy.determineIdentifyingStatus());
        this.setUpdateRule(relationshipToCopy.getUpdateRule());
        this.setDeleteRule(relationshipToCopy.getDeleteRule());
        this.setDeferrability(relationshipToCopy.getDeferrability());
        for (Map.Entry<Class<? extends SQLObject>, Throwable> inaccessibleReason : source.getChildrenInaccessibleReasons().entrySet()) {
            this.setChildrenInaccessibleReason(inaccessibleReason.getValue(), inaccessibleReason.getKey(), false);
        }
        this.setTextForChildLabel(relationshipToCopy.getTextForChildLabel());
        this.setTextForParentLabel(relationshipToCopy.getTextForParentLabel());
        if (ignoreColumnMappings) {
            return;
        }
        ArrayList<ColumnMapping> columnsToRemove = new ArrayList<ColumnMapping>(this.getChildrenWithoutPopulating());
        for (ColumnMapping newColMapping : relationshipToCopy.getChildrenWithoutPopulating()) {
            boolean foundColumn = false;
            for (int i = columnsToRemove.size() - 1; i >= 0; --i) {
                String newColFKColName;
                SQLTable newColFKTable;
                String existingColName;
                SQLTable existingFKTable;
                ColumnMapping existingMapping = (ColumnMapping)columnsToRemove.get(i);
                if (existingMapping.getFkColumn() == null) {
                    existingFKTable = existingMapping.getFkTable();
                    existingColName = existingMapping.getFkColName();
                } else {
                    existingFKTable = existingMapping.getFkColumn().getParent();
                    existingColName = existingMapping.getFkColumn().getName();
                }
                if (newColMapping.getFkColumn() == null) {
                    newColFKTable = newColMapping.getFkTable();
                    newColFKColName = newColMapping.getFkColName();
                } else {
                    newColFKTable = newColMapping.getFkColumn().getParent();
                    newColFKColName = newColMapping.getFkColumn().getName();
                }
                if (!existingMapping.getPkColumn().equals(newColMapping.getPkColumn()) || (existingMapping.getFkColumn() == null || newColMapping.getFkColumn() == null || !existingMapping.getFkColumn().equals(newColMapping.getFkColumn())) && (!existingFKTable.equals(newColFKTable) || !existingColName.equals(newColFKColName))) continue;
                columnsToRemove.remove(existingMapping);
                foundColumn = true;
                break;
            }
            if (foundColumn) continue;
            this.addChild(newColMapping);
        }
        for (ColumnMapping removeMe : columnsToRemove) {
            try {
                this.removeChild(removeMe);
            }
            catch (Exception e) {
                throw new SQLObjectException(e);
            }
        }
    }

    private static String generateUniqueColumnName(String colName, SQLTable table) throws SQLObjectException {
        String uniqueName;
        if (table.getColumnByName(colName) == null) {
            return colName;
        }
        int count = 1;
        do {
            uniqueName = colName + "_" + count;
            ++count;
        } while (table.getColumnByName(uniqueName) != null);
        return uniqueName;
    }

    public void attachListeners() throws SQLObjectException {
        SQLPowerUtils.listenToHierarchy(this.getParent(), this.fkColumnUpdater);
    }

    private void detachListeners() {
        if (this.getParent() != null) {
            SQLPowerUtils.unlistenToHierarchy(this.getParent(), this.fkColumnUpdater);
        }
    }

    @Mutator(constructorMutator=true)
    public void setPkTable(SQLTable pkTable) {
        if (this.getPkTable() != null && !this.getPkTable().equals(pkTable)) {
            throw new IllegalArgumentException("Cannot set the parent table of relationship " + this.getName() + " to " + pkTable.getName() + " as it is already attached to " + this.getParent().getName());
        }
        SQLTable oldTable = this.getPkTable();
        this.setParent(pkTable);
        this.firePropertyChange("pkTable", oldTable, pkTable);
    }

    @Transient
    @Mutator
    public void setFkTable(SQLTable fkTable) {
        if (this.getFkTable() != null && !this.getFkTable().equals(fkTable)) {
            throw new IllegalArgumentException("Cannot set the child table of relationship " + this.getName() + " to " + fkTable.getName() + " as it is already attached to " + this.getFkTable().getName());
        }
        SQLTable oldTable = this.getFkTable();
        this.foreignKey.setParent(fkTable);
        this.firePropertyChange("fkTable", oldTable, fkTable);
    }

    public void attachRelationship(SQLTable pkTable, SQLTable fkTable, boolean autoGenerateMapping) throws SQLObjectException {
        this.attachRelationship(pkTable, fkTable, autoGenerateMapping, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachRelationship(SQLTable pkTable, SQLTable fkTable, boolean autoGenerateMapping, boolean addToParents) throws SQLObjectException {
        this.setFkTable(fkTable);
        try {
            this.setMagicEnabled(false);
            this.setParent(pkTable);
        }
        finally {
            this.setMagicEnabled(true);
        }
        this.attachRelationship(autoGenerateMapping, addToParents);
    }

    private void attachRelationship(boolean autoGenerateMapping) throws SQLObjectException {
        this.attachRelationship(autoGenerateMapping, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attachRelationship(boolean autoGenerateMapping, boolean addToParents) throws SQLObjectException {
        if (this.getParent() == null) {
            throw new NullPointerException("Null pkTable not allowed");
        }
        SQLTable fkTable = this.getFkTable();
        if (fkTable == null) {
            throw new NullPointerException("Null fkTable not allowed");
        }
        this.detachListeners();
        boolean alreadyExists = false;
        for (SQLRelationship r : this.getParent().getExportedKeysWithoutPopulating()) {
            if (!r.getFkTable().equals(fkTable)) continue;
            alreadyExists = true;
            break;
        }
        if (addToParents) {
            this.getParent().addChild(this);
            fkTable.addChild(this.foreignKey);
        }
        try {
            fkTable.setMagicEnabled(false);
            if (autoGenerateMapping) {
                SQLColumn pkCol;
                ArrayList<SQLColumn> pkColListCopy = new ArrayList<SQLColumn>(this.getParent().getColumns().size());
                pkColListCopy.addAll(this.getParent().getColumns());
                Iterator i$ = pkColListCopy.iterator();
                while (i$.hasNext() && (pkCol = (SQLColumn)i$.next()).isPrimaryKey()) {
                    String colName;
                    SQLColumn match = fkTable.getColumnByName(pkCol.getName());
                    SQLColumn fkCol = new SQLColumn(pkCol);
                    if (this.getParent() == fkTable) {
                        colName = "Parent_" + fkCol.getName();
                        fkCol.setName(SQLRelationship.generateUniqueColumnName(colName, fkTable));
                        this.setIdentifying(false);
                    } else if (match == null) {
                        fkCol.setName(SQLRelationship.generateUniqueColumnName(pkCol.getName(), fkTable));
                    } else if (!alreadyExists && match.getType() == pkCol.getType() && match.getPrecision() == pkCol.getPrecision() && match.getScale() == pkCol.getScale()) {
                        fkCol = match;
                    } else {
                        colName = pkCol.getParent().getName() + "_" + pkCol.getName();
                        fkCol.setName(SQLRelationship.generateUniqueColumnName(colName, fkTable));
                    }
                    this.addMapping(pkCol, fkCol);
                }
            }
            this.realizeMapping();
            this.attachListeners();
        }
        finally {
            if (fkTable != null) {
                fkTable.setMagicEnabled(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void realizeMapping() throws SQLObjectException {
        for (ColumnMapping m : this.getChildren(ColumnMapping.class)) {
            if (m.getFkColumn() == null) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("realizeMapping: processing " + m));
            }
            SQLColumn fkCol = m.getFkColumn();
            try {
                int insertIdx;
                fkCol.setMagicEnabled(false);
                if (fkCol.getReferenceCount() == 0) {
                    fkCol.addReference();
                }
                if (this.identifying) {
                    if (fkCol.getParent() == null || !fkCol.isPrimaryKey()) {
                        logger.debug((Object)"realizeMapping: fkCol PK seq is null. Inserting at end of PK.");
                        insertIdx = this.getFkTable().getPkSize();
                    } else {
                        insertIdx = this.getFkTable().getColumnIndex(fkCol);
                        logger.debug((Object)("realizeMapping: using existing fkCol PK seq " + insertIdx));
                    }
                } else {
                    insertIdx = fkCol.getParent() != null && fkCol.isPrimaryKey() ? this.getFkTable().getColumnIndex(fkCol) : this.getFkTable().getColumns().size();
                }
                fkCol.setAutoIncrement(false);
                this.getFkTable().addColumn(fkCol, insertIdx);
                logger.debug((Object)("realizeMapping: Added column '" + fkCol.getName() + "' at index " + insertIdx));
                if (fkCol.getReferenceCount() <= 0) {
                    throw new IllegalStateException("Created a column with 0 references!");
                }
                if (!this.identifying || fkCol.isPrimaryKey()) continue;
                this.getFkTable().addToPK(fkCol);
            }
            finally {
                fkCol.setMagicEnabled(true);
            }
        }
    }

    static List<SQLRelationship> fetchExportedKeys(final SQLTable table, SQLTable originalFkTable) throws SQLObjectException {
        final SQLDatabase db = table.getParentDatabase();
        if (!db.isPopulated()) {
            throw new SQLObjectException("relationship.unpopulatedTargetDatabase");
        }
        CachedRowSet crs = new CachedRowSet();
        ResultSet tempRS = null;
        Connection con = null;
        try {
            con = table.getParentDatabase().getConnection();
            DatabaseMetaData dbmd = con.getMetaData();
            tempRS = dbmd.getExportedKeys(table.getCatalogName(), table.getSchemaName(), table.getName());
            crs.populate(tempRS);
        }
        catch (SQLException e) {
            throw new SQLObjectException("relationship.populate", e);
        }
        finally {
            try {
                if (tempRS != null) {
                    tempRS.close();
                }
            }
            catch (SQLException e) {
                logger.warn((Object)"Couldn't close imported keys result set", (Throwable)e);
            }
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException e) {
                logger.warn((Object)"Couldn't close connection", (Throwable)e);
            }
        }
        try {
            LinkedList<SQLRelationship> newKeys = new LinkedList<SQLRelationship>();
            logger.debug((Object)("search relationship for table:" + table.getCatalogName() + "." + table.getSchemaName() + "." + table.getName()));
            SQLRelationship r = null;
            while (crs.next()) {
                int currentKeySeq = crs.getInt(9);
                String pkCat = crs.getString(1);
                String pkSchema = crs.getString(2);
                String pkTableName = crs.getString(3);
                final String pkColName = crs.getString(4);
                final SQLTable parentTable = db.getTableByName(pkCat, pkSchema, pkTableName);
                final String fkCat = crs.getString(5);
                final String fkSchema = crs.getString(6);
                final String fkTableName = crs.getString(7);
                final String fkColName = crs.getString(8);
                final SQLTable fkTable = db.getTableByName(fkCat, fkSchema, fkTableName);
                if (originalFkTable != null && originalFkTable != fkTable) continue;
                final int updateRule = crs.getInt(10);
                final int deleteRule = crs.getInt(11);
                final String fkName = crs.getString(12);
                final int deferrability = crs.getInt(14);
                if (currentKeySeq == 1) {
                    final SQLRelationship finalRelation = r = new SQLRelationship();
                    Runnable fkTableRunner = new Runnable(){

                        @Override
                        public void run() {
                            if (fkTable == null) {
                                SQLTable foreignKeyTable;
                                try {
                                    foreignKeyTable = db.getTableByName(fkCat, fkSchema, fkTableName);
                                }
                                catch (NullPointerException e) {
                                    logger.error((Object)("FK table " + fkTableName + " of " + fkSchema + " is not populated yet."), (Throwable)e);
                                    throw e;
                                }
                                catch (SQLObjectException e) {
                                    throw new RuntimeException(e);
                                }
                                finalRelation.setFkTable(foreignKeyTable);
                            } else {
                                finalRelation.setFkTable(fkTable);
                            }
                        }
                    };
                    try {
                        table.getRunnableDispatcher().runInForeground(fkTableRunner);
                    }
                    catch (SessionNotFoundException e) {
                        fkTableRunner.run();
                    }
                    newKeys.add(r);
                }
                if (parentTable == null) {
                    logger.error((Object)("addImportedRelationshipsToTable: Couldn't find exporting table " + pkCat + "." + pkSchema + "." + pkTableName + " in target database!"));
                    continue;
                }
                final SQLRelationship relToModify = r;
                Runnable runner = new Runnable(){

                    @Override
                    public void run() {
                        if (!parentTable.isColumnsPopulated()) {
                            throw new IllegalStateException("FK table " + parentTable + " is missing columns, cannot populate relationships.");
                        }
                        try {
                            relToModify.setMagicEnabled(false);
                            ColumnMapping m = new ColumnMapping();
                            relToModify.addMapping(m);
                            relToModify.setParent(parentTable);
                            if (relToModify.getParent() != table) {
                                throw new IllegalStateException("fkTable did not match requested table");
                            }
                            logger.debug((Object)("Looking for pk column '" + pkColName + "' in table '" + relToModify.getParent() + "'"));
                            m.pkColumn = relToModify.getParent().getColumnByName(pkColName);
                            if (m.pkColumn == null) {
                                throw new SQLObjectException("relationship.populate.nullPkColumn");
                            }
                            m.fkColumn = relToModify.getFkTable().getColumnByName(fkColName, false, false);
                            if (m.fkColumn == null) {
                                m.setFkColName(fkColName);
                                m.setFkTable(relToModify.getFkTable());
                            }
                            relToModify.updateRule = UpdateDeleteRule.ruleForCode(updateRule);
                            relToModify.deleteRule = UpdateDeleteRule.ruleForCode(deleteRule);
                            relToModify.setName(fkName);
                            try {
                                relToModify.deferrability = Deferrability.ruleForCode(deferrability);
                            }
                            catch (IllegalArgumentException ex) {
                                logger.warn((Object)"Invalid code when reverse engineering relationship. Defaulting to NOT_DEFERRABLE.", (Throwable)ex);
                                relToModify.deferrability = Deferrability.NOT_DEFERRABLE;
                            }
                        }
                        catch (SQLObjectException e) {
                            throw new SQLObjectRuntimeException(e);
                        }
                        finally {
                            relToModify.setMagicEnabled(true);
                        }
                    }
                };
                try {
                    table.getRunnableDispatcher().runInForeground(runner);
                }
                catch (SessionNotFoundException e) {
                    runner.run();
                }
            }
            LinkedList<SQLRelationship> linkedList = newKeys;
            return linkedList;
        }
        catch (SQLException e) {
            throw new SQLObjectException("relationship.populate", e);
        }
        finally {
            try {
                if (crs != null) {
                    crs.close();
                }
            }
            catch (SQLException e) {
                logger.warn((Object)"Couldn't close resultset", (Throwable)e);
            }
        }
    }

    @NonProperty
    public ColumnMapping getMappingByPkCol(SQLColumn pkcol) {
        for (ColumnMapping m : this.mappings) {
            if (m.pkColumn != pkcol) continue;
            return m;
        }
        return null;
    }

    public void reassignMappingsByPkCol(SQLColumn pkCol) {
        for (ColumnMapping m : this.mappings) {
            if (m.pkColumn == null || m.pkColumn == pkCol || !m.pkColumn.getUUID().equals(pkCol.getUUID())) continue;
            m.setFkColumn(pkCol);
        }
    }

    public boolean containsPkColumn(SQLColumn col) {
        return this.getMappingByPkCol(col) != null;
    }

    @NonProperty
    public ColumnMapping getMappingByFkCol(SQLColumn fkcol) {
        for (ColumnMapping m : this.mappings) {
            if (m.fkColumn != fkcol) continue;
            return m;
        }
        return null;
    }

    public boolean containsFkColumn(SQLColumn col) {
        return this.getMappingByFkCol(col) != null;
    }

    public void reassignMappingsByFkCol(SQLColumn fkCol) {
        for (ColumnMapping m : this.mappings) {
            if (m.fkColumn == null || m.fkColumn == fkCol || !m.fkColumn.getUUID().equals(fkCol.getUUID())) continue;
            m.setFkColumn(fkCol);
        }
    }

    public String printKeyColumns(int keyType) {
        StringBuffer s = new StringBuffer();
        int i = 0;
        for (ColumnMapping cm : this.mappings) {
            if (i++ > 0) {
                s.append(",");
            }
            if (keyType == 4) {
                s.append(cm.getPkColumn().getName());
                continue;
            }
            s.append(cm.getFkColumn().getName());
        }
        return s.toString();
    }

    @Override
    protected void addChildImpl(SPObject child, int index) {
        if (!(child instanceof ColumnMapping)) {
            throw new IllegalArgumentException("The child " + child.getName() + " of type " + child.getClass() + " is not a valid child type of " + this.getClass() + ".");
        }
        this.addMapping((ColumnMapping)child, index);
    }

    public void addMapping(SQLColumn pkColumn, SQLColumn fkColumn) throws SQLObjectException {
        ColumnMapping cmap = new ColumnMapping();
        cmap.setPkColumn(pkColumn);
        cmap.setFkColumn(fkColumn);
        logger.debug((Object)("add column mapping: " + pkColumn.getParent() + "." + pkColumn.getName() + " to " + fkColumn.getParent() + "." + fkColumn.getName()));
        this.addMapping(cmap);
    }

    public void addMapping(ColumnMapping mapping) {
        this.addMapping(mapping, this.mappings.size());
    }

    public void addMapping(ColumnMapping mapping, int index) {
        this.mappings.add(index, mapping);
        mapping.setParent(this);
        this.fireChildAdded(ColumnMapping.class, mapping, index);
    }

    @Override
    public String toString() {
        return this.getShortDisplayName();
    }

    public void fixMappingNewChildInParent(SQLColumn col) {
        if (!this.getParent().isMagicEnabled()) {
            logger.debug((Object)("Magic disabled; not fixing mapping for " + col));
            return;
        }
        try {
            if (col.isPrimaryKey()) {
                this.ensureInMapping(col);
            } else {
                this.ensureNotInMapping(col);
            }
        }
        catch (SQLObjectException ex) {
            logger.warn((Object)"Couldn't add/remove mapped FK columns", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectRelationship(boolean isRelationship) {
        if (!this.getParent().isMagicEnabled()) {
            logger.debug((Object)("Magic disabled; ignoring relationship remove " + this));
            return;
        }
        if (this.isDisconnecting) {
            return;
        }
        try {
            this.detachListeners();
            try {
                this.isDisconnecting = true;
                if (isRelationship) {
                    SQLImportedKey fk = this.foreignKey;
                    fk.getParent().removeChild(fk);
                } else {
                    this.getParent().removeChild(this);
                }
            }
            catch (ObjectDependentException e1) {
                throw new RuntimeException(e1);
            }
            logger.debug((Object)("Removing references for mappings: " + this.getChildren()));
            ArrayList<ColumnMapping> mappings = new ArrayList<ColumnMapping>(this.getChildren(ColumnMapping.class));
            Collections.sort(mappings, Collections.reverseOrder(new ColumnMappingFKColumnOrderComparator()));
            for (ColumnMapping cm : mappings) {
                logger.debug((Object)("Removing reference to fkcol " + cm.getFkColumn()));
                if (cm.getFkColumn() == null) continue;
                cm.getFkColumn().removeReference();
            }
        }
        finally {
            this.isDisconnecting = false;
        }
    }

    public void fixMappingChildRemoved(SQLColumn col) {
        if (!col.getParent().isMagicEnabled()) {
            logger.debug((Object)("Magic disabled; not fixing mapping for " + col));
            return;
        }
        try {
            this.ensureNotInMapping(col);
        }
        catch (SQLObjectException ex) {
            logger.warn((Object)"Couldn't remove mapped FK columns", (Throwable)ex);
        }
    }

    public void tableDisconnected() {
        if (!this.getParent().isMagicEnabled() || !this.getFkTable().isMagicEnabled()) {
            logger.debug((Object)("Magic disabled; ignoring table disconnect that would clean up relationship " + this));
            return;
        }
        this.getParent().removeExportedKey(this);
    }

    protected void ensureInMapping(SQLColumn pkcol) throws SQLObjectException {
        if (!this.containsPkColumn(pkcol)) {
            SQLColumn fkcol;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("ensureInMapping(" + this.getName() + "): Adding " + pkcol.getParent().getName() + "." + pkcol.getName() + " to mapping"));
            }
            if (pkcol.getParent().equals(this.getFkTable())) {
                fkcol = new SQLColumn(pkcol);
                fkcol.setName(SQLRelationship.generateUniqueColumnName("Parent_" + pkcol.getName(), pkcol.getParent()));
            } else {
                fkcol = this.getFkTable().getColumnByName(pkcol.getName());
                if (fkcol == null) {
                    fkcol = new SQLColumn(pkcol);
                }
            }
            if (this.identifying && this.getParent() != this.getFkTable()) {
                int j;
                int i;
                int index = -1;
                int pkIndex = this.getPkTable().getColumnIndex(pkcol);
                for (i = pkIndex + 1; i < this.getPkTable().getPkSize(); ++i) {
                    for (j = 0; j < this.getFkTable().getPkSize(); ++j) {
                        if (!this.getFkTable().getColumn(j).getName().equals(this.getPkTable().getColumn(i).getName())) continue;
                        index = j;
                        break;
                    }
                    if (index >= 0) break;
                }
                if (index == -1) {
                    for (i = pkIndex - 1; i >= 0; --i) {
                        for (j = 0; j < this.getFkTable().getPkSize(); ++j) {
                            if (!this.getFkTable().getColumn(j).getName().equals(this.getPkTable().getColumn(i).getName())) continue;
                            index = j + 1;
                            break;
                        }
                        if (index >= 0) break;
                    }
                }
                if (index == -1) {
                    index = this.getFkTable().getPkSize();
                }
                this.getFkTable().addColumn(fkcol, index);
                this.getFkTable().addToPK(fkcol);
            } else {
                this.getFkTable().addColumn(fkcol);
            }
            logger.debug((Object)("ensureInMapping(" + this.getName() + "): added fkcol " + fkcol));
            fkcol.setAutoIncrement(false);
            this.addMapping(pkcol, fkcol);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureNotInMapping(SQLColumn pkcol) throws SQLObjectException {
        logger.debug((Object)("Removing " + pkcol.getParent() + "." + pkcol + " from mapping"));
        if (this.containsPkColumn(pkcol)) {
            ColumnMapping m = this.getMappingByPkCol(pkcol);
            try {
                this.removeChild(m);
            }
            catch (IllegalArgumentException e) {
                throw new SQLObjectException(e);
            }
            catch (ObjectDependentException e) {
                throw new SQLObjectException(e);
            }
            try {
                m.getFkColumn().setMagicEnabled(false);
                m.getFkColumn().removeReference();
            }
            finally {
                m.getFkColumn().setMagicEnabled(true);
            }
        }
    }

    @Override
    @Transient
    @Accessor
    public String getShortDisplayName() {
        return this.getName();
    }

    @Override
    protected void populateImpl() {
    }

    @Override
    @Transient
    @Accessor
    public boolean isPopulated() {
        return true;
    }

    @Accessor(isInteresting=true)
    public UpdateDeleteRule getUpdateRule() {
        return this.updateRule;
    }

    @Mutator
    public void setUpdateRule(UpdateDeleteRule rule) {
        UpdateDeleteRule oldRule = this.updateRule;
        this.updateRule = rule;
        this.firePropertyChange("updateRule", (Object)oldRule, (Object)rule);
    }

    @Accessor(isInteresting=true)
    public UpdateDeleteRule getDeleteRule() {
        return this.deleteRule;
    }

    @Mutator
    public void setDeleteRule(UpdateDeleteRule rule) {
        UpdateDeleteRule oldRule = this.deleteRule;
        this.deleteRule = rule;
        this.firePropertyChange("deleteRule", (Object)oldRule, (Object)rule);
    }

    @Accessor(isInteresting=true)
    public Deferrability getDeferrability() {
        return this.deferrability;
    }

    @Mutator
    public void setDeferrability(Deferrability argDeferrability) {
        if (argDeferrability == null) {
            throw new NullPointerException("Deferrability policy must not be null");
        }
        Deferrability oldDefferability = this.deferrability;
        this.deferrability = argDeferrability;
        this.firePropertyChange("deferrability", (Object)oldDefferability, (Object)argDeferrability);
    }

    @Accessor
    public int getPkCardinality() {
        return this.pkCardinality;
    }

    @Mutator
    public void setPkCardinality(int argPkCardinality) {
        int oldPkCardinality = this.pkCardinality;
        this.pkCardinality = argPkCardinality;
        this.firePropertyChange("pkCardinality", oldPkCardinality, argPkCardinality);
    }

    @Accessor
    public int getFkCardinality() {
        return this.fkCardinality;
    }

    @Mutator
    public void setFkCardinality(int argFkCardinality) {
        int oldFkCardinality = this.fkCardinality;
        this.fkCardinality = argFkCardinality;
        this.firePropertyChange("fkCardinality", oldFkCardinality, argFkCardinality);
    }

    @Accessor(isInteresting=true)
    public boolean isIdentifying() {
        return this.identifying;
    }

    @Mutator
    public void setIdentifying(boolean argIdentifying) throws SQLObjectException {
        try {
            this.fireTransactionStarted("Setting " + this.getName() + " to be identifying: " + argIdentifying);
            boolean oldIdentifying = this.identifying;
            if (this.identifying != argIdentifying) {
                this.identifying = argIdentifying;
                if (this.identifying) {
                    this.firePropertyChange("identifying", oldIdentifying, argIdentifying);
                    if (this.isMagicEnabled()) {
                        for (ColumnMapping m : this.getChildren(ColumnMapping.class)) {
                            if (m.getFkColumn() == null || m.getFkColumn().isPrimaryKey()) continue;
                            this.getFkTable().addToPK(m.getFkColumn());
                        }
                    }
                } else {
                    if (this.isMagicEnabled()) {
                        for (ColumnMapping m : this.getChildren(ColumnMapping.class)) {
                            if (m.getFkColumn() == null || !m.getFkColumn().isPrimaryKey()) continue;
                            this.getFkTable().moveAfterPK(m.getFkColumn());
                        }
                    }
                    this.firePropertyChange("identifying", oldIdentifying, argIdentifying);
                }
            }
            this.fireTransactionEnded();
        }
        catch (RuntimeException e) {
            this.fireTransactionRollback(e.getMessage());
            throw e;
        }
    }

    @Override
    @Accessor
    public SQLTable getParent() {
        return (SQLTable)super.getParent();
    }

    @Mutator
    public void setParent(SQLTable parent) {
        this.setParentHelper(parent);
    }

    @Accessor
    public SQLTable getPkTable() {
        return this.getParent();
    }

    @Transient
    @Accessor
    public SQLImportedKey getForeignKey() {
        return this.foreignKey;
    }

    @Transient
    @Mutator
    public void setForeignKey(SQLImportedKey newKey) {
        SQLImportedKey oldKey = this.foreignKey;
        this.foreignKey = newKey;
        this.firePropertyChange("foreignKey", oldKey, newKey);
    }

    @Override
    @Mutator
    public void setParent(SPObject parent) {
        this.setParentHelper(parent);
    }

    private void setParentHelper(SPObject parent) {
        SQLTable oldVal = this.getParent();
        super.setParent(parent);
        if (parent != null) {
            if (this.isMagicEnabled() && parent != oldVal) {
                try {
                    this.attachRelationship(true);
                }
                catch (SQLObjectException e) {
                    throw new RuntimeException(e);
                }
            } else {
                SQLPowerUtils.unlistenToHierarchy(this.getParent(), this.fkColumnUpdater);
                SQLPowerUtils.listenToHierarchy(this.getParent(), this.fkColumnUpdater);
            }
        }
    }

    @Transient
    @Accessor
    public SQLTable getFkTable() {
        if (this.foreignKey != null) {
            return this.foreignKey.getParent();
        }
        return null;
    }

    public void checkColumnLocked(SQLColumn col) throws LockedColumnException {
        for (ColumnMapping cm : this.getChildren(ColumnMapping.class)) {
            if (cm.getFkColumn() != col) continue;
            throw new LockedColumnException(this, col);
        }
    }

    public boolean determineIdentifyingStatus() throws SQLObjectException {
        if (this.getPkTable().getPkSize() > this.getFkTable().getPkSize()) {
            return false;
        }
        List<ColumnMapping> columnMappings = this.getChildren(ColumnMapping.class);
        SQLIndex pkTablePKIndex = this.getPkTable().getPrimaryKeyIndex();
        if (pkTablePKIndex == null) {
            return false;
        }
        List<SQLIndex.Column> pkColumns = pkTablePKIndex.getChildren(SQLIndex.Column.class);
        for (SQLIndex.Column col : pkColumns) {
            boolean colIsInFKTablePK = false;
            for (ColumnMapping mapping : columnMappings) {
                if (!mapping.getPkColumn().equals(col.getColumn()) || !mapping.getFkColumn().isPrimaryKey()) continue;
                colIsInFKTablePK = true;
                break;
            }
            if (colIsInFKTablePK) continue;
            return false;
        }
        return true;
    }

    public static SQLRelationship createRelationship(SQLTable pkTable, SQLTable fkTable, boolean identifying) throws SQLObjectException {
        SQLRelationship model = new SQLRelationship();
        StringBuilder sb = new StringBuilder();
        if (pkTable.getPhysicalName() == null || pkTable.getPhysicalName().trim().equals("")) {
            sb.append(pkTable.getName());
        } else {
            sb.append(pkTable.getPhysicalName());
        }
        sb.append("_");
        if (fkTable.getPhysicalName() == null || fkTable.getPhysicalName().trim().equals("")) {
            sb.append(fkTable.getName());
        } else {
            sb.append(fkTable.getPhysicalName());
        }
        sb.append("_fk");
        HashSet<String> rel = new HashSet<String>();
        SQLObject tableParent = pkTable.getParent();
        for (SQLTable tbl : tableParent.getChildren(SQLTable.class)) {
            for (SQLRelationship r : tbl.getChildren(SQLRelationship.class)) {
                rel.add(r.getPhysicalName());
            }
        }
        if (rel.contains(sb.toString())) {
            int i = 1;
            while (rel.contains(sb.toString() + Integer.toString(i))) {
                ++i;
            }
            sb.append(i);
        }
        model.setName(sb.toString());
        model.getForeignKey().setName(sb.toString());
        model.setIdentifying(identifying);
        model.attachRelationship(pkTable, fkTable, true);
        return model;
    }

    @Mutator
    public void setTextForParentLabel(String textForParentLabel) {
        String oldVal = this.textForParentLabel;
        this.textForParentLabel = textForParentLabel;
        this.firePropertyChange("textForParentLabel", oldVal, textForParentLabel);
    }

    @Accessor
    public String getTextForParentLabel() {
        return this.textForParentLabel;
    }

    @Mutator
    public void setTextForChildLabel(String textForChildLabel) {
        String oldVal = this.textForChildLabel;
        this.textForChildLabel = textForChildLabel;
        this.firePropertyChange("textForChildLabel", oldVal, textForChildLabel);
    }

    @Accessor
    public String getTextForChildLabel() {
        return this.textForChildLabel;
    }

    public List<ColumnMapping> getChildrenWithoutPopulating() {
        return Collections.unmodifiableList(new ArrayList<ColumnMapping>(this.mappings));
    }

    @Override
    protected boolean removeChildImpl(SPObject child) {
        if (child instanceof ColumnMapping) {
            return this.removeColumnMapping((ColumnMapping)child);
        }
        throw new IllegalArgumentException("Cannot remove children of type " + child.getClass() + " from " + this.getName());
    }

    public boolean removeColumnMapping(ColumnMapping child) {
        if (this.isMagicEnabled() && child.getParent() != this) {
            throw new IllegalStateException("Cannot remove child " + child.getName() + " of type " + child.getClass() + " as its parent is not " + this.getName() + "." + " The parent is " + child.getParent());
        }
        int index = this.mappings.indexOf(child);
        if (index != -1) {
            this.mappings.remove(index);
            this.fireChildRemoved(SQLTable.class, child, index);
            child.setParent(null);
            return true;
        }
        return false;
    }

    @Override
    public List<? extends SPObject> getDependencies() {
        return Collections.singletonList(this.foreignKey);
    }

    @Override
    public void removeDependency(SPObject dependency) {
        for (SQLObject sQLObject : this.getChildren()) {
            sQLObject.removeDependency(dependency);
        }
    }

    @Override
    public List<Class<? extends SPObject>> getAllowedChildTypes() {
        return allowedChildTypes;
    }

    public static class ColumnMapping
    extends SQLObject {
        public static final List<Class<? extends SPObject>> allowedChildTypes = Collections.emptyList();
        protected SQLColumn pkColumn;
        protected SQLColumn fkColumn;
        private SQLTable fkTable;
        private String fkColName;
        private boolean loading;
        private final SPListener fkTableListener = new AbstractSPListener(){

            @Override
            public void childAdded(SPChildEvent e) {
                if (e.getChild() instanceof SQLColumn && e.getChild().getName().equals(ColumnMapping.this.fkColName)) {
                    ColumnMapping.this.setFkColumn((SQLColumn)e.getChild());
                }
            }
        };

        public ColumnMapping() {
            this.setName("Column Mapping");
            this.setPopulated(true);
        }

        @Constructor
        public ColumnMapping(@ConstructorParameter(parameterType=ConstructorParameter.ParameterType.PROPERTY, propertyName="pkColumn") SQLColumn pkColumn) {
            this();
            this.setPkColumn(pkColumn);
            pkColumn.addReference();
            this.loading = true;
        }

        @Accessor
        public SQLColumn getPkColumn() {
            return this.pkColumn;
        }

        @Mutator
        public void setPkColumn(SQLColumn argPkColumn) {
            SQLColumn oldPK = this.pkColumn;
            this.pkColumn = argPkColumn;
            this.firePropertyChange("pkColumn", oldPK, argPkColumn);
        }

        @Accessor
        public SQLColumn getFkColumn() {
            if (this.fkColumn == null && this.fkColName != null && this.fkTable != null) {
                try {
                    this.setFkColumn(this.fkTable.getColumnByName(this.fkColName));
                }
                catch (SQLObjectException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.fkColumn;
        }

        @Mutator
        public void setFkColumn(SQLColumn argFkColumn) {
            try {
                this.begin("Setting column mapping fk column.");
                SQLColumn oldFK = this.fkColumn;
                this.fkColumn = argFkColumn;
                this.firePropertyChange("fkColumn", oldFK, argFkColumn);
                if (this.fkColumn != null) {
                    this.setFkTable(null);
                    this.setFkColName(null);
                }
                if (this.loading) {
                    this.fkColumn.addReference();
                    this.loading = false;
                }
                this.commit();
            }
            catch (RuntimeException e) {
                this.rollback(e.getMessage());
                throw e;
            }
        }

        @Override
        public String toString() {
            return this.getShortDisplayName();
        }

        @Override
        @Accessor
        public SQLRelationship getParent() {
            return (SQLRelationship)super.getParent();
        }

        @Mutator
        public void setParent(SQLRelationship parent) {
            super.setParent(parent);
        }

        @Override
        @Transient
        @Accessor
        public String getShortDisplayName() {
            if (this.pkColumn == null || this.fkColumn == null) {
                return "Incomplete mapping";
            }
            String fkTableName = null;
            if (this.fkColumn == null && this.fkTable != null) {
                fkTableName = this.fkTable.getName();
            } else if (this.fkColumn.getParent() != null) {
                fkTableName = this.fkColumn.getParent().getName();
            }
            String fkColumnName = null;
            if (this.fkColumn == null && this.fkColName != null) {
                fkColumnName = this.fkColName;
            } else if (this.fkColumn != null) {
                fkColumnName = this.fkColumn.getName();
            }
            return this.pkColumn.getName() + " - " + fkTableName + "." + fkColumnName;
        }

        @Override
        protected void populateImpl() throws SQLObjectException {
        }

        @Override
        @Transient
        @Accessor
        public boolean isPopulated() {
            return true;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof ColumnMapping) {
                ColumnMapping cmap = (ColumnMapping)obj;
                return this.fkColumn == cmap.fkColumn && this.pkColumn == cmap.pkColumn && this.fkTable == cmap.fkTable && this.fkColName == cmap.fkColName;
            }
            return false;
        }

        @Override
        public int hashCode() {
            int result = 17;
            result = result * 31 + (this.fkColumn == null ? 0 : this.fkColumn.hashCode());
            result = result * 31 + (this.pkColumn == null ? 0 : this.pkColumn.hashCode());
            result = result * 31 + (this.fkTable == null ? 0 : this.fkTable.hashCode());
            result = result * 31 + (this.fkColName == null ? 0 : this.fkColName.hashCode());
            return result;
        }

        @Override
        public List<? extends SQLObject> getChildrenWithoutPopulating() {
            return Collections.emptyList();
        }

        @Override
        protected boolean removeChildImpl(SPObject child) {
            return false;
        }

        @Override
        public List<? extends SPObject> getDependencies() {
            ArrayList<SQLColumn> dependencies = new ArrayList<SQLColumn>();
            dependencies.add(this.getFkColumn());
            dependencies.add(this.getPkColumn());
            return dependencies;
        }

        @Override
        public void removeDependency(SPObject dependency) {
            if (dependency == this.getFkColumn() || dependency == this.getPkColumn()) {
                this.getParent().removeColumnMapping(this);
            }
        }

        @Override
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        @Mutator
        public void setFkTable(SQLTable fkTable) {
            SQLTable oldTable = this.fkTable;
            this.fkTable = fkTable;
            if (oldTable != null) {
                oldTable.removeSPListener(this.fkTableListener);
            }
            if (fkTable != null) {
                fkTable.addSPListener(this.fkTableListener);
            }
            this.firePropertyChange("fkTable", oldTable, fkTable);
        }

        @Accessor
        public SQLTable getFkTable() {
            return this.fkTable;
        }

        @Mutator
        public void setFkColName(String fkColName) {
            String oldName = this.fkColName;
            this.fkColName = fkColName;
            this.firePropertyChange("fkColName", oldName, fkColName);
        }

        @Accessor
        public String getFkColName() {
            return this.fkColName;
        }
    }

    public static class SQLImportedKey
    extends SQLObject {
        private final SQLRelationship relationship;
        private final SPListener relationshipPropertyListener = new AbstractSPListener(){

            @Override
            public void propertyChanged(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("name")) {
                    SQLImportedKey.this.setName((String)evt.getNewValue());
                } else if (evt.getPropertyName().equals("populated")) {
                    SQLImportedKey.this.setPopulated((Boolean)evt.getNewValue());
                }
            }
        };
        private final SPListener fkTableListener = new AbstractSPListener(){

            @Override
            public void childAdded(SPChildEvent e) {
                if (e.getChild() instanceof SQLColumn) {
                    SQLImportedKey.this.relationship.reassignMappingsByFkCol((SQLColumn)e.getChild());
                }
            }
        };

        @Constructor
        public SQLImportedKey(@ConstructorParameter(propertyName="relationship") SQLRelationship relationship) {
            this.relationship = relationship;
            this.setName(relationship.getName());
            this.setPopulated(relationship.isPopulated());
            relationship.addSPListener(this.relationshipPropertyListener);
            relationship.setForeignKey(this);
        }

        @Override
        public SQLTable getParent() {
            return (SQLTable)super.getParent();
        }

        @Mutator
        public void setParent(SQLTable parent) {
            if (this.getParent() != null) {
                this.getParent().removeSPListener(this.fkTableListener);
            }
            super.setParent(parent);
            if (parent != null) {
                parent.addSPListener(this.fkTableListener);
            }
        }

        @Override
        public List<? extends SQLObject> getChildrenWithoutPopulating() {
            return Collections.emptyList();
        }

        @Override
        public String getShortDisplayName() {
            if (this.relationship != null) {
                return this.relationship.getShortDisplayName();
            }
            return this.getName();
        }

        @Override
        protected void populateImpl() throws SQLObjectException {
        }

        @Override
        protected boolean removeChildImpl(SPObject child) {
            return false;
        }

        @Override
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return Collections.emptyList();
        }

        @Override
        public List<? extends SPObject> getDependencies() {
            return Collections.emptyList();
        }

        @Override
        public void removeDependency(SPObject dependency) {
            throw new UnsupportedOperationException("Need to decide the correct dependency of this object.");
        }

        @Accessor
        public SQLRelationship getRelationship() {
            return this.relationship;
        }

        @Override
        public String toString() {
            return this.getShortDisplayName();
        }

        @Override
        public final void updateToMatch(SQLObject source) throws SQLObjectException {
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof SQLImportedKey) {
                SQLImportedKey key = (SQLImportedKey)obj;
                return (this.getName() == null && key.getName() == null || this.getName().equals(key.getName())) && this.relationship.equals(key.getRelationship());
            }
            return false;
        }

        @Override
        public int hashCode() {
            int result = 17;
            result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
            result = 31 * this.relationship.hashCode();
            return result;
        }
    }

    public static enum UpdateDeleteRule {
        CASCADE(0),
        RESTRICT(1),
        SET_NULL(2),
        NO_ACTION(3),
        SET_DEFAULT(4);

        private final int code;

        private UpdateDeleteRule(int code) {
            this.code = code;
        }

        public static UpdateDeleteRule ruleForCode(int code) {
            for (UpdateDeleteRule r : UpdateDeleteRule.values()) {
                if (r.code != code) continue;
                return r;
            }
            throw new IllegalArgumentException("No such update/delete rule code " + code);
        }

        public int getCode() {
            return this.code;
        }
    }

    public static enum Deferrability {
        INITIALLY_DEFERRED(5),
        INITIALLY_IMMEDIATE(6),
        NOT_DEFERRABLE(7);

        private final int code;

        private Deferrability(int code) {
            this.code = code;
        }

        public static Deferrability ruleForCode(int code) {
            for (Deferrability d : Deferrability.values()) {
                if (d.code != code) continue;
                return d;
            }
            throw new IllegalArgumentException("No such deferrability code " + code);
        }

        public static Deferrability ruleForCode(int code, Deferrability defaultValue) {
            for (Deferrability d : Deferrability.values()) {
                if (d.code != code) continue;
                return d;
            }
            return defaultValue;
        }

        public int getCode() {
            return this.code;
        }
    }

    public static class ColumnMappingFKColumnOrderComparator
    implements Comparator<ColumnMapping> {
        @Override
        public int compare(ColumnMapping o1, ColumnMapping o2) {
            int fkPos2;
            int fkPos1 = o1.getFkColumn().getParent().getChildren().indexOf(o1.getFkColumn());
            if (fkPos1 == (fkPos2 = o2.getFkColumn().getParent().getChildren().indexOf(o2.getFkColumn()))) {
                return 0;
            }
            if (fkPos1 < fkPos2) {
                return -1;
            }
            return 1;
        }
    }
}

