/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sqlobject.generated;

import ca.sqlpower.dao.PersistedSPOProperty;
import ca.sqlpower.dao.PersistedSPObject;
import ca.sqlpower.dao.SPPersistenceException;
import ca.sqlpower.dao.SPPersister;
import ca.sqlpower.dao.session.SessionPersisterSuperConverter;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.sqlobject.SQLCatalog;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.generated.SQLObjectPersisterHelper;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SQLCatalogPersisterHelper
extends SQLObjectPersisterHelper<SQLCatalog> {
    private List<String> persistedPropertiesList = null;

    @Override
    public SQLCatalog commitObject(PersistedSPObject pso, Multimap<String, PersistedSPOProperty> persistedProperties, List<PersistedSPObject> persistedObjects, SessionPersisterSuperConverter converter) throws SPPersistenceException {
        SQLCatalog o;
        String uuid = pso.getUUID();
        SQLDatabase parent = (SQLDatabase)converter.convertToComplexType(SQLCatalogPersisterHelper.findPropertyAndRemove(uuid, "parent", persistedProperties), SQLDatabase.class);
        String name = (String)converter.convertToComplexType(SQLCatalogPersisterHelper.findPropertyAndRemove(uuid, "name", persistedProperties), String.class);
        try {
            o = new SQLCatalog(parent, name);
        }
        catch (Exception e) {
            throw new SPPersistenceException(null, e);
        }
        o.setUUID(uuid);
        pso.setLoaded(true);
        return o;
    }

    @Override
    public void commitProperty(SPObject o, String propertyName, Object newValue, SPPersister.DataType dataType, SessionPersisterSuperConverter converter) throws SPPersistenceException {
        SQLCatalog castedObject = (SQLCatalog)o;
        if (propertyName.equals("parent")) {
            castedObject.setParent((SQLDatabase)converter.convertToComplexType(newValue, SQLDatabase.class));
        } else if (propertyName.equals("nativeTerm")) {
            castedObject.setNativeTerm((String)converter.convertToComplexType(newValue, String.class));
        } else {
            super.commitProperty(o, propertyName, newValue, dataType, converter);
        }
    }

    @Override
    public Object findProperty(SPObject o, String propertyName, SessionPersisterSuperConverter converter) throws SPPersistenceException {
        SQLCatalog castedObject = (SQLCatalog)o;
        if (propertyName.equals("parent")) {
            return converter.convertToBasicType(castedObject.getParent(), new Object[0]);
        }
        if (propertyName.equals("nativeTerm")) {
            return converter.convertToBasicType(castedObject.getNativeTerm(), new Object[0]);
        }
        return super.findProperty(o, propertyName, converter);
    }

    @Override
    public void persistObject(SPObject o, int index, SPPersister persister, SessionPersisterSuperConverter converter) throws SPPersistenceException {
        SQLCatalog castedObject = (SQLCatalog)o;
        String uuid = castedObject.getUUID();
        String parentUUID = null;
        if (castedObject.getParent() != null) {
            parentUUID = castedObject.getParent().getUUID();
        }
        persister.persistObject(parentUUID, "ca.sqlpower.sqlobject.SQLCatalog", uuid, index);
        ArrayList<String> preProcessedProperties = new ArrayList<String>();
        try {
            SPPersister.DataType dataType = SPPersister.DataType.REFERENCE;
            persister.persistProperty(uuid, "parent", dataType, converter.convertToBasicType(castedObject.getParent(), new Object[0]));
            preProcessedProperties.add("parent");
            dataType = SPPersister.DataType.STRING;
            persister.persistProperty(uuid, "name", dataType, converter.convertToBasicType(castedObject.getName(), new Object[0]));
            preProcessedProperties.add("name");
            this.persistObjectProperties(o, persister, converter, preProcessedProperties);
        }
        catch (Exception e) {
            throw new SPPersistenceException(uuid, e);
        }
    }

    @Override
    public void persistObjectProperties(SPObject o, SPPersister persister, SessionPersisterSuperConverter converter, List<String> staticPreProcessedProps) throws SPPersistenceException {
        ArrayList<String> preProcessedProps = new ArrayList<String>(staticPreProcessedProps);
        String uuid = o.getUUID();
        SQLCatalog castedObject = (SQLCatalog)o;
        try {
            SPPersister.DataType dataType;
            if (!preProcessedProps.contains("parent")) {
                dataType = SPPersister.DataType.REFERENCE;
                persister.persistProperty(uuid, "parent", dataType, converter.convertToBasicType(castedObject.getParent(), new Object[0]));
                preProcessedProps.add("parent");
            }
            if (!preProcessedProps.contains("nativeTerm")) {
                dataType = SPPersister.DataType.STRING;
                persister.persistProperty(uuid, "nativeTerm", dataType, converter.convertToBasicType(castedObject.getNativeTerm(), new Object[0]));
                preProcessedProps.add("nativeTerm");
            }
        }
        catch (Exception e) {
            throw new SPPersistenceException(uuid, e);
        }
        super.persistObjectProperties(o, persister, converter, preProcessedProps);
    }

    @Override
    public List<String> getPersistedProperties() throws SPPersistenceException {
        if (this.persistedPropertiesList != null) {
            return this.persistedPropertiesList;
        }
        String[] persistedPropertiesArray = new String[]{"parent", "nativeTerm"};
        this.persistedPropertiesList = new ArrayList<String>(Arrays.asList(persistedPropertiesArray));
        this.persistedPropertiesList.addAll(super.getPersistedProperties());
        return this.persistedPropertiesList;
    }
}

