/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sqlobject.generated;

import ca.sqlpower.dao.PersistedSPOProperty;
import ca.sqlpower.dao.PersistedSPObject;
import ca.sqlpower.dao.SPPersistenceException;
import ca.sqlpower.dao.SPPersister;
import ca.sqlpower.dao.session.SessionPersisterSuperConverter;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.sql.JDBCDataSource;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.generated.SQLObjectPersisterHelper;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SQLDatabasePersisterHelper
extends SQLObjectPersisterHelper<SQLDatabase> {
    private List<String> persistedPropertiesList = null;

    @Override
    public SQLDatabase commitObject(PersistedSPObject pso, Multimap<String, PersistedSPOProperty> persistedProperties, List<PersistedSPObject> persistedObjects, SessionPersisterSuperConverter converter) throws SPPersistenceException {
        SQLDatabase o;
        String uuid = pso.getUUID();
        JDBCDataSource dataSource = (JDBCDataSource)converter.convertToComplexType(SQLDatabasePersisterHelper.findPropertyAndRemove(uuid, "dataSource", persistedProperties), JDBCDataSource.class);
        try {
            o = new SQLDatabase(dataSource);
        }
        catch (Exception e) {
            throw new SPPersistenceException(null, e);
        }
        o.setUUID(uuid);
        pso.setLoaded(true);
        return o;
    }

    @Override
    public void commitProperty(SPObject o, String propertyName, Object newValue, SPPersister.DataType dataType, SessionPersisterSuperConverter converter) throws SPPersistenceException {
        SQLDatabase castedObject = (SQLDatabase)o;
        if (propertyName.equals("playPenDatabase")) {
            castedObject.setPlayPenDatabase((Boolean)converter.convertToComplexType(newValue, Boolean.class));
        } else if (propertyName.equals("name")) {
            castedObject.setName((String)converter.convertToComplexType(newValue, String.class));
        } else if (propertyName.equals("dataSource")) {
            castedObject.setDataSource((JDBCDataSource)converter.convertToComplexType(newValue, JDBCDataSource.class));
        } else {
            super.commitProperty(o, propertyName, newValue, dataType, converter);
        }
    }

    @Override
    public Object findProperty(SPObject o, String propertyName, SessionPersisterSuperConverter converter) throws SPPersistenceException {
        SQLDatabase castedObject = (SQLDatabase)o;
        if (propertyName.equals("dataSource")) {
            return converter.convertToBasicType(castedObject.getDataSource(), new Object[0]);
        }
        if (propertyName.equals("name")) {
            return converter.convertToBasicType(castedObject.getName(), new Object[0]);
        }
        if (propertyName.equals("playPenDatabase")) {
            return converter.convertToBasicType(castedObject.isPlayPenDatabase(), new Object[0]);
        }
        return super.findProperty(o, propertyName, converter);
    }

    @Override
    public void persistObject(SPObject o, int index, SPPersister persister, SessionPersisterSuperConverter converter) throws SPPersistenceException {
        SQLDatabase castedObject = (SQLDatabase)o;
        String uuid = castedObject.getUUID();
        String parentUUID = null;
        if (castedObject.getParent() != null) {
            parentUUID = castedObject.getParent().getUUID();
        }
        persister.persistObject(parentUUID, "ca.sqlpower.sqlobject.SQLDatabase", uuid, index);
        ArrayList<String> preProcessedProperties = new ArrayList<String>();
        try {
            SPPersister.DataType dataType = SPPersister.DataType.STRING;
            persister.persistProperty(uuid, "dataSource", dataType, converter.convertToBasicType(castedObject.getDataSource(), new Object[0]));
            preProcessedProperties.add("dataSource");
            this.persistObjectProperties(o, persister, converter, preProcessedProperties);
        }
        catch (Exception e) {
            throw new SPPersistenceException(uuid, e);
        }
    }

    @Override
    public void persistObjectProperties(SPObject o, SPPersister persister, SessionPersisterSuperConverter converter, List<String> staticPreProcessedProps) throws SPPersistenceException {
        ArrayList<String> preProcessedProps = new ArrayList<String>(staticPreProcessedProps);
        String uuid = o.getUUID();
        SQLDatabase castedObject = (SQLDatabase)o;
        try {
            SPPersister.DataType dataType;
            if (!preProcessedProps.contains("dataSource")) {
                dataType = SPPersister.DataType.STRING;
                persister.persistProperty(uuid, "dataSource", dataType, converter.convertToBasicType(castedObject.getDataSource(), new Object[0]));
                preProcessedProps.add("dataSource");
            }
            if (!preProcessedProps.contains("name")) {
                dataType = SPPersister.DataType.STRING;
                persister.persistProperty(uuid, "name", dataType, converter.convertToBasicType(castedObject.getName(), new Object[0]));
                preProcessedProps.add("name");
            }
            if (!preProcessedProps.contains("playPenDatabase")) {
                dataType = SPPersister.DataType.BOOLEAN;
                persister.persistProperty(uuid, "playPenDatabase", dataType, converter.convertToBasicType(castedObject.isPlayPenDatabase(), new Object[0]));
                preProcessedProps.add("playPenDatabase");
            }
        }
        catch (Exception e) {
            throw new SPPersistenceException(uuid, e);
        }
        super.persistObjectProperties(o, persister, converter, preProcessedProps);
    }

    @Override
    public List<String> getPersistedProperties() throws SPPersistenceException {
        if (this.persistedPropertiesList != null) {
            return this.persistedPropertiesList;
        }
        String[] persistedPropertiesArray = new String[]{"playPenDatabase", "name", "dataSource"};
        this.persistedPropertiesList = new ArrayList<String>(Arrays.asList(persistedPropertiesArray));
        this.persistedPropertiesList.addAll(super.getPersistedProperties());
        return this.persistedPropertiesList;
    }
}

