/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui;

import ca.sqlpower.swingui.ComposedIcon;
import ca.sqlpower.swingui.Search;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SearchTextField {
    private static final ImageIcon SEARCH_ICON = new ImageIcon(SearchTextField.class.getClassLoader().getResource("ca/sqlpower/swingui/search.png"));
    private static final ImageIcon REG_EX_ICON = new ImageIcon(SearchTextField.class.getClassLoader().getResource("ca/sqlpower/swingui/searchField_rx.png"));
    private static final ImageIcon EXACT_MATCH_ICON = new ImageIcon(SearchTextField.class.getClassLoader().getResource("ca/sqlpower/swingui/searchField_xm.png"));
    private static final ImageIcon SUBSTRING_ICON = new ImageIcon(SearchTextField.class.getClassLoader().getResource("ca/sqlpower/swingui/searchField_ss.png"));
    private static final ImageIcon DOWN_ARROW_ICON = new ImageIcon(SearchTextField.class.getClassLoader().getResource("ca/sqlpower/swingui/downarrow.png"));
    private final JPanel panel;
    private final JTextField searchText;
    private final JPopupMenu searchTypePopup;
    private SearchType searchType = SearchType.SUBSTRING;
    private final Search search;
    private JLabel searchTypeIcon;

    public SearchTextField(Search s, int columns) {
        this.search = s;
        this.searchTypePopup = new JPopupMenu();
        this.searchTypePopup.add(new JMenuItem(new AbstractAction("Substring"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchTextField.this.searchType = SearchType.SUBSTRING;
                SearchTextField.this.searchTypeIcon.setIcon(SearchTextField.this.composeWithArrow(SUBSTRING_ICON));
                SearchTextField.this.doSearch();
            }
        }));
        this.searchTypePopup.add(new JMenuItem(new AbstractAction("Regular Exp"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchTextField.this.searchType = SearchType.REG_EX;
                SearchTextField.this.searchTypeIcon.setIcon(SearchTextField.this.composeWithArrow(REG_EX_ICON));
                SearchTextField.this.doSearch();
            }
        }));
        this.searchTypePopup.add(new JMenuItem(new AbstractAction("Exact Match"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchTextField.this.searchType = SearchType.EXACT_MATCH;
                SearchTextField.this.searchTypeIcon.setIcon(SearchTextField.this.composeWithArrow(EXACT_MATCH_ICON));
                SearchTextField.this.doSearch();
            }
        }));
        this.panel = new JPanel();
        this.searchText = new JTextField(columns);
        this.searchText.setPreferredSize(new Dimension(this.searchText.getPreferredSize().width, 20));
        this.panel.setLayout(new BorderLayout());
        JLabel searchIconLabel = new JLabel(SEARCH_ICON);
        searchIconLabel.setBackground(this.searchText.getBackground());
        this.searchTypeIcon = new JLabel(this.composeWithArrow(SUBSTRING_ICON));
        this.searchTypeIcon.setBackground(this.searchText.getBackground());
        this.searchTypeIcon.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SearchTextField.this.searchTypePopup.show(SearchTextField.this.panel, SearchTextField.this.searchTypeIcon.getX(), SearchTextField.this.searchTypeIcon.getY() + SearchTextField.this.searchTypeIcon.getHeight());
            }
        });
        this.panel.setBorder(this.searchText.getBorder());
        this.panel.setBackground(this.searchText.getBackground());
        this.searchText.setBorder(null);
        this.panel.add((Component)searchIconLabel, "West");
        this.panel.add(this.searchText);
        this.panel.add((Component)this.searchTypeIcon, "East");
        this.searchText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                SearchTextField.this.doSearch();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SearchTextField.this.doSearch();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SearchTextField.this.doSearch();
            }
        });
    }

    public void doSearch() {
        boolean matchExactly;
        Pattern p;
        try {
            switch (this.searchType) {
                case REG_EX: {
                    p = Pattern.compile(this.getText(), 2);
                    matchExactly = true;
                    break;
                }
                case SUBSTRING: {
                    p = Pattern.compile(this.getText(), 18);
                    matchExactly = false;
                    break;
                }
                case EXACT_MATCH: {
                    p = Pattern.compile(this.getText(), 18);
                    matchExactly = true;
                    break;
                }
                default: {
                    throw new RuntimeException("Searching on the type " + (Object)((Object)this.searchType) + " has not been implemented.");
                }
            }
        }
        catch (PatternSyntaxException e) {
            p = Pattern.compile("");
            matchExactly = false;
        }
        this.search.doSearch(p, matchExactly);
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public JTextField getTextField() {
        return this.searchText;
    }

    public String getText() {
        return this.searchText.getText();
    }

    public void setText(String text) {
        this.searchText.setText(text);
    }

    public void clear() {
        this.searchText.setText("");
    }

    private Icon composeWithArrow(Icon baseIcon) {
        return new ComposedIcon(Arrays.asList(baseIcon, DOWN_ARROW_ICON));
    }

    private static enum SearchType {
        SUBSTRING,
        REG_EX,
        EXACT_MATCH;

    }
}

