/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui;

import ca.sqlpower.swingui.Messages;
import ca.sqlpower.swingui.SPSUtils;
import ca.sqlpower.util.UserPrompter;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class TextUserPrompter
implements UserPrompter {
    private final JTextField textField;
    private final JDialog prompt;
    private UserPrompter.UserPromptResponse response;
    private final UserPrompter.UserPromptResponse defaultResponseType;
    private final Window owner;

    public TextUserPrompter(Window owner, String question, UserPrompter.UserPromptResponse defaultResponseType, Object defaultResponse, String okName, String cancelName) {
        this.owner = owner;
        this.defaultResponseType = defaultResponseType;
        this.textField = new JTextField((String)defaultResponse);
        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("pref"));
        builder.setDefaultDialogBorder();
        builder.append((Component)new JLabel(question));
        builder.nextLine();
        builder.append((Component)this.textField);
        builder.nextLine();
        JButton okButton = new JButton(new AbstractAction(okName){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextUserPrompter.this.response = UserPrompter.UserPromptResponse.OK;
                TextUserPrompter.this.prompt.dispose();
            }
        });
        JButton cancelButton = new JButton(new AbstractAction(cancelName){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextUserPrompter.this.response = UserPrompter.UserPromptResponse.CANCEL;
                TextUserPrompter.this.prompt.dispose();
            }
        });
        JPanel okCancelBar = ButtonBarFactory.buildOKCancelBar((JButton)okButton, (JButton)cancelButton);
        builder.append((Component)okCancelBar);
        this.prompt = new JDialog(owner);
        this.prompt.add(builder.getPanel());
    }

    @Override
    public Object getUserSelectedResponse() {
        if (UserPrompter.UserPromptResponse.OK.equals((Object)this.response)) {
            return this.textField.getText();
        }
        return null;
    }

    @Override
    public UserPrompter.UserPromptResponse promptUser(Object ... formatArgs) {
        this.response = this.defaultResponseType;
        Runnable promptUser = new Runnable(){

            @Override
            public void run() {
                TextUserPrompter.this.prompt.pack();
                TextUserPrompter.this.prompt.setLocationRelativeTo(TextUserPrompter.this.owner);
                TextUserPrompter.this.prompt.setVisible(true);
            }
        };
        this.prompt.setModal(true);
        if (SwingUtilities.isEventDispatchThread()) {
            promptUser.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(promptUser);
            }
            catch (InterruptedException e) {
                SPSUtils.showExceptionDialogNoReport(this.owner, Messages.getString("ModalDialogUserPrompter.showPromptDialogFailed"), e);
            }
            catch (InvocationTargetException e) {
                SPSUtils.showExceptionDialogNoReport(this.owner, Messages.getString("ModalDialogUserPrompter.showPromptDialogFailed"), e);
            }
        }
        return this.response;
    }
}

