/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui.dbtree;

import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLTable;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;

public class SQLObjectSelection
implements Transferable {
    public static final DataFlavor LOCAL_SQLOBJECT_ARRAY_FLAVOUR = new DataFlavor("application/x-java-jvm-local-objectref; class=\"[Lca.sqlpower.sqlobject.SQLObject;\"", "Local Array of SQLObject");
    public static final DataFlavor SQLOBJECT_NAMES = new DataFlavor(String[].class, "List of selected object names");
    public static final DataFlavor MULTILINE_SQLOBJECT_NAMES = new DataFlavor(String.class, "List of selected object names as one string separated by newlines");
    private final SQLObject[] sqlObjects;
    private final String[] sqlObjectNames;
    private final String sqlObjectNamesNewlineSeparated;
    private boolean isLocal = true;

    public SQLObjectSelection(Collection<SQLObject> sqlObjects) {
        this(sqlObjects.toArray(new SQLObject[sqlObjects.size()]));
    }

    public SQLObjectSelection(SQLObject[] sqlObjects) {
        if (sqlObjects == null) {
            throw new NullPointerException("Can't transfer a null array. Try an empty one instead!");
        }
        this.sqlObjects = sqlObjects;
        this.sqlObjectNames = this.getObjectNames(sqlObjects);
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (SQLObject o : sqlObjects) {
            if (!first) {
                sb.append("\n");
            }
            sb.append(this.getObjectName(o));
            first = false;
        }
        this.sqlObjectNamesNewlineSeparated = sb.toString();
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor == LOCAL_SQLOBJECT_ARRAY_FLAVOUR) {
            return this.sqlObjects;
        }
        if (flavor == SQLOBJECT_NAMES) {
            return this.sqlObjectNames;
        }
        if (flavor == MULTILINE_SQLOBJECT_NAMES) {
            return this.sqlObjectNamesNewlineSeparated;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        if (this.isLocal) {
            return new DataFlavor[]{LOCAL_SQLOBJECT_ARRAY_FLAVOUR, SQLOBJECT_NAMES, MULTILINE_SQLOBJECT_NAMES};
        }
        return new DataFlavor[]{SQLOBJECT_NAMES, MULTILINE_SQLOBJECT_NAMES};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return this.isLocal && flavor == LOCAL_SQLOBJECT_ARRAY_FLAVOUR || flavor == SQLOBJECT_NAMES || flavor == MULTILINE_SQLOBJECT_NAMES;
    }

    private String[] getObjectNames(SQLObject[] objects) {
        String[] nodeNames = new String[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            SQLObject object = objects[i];
            nodeNames[i] = this.getObjectName(object);
        }
        return nodeNames;
    }

    private String getObjectName(SQLObject object) {
        String nodeName = object instanceof SQLTable ? ((SQLTable)object).toQualifiedName() : (object instanceof SQLColumn ? ((SQLColumn)object).getParent().getName() + "." + ((SQLColumn)object).getName() : object.getName());
        return nodeName;
    }

    public String toString() {
        return Arrays.toString(this.sqlObjectNames);
    }

    public void setLocal(boolean isLocal) {
        this.isLocal = isLocal;
    }

    public SQLObject[] getSqlObjects() {
        return this.sqlObjects;
    }
}

