/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui.enterprise.client;

import ca.sqlpower.enterprise.client.ConnectionTestAction;
import ca.sqlpower.enterprise.client.SPServerInfo;
import ca.sqlpower.swingui.DataEntryPanel;
import ca.sqlpower.swingui.enterprise.client.Messages;
import ca.sqlpower.util.Version;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class SPServerInfoPanel
implements DataEntryPanel {
    private final Component dialogOwner;
    private final JPanel panel;
    private JTextField name;
    private JTextField host;
    private JTextField port;
    private JTextField path;
    private JTextField username;
    private JPasswordField password;
    private JButton testButton;
    private final Version clientVersion;
    private final boolean passwordAllowed;
    private final String defaultScheme;

    public SPServerInfoPanel(Component dialogOwner, Version clientVersion, SPServerInfo defaultSettings) {
        this.dialogOwner = dialogOwner;
        this.panel = this.buildUI(defaultSettings);
        this.defaultScheme = defaultSettings.getScheme();
        this.passwordAllowed = defaultSettings.isPasswordAllowed();
        this.clientVersion = clientVersion;
    }

    private JPanel buildUI(SPServerInfo si) {
        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("pref, 4dlu, max(100dlu; pref):grow"));
        this.name = new JTextField(si.getName());
        builder.append(Messages.getString("SPServerInfoPanel.displayNameField"), (Component)this.name);
        this.host = new JTextField(si.getServerAddress());
        builder.append(Messages.getString("SPServerInfoPanel.hostField"), (Component)this.host);
        this.port = new JTextField(String.valueOf(si.getPort()));
        builder.append(Messages.getString("SPServerInfoPanel.portField"), (Component)this.port);
        this.path = new JTextField(si.getPath());
        builder.append(Messages.getString("SPServerInfoPanel.pathField"), (Component)this.path);
        this.username = new JTextField(si.getUsername());
        builder.append(Messages.getString("SPServerInfoPanel.usernameField"), (Component)this.username);
        if (si.isPasswordAllowed()) {
            this.password = new JPasswordField(si.getPassword());
            builder.append(Messages.getString("SPServerInfoPanel.passwordField"), (Component)this.password);
        }
        this.testButton = new JButton(Messages.getString("SPServerInfoPanel.testConnectionButton"));
        builder.append((Component)this.testButton);
        builder.appendParagraphGapRow();
        return builder.getPanel();
    }

    public void setTestAction(ConnectionTestAction action) {
        this.testButton.setAction(action);
    }

    public SPServerInfo getServerInfo() {
        int port = Integer.parseInt(this.port.getText());
        SPServerInfo si = this.passwordAllowed ? new SPServerInfo(this.name.getText(), this.host.getText(), port, this.path.getText(), this.username.getText(), new String(this.password.getPassword())) : new SPServerInfo(this.defaultScheme, this.name.getText(), this.host.getText(), port, this.path.getText(), this.username.getText());
        return si;
    }

    @Override
    public JComponent getPanel() {
        return this.panel;
    }

    @Override
    public boolean applyChanges() {
        String path;
        if (this.name.getText() == null || this.name.getText().equals("")) {
            JOptionPane.showMessageDialog(this.dialogOwner, Messages.getString("SPServerInfoPanel.giveConnectionName"), Messages.getString("SPServerInfoPanel.nameRequired"), 0);
            return false;
        }
        String port = this.port.getText();
        try {
            Integer.parseInt(port);
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(this.dialogOwner, Messages.getString("SPServerInfoPanel.portMustBeNumber"), Messages.getString("SPServerInfoPanel.invalidPortNumber"), 0);
            return false;
        }
        if (!this.path.getText().startsWith("/")) {
            this.path.setText("/".concat(this.path.getText() == null ? "" : this.path.getText()));
        }
        if ((path = this.path.getText()) == null || path.length() < 2) {
            JOptionPane.showMessageDialog(this.dialogOwner, Messages.getString("SPServerInfoPanel.pathMustBeginWithSlash"), Messages.getString("SPServerInfoPanel.invalidSetting"), 0);
            return false;
        }
        if (this.host.getText().startsWith("http://")) {
            this.host.setText(this.host.getText().replace("http://", ""));
        }
        String host = this.host.getText();
        try {
            new URI("http", null, host, Integer.parseInt(port), path, null, null);
        }
        catch (URISyntaxException e) {
            JOptionPane.showMessageDialog(this.dialogOwner, Messages.getString("SPServerInfoPanel.problemWithHostName"), "", 0);
            return false;
        }
        return true;
    }

    @Override
    public void discardChanges() {
    }

    @Override
    public boolean hasUnsavedChanges() {
        return true;
    }
}

