/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui.object;

import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.WorkspaceGraphModel;
import ca.sqlpower.swingui.object.WorkspaceGraphTreeNodeWrapper;
import ca.sqlpower.util.SQLPowerUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class WorkspaceGraphTreeModel
implements TreeModel {
    private final List<TreeModelListener> treeModelListeners = new ArrayList<TreeModelListener>();
    private WorkspaceGraphTreeNodeWrapper rootTreeNode;
    private final boolean skipAncestors;
    private final List<Class<? extends SPObject>> skipObjects;

    public WorkspaceGraphTreeModel(WorkspaceGraphModel model) {
        this(model, false, Collections.emptyList());
    }

    public WorkspaceGraphTreeModel(WorkspaceGraphModel model, boolean skipAncestors, List<Class<? extends SPObject>> skipObjects) {
        this.skipAncestors = skipAncestors;
        this.skipObjects = skipObjects;
        this.rootTreeNode = this.addNodeToTree(null, model.getGraphStartNode(), model);
    }

    private WorkspaceGraphTreeNodeWrapper addNodeToTree(WorkspaceGraphTreeNodeWrapper parent, SPObject nodeToAdd, WorkspaceGraphModel graph) {
        for (WorkspaceGraphTreeNodeWrapper ancestor = parent; ancestor != null; ancestor = ancestor.getParent()) {
            if (!ancestor.getWrappedObject().equals(nodeToAdd)) continue;
            return null;
        }
        if (this.skipAncestors && SQLPowerUtils.getAncestorList(graph.getGraphStartNode()).contains(nodeToAdd)) {
            return null;
        }
        if (this.skipObjects.contains(nodeToAdd.getClass())) {
            for (SPObject child : graph.getAdjacentNodes(nodeToAdd)) {
                this.addNodeToTree(parent, child, graph);
            }
            return null;
        }
        WorkspaceGraphTreeNodeWrapper newTreeNode = new WorkspaceGraphTreeNodeWrapper(nodeToAdd);
        if (parent != null) {
            parent.addChild(newTreeNode);
        }
        for (SPObject child : graph.getAdjacentNodes(nodeToAdd)) {
            this.addNodeToTree(newTreeNode, child, graph);
        }
        return newTreeNode;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.remove(l);
    }

    @Override
    public Object getChild(Object parent, int index) {
        return ((WorkspaceGraphTreeNodeWrapper)parent).getChild(index);
    }

    @Override
    public int getChildCount(Object parent) {
        return ((WorkspaceGraphTreeNodeWrapper)parent).getChildren().size();
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return ((WorkspaceGraphTreeNodeWrapper)parent).getIndexOfChild((WorkspaceGraphTreeNodeWrapper)child);
    }

    @Override
    public Object getRoot() {
        return this.rootTreeNode;
    }

    @Override
    public boolean isLeaf(Object node) {
        return ((WorkspaceGraphTreeNodeWrapper)node).getChildren().isEmpty();
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        throw new IllegalStateException("This tree represents a graph and cannot be changed unless the underlying graph is changed.");
    }
}

