/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui.object;

import ca.sqlpower.object.SPObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class WorkspaceGraphTreeNodeWrapper {
    private final SPObject wrappedObject;
    private final List<WorkspaceGraphTreeNodeWrapper> children = new ArrayList<WorkspaceGraphTreeNodeWrapper>();
    private WorkspaceGraphTreeNodeWrapper parent;

    public WorkspaceGraphTreeNodeWrapper(SPObject wrappedObject) {
        this.wrappedObject = wrappedObject;
    }

    public SPObject getWrappedObject() {
        return this.wrappedObject;
    }

    public void setParent(WorkspaceGraphTreeNodeWrapper parent) {
        this.parent = parent;
    }

    public WorkspaceGraphTreeNodeWrapper getParent() {
        return this.parent;
    }

    public void addChild(WorkspaceGraphTreeNodeWrapper child) {
        this.children.add(child);
        child.setParent(this);
    }

    public void removeChild(WorkspaceGraphTreeNodeWrapper child) {
        this.children.remove(child);
        child.setParent(null);
    }

    public List<WorkspaceGraphTreeNodeWrapper> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public int getIndexOfChild(WorkspaceGraphTreeNodeWrapper child) {
        return this.children.indexOf(child);
    }

    public WorkspaceGraphTreeNodeWrapper getChild(int index) {
        return this.children.get(index);
    }

    public String getName() {
        StringBuffer buffer = new StringBuffer();
        for (SPObject ancestor = this.wrappedObject.getParent(); ancestor != null; ancestor = ancestor.getParent()) {
            if (buffer.length() > 0) {
                buffer.insert(0, "/");
            }
            buffer.insert(0, ancestor.getName());
        }
        return this.wrappedObject.getName() + "   (" + buffer.toString() + ")";
    }
}

