/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui.query;

import ca.sqlpower.sql.CachedRowSet;
import ca.sqlpower.sql.DataSourceCollection;
import ca.sqlpower.sql.DatabaseListChangeEvent;
import ca.sqlpower.sql.DatabaseListChangeListener;
import ca.sqlpower.sql.JDBCDataSource;
import ca.sqlpower.sql.RowSetChangeEvent;
import ca.sqlpower.sql.RowSetChangeListener;
import ca.sqlpower.sql.SPDataSource;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.SQLDatabaseMapping;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.swingui.SPSUtils;
import ca.sqlpower.swingui.SPSwingWorker;
import ca.sqlpower.swingui.SwingWorkerRegistry;
import ca.sqlpower.swingui.db.DatabaseConnectionManager;
import ca.sqlpower.swingui.event.TaskTerminationEvent;
import ca.sqlpower.swingui.event.TaskTerminationListener;
import ca.sqlpower.swingui.query.AbstractSQLQueryAction;
import ca.sqlpower.swingui.query.ConnectionAndStatementBean;
import ca.sqlpower.swingui.query.Messages;
import ca.sqlpower.swingui.query.StatementExecutor;
import ca.sqlpower.swingui.query.StatementExecutorListener;
import ca.sqlpower.swingui.query.TableChangeEvent;
import ca.sqlpower.swingui.query.TableChangeListener;
import ca.sqlpower.swingui.table.FancyExportableJTable;
import ca.sqlpower.swingui.table.ResultSetTableModel;
import ca.sqlpower.validation.swingui.StatusComponent;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.undo.UndoManager;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public class SQLQueryUIComponents {
    private static final Logger logger = Logger.getLogger(SQLQueryUIComponents.class);
    private static final String EXECUTE_QUERY_ACTION = "Execute Query";
    private static final Object UNDO_SQL_EDIT = "Undo SQL Edit";
    private static final Object REDO_SQL_EDIT = "Redo SQL Edit";
    private final JTextArea errorTextArea = new JTextArea();
    private final MouseListener logPopUpMouseListener = new MouseListener(){
        private JCheckBoxMenuItem checkBoxMenuItem = new JCheckBoxMenuItem("Append", true);

        @Override
        public void mouseReleased(MouseEvent e) {
            logger.debug((Object)"Mouse released on log pop-up");
            this.showPopup(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.showPopup(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.showPopup(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.showPopup(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.showPopup(e);
        }

        private void showPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                JPopupMenu logPopupMenu = new JPopupMenu();
                logPopupMenu.add(new JMenuItem(new SaveDocumentAction(SQLQueryUIComponents.this.logTextArea.getDocument(), SQLQueryUIComponents.this.logTextArea, this.checkBoxMenuItem.isSelected())));
                logPopupMenu.add(this.checkBoxMenuItem);
                logPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                logPopupMenu.setVisible(true);
            }
        }
    };
    private JPanel firstResultPanel;
    private final JComponent dialogOwner;
    private volatile ExecuteSQLWorker sqlExecuteWorker;
    private final TaskTerminationListener sqlExecuteTerminationListener = new TaskTerminationListener(){

        @Override
        public void taskFinished(TaskTerminationEvent e) {
            SQLQueryUIComponents.this.executeQuery((StatementExecutor)null);
        }
    };
    private StatementExecutor queuedSQLStatement;
    private final AbstractAction executeAction;
    private Map<SQLDatabase, ConnectionAndStatementBean> conMap;
    private final RSyntaxTextArea queryArea;
    private final JComboBox databaseComboBox;
    private JSpinner rowLimitSpinner;
    private final JToggleButton autoCommitToggleButton;
    private final JButton commitButton;
    private final JButton rollbackButton;
    private JButton undoButton;
    private JButton redoButton;
    private JTabbedPane resultTabPane;
    private JTextArea logTextArea;
    private static final ImageIcon ICON = new ImageIcon(StatusComponent.class.getClassLoader().getResource("ca/sqlpower/swingui/query/search.png"));
    private ArrayList<JTable> resultJTables;
    private final Map<JTable, JScrollPane> resultJTableScrollPanes = new HashMap<JTable, JScrollPane>();
    private final Map<JTable, String> tableToSQLMap;
    private SwingWorkerRegistry swRegistry;
    private final DataSourceCollection dsCollection;
    private UndoManager undoManager;
    private Action undoSQLStatementAction = new AbstractAction(Messages.getString("SQLQuery.undo")){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (SQLQueryUIComponents.this.undoManager.canUndo()) {
                SQLQueryUIComponents.this.undoManager.undo();
            }
        }
    };
    private Action redoSQLStatementAction = new AbstractAction(Messages.getString("SQLQuery.redo")){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (SQLQueryUIComponents.this.undoManager.canRedo()) {
                SQLQueryUIComponents.this.undoManager.redo();
            }
        }
    };
    private DatabaseListChangeListener dbListChangeListener = new DatabaseListChangeListener(){

        @Override
        public void databaseAdded(DatabaseListChangeEvent e) {
            if (!(e.getDataSource() instanceof JDBCDataSource)) {
                return;
            }
            logger.debug((Object)"dataBase added");
            SQLQueryUIComponents.this.databaseComboBox.addItem(e.getDataSource());
            SQLQueryUIComponents.this.databaseComboBox.revalidate();
        }

        @Override
        public void databaseRemoved(DatabaseListChangeEvent e) {
            if (!(e.getDataSource() instanceof JDBCDataSource)) {
                return;
            }
            logger.debug((Object)"dataBase removed");
            if (SQLQueryUIComponents.this.databaseComboBox.getSelectedItem() != null && SQLQueryUIComponents.this.databaseComboBox.getSelectedItem().equals(e.getDataSource())) {
                SQLQueryUIComponents.this.databaseComboBox.setSelectedItem(null);
            }
            SQLQueryUIComponents.this.databaseComboBox.removeItem(e.getDataSource());
            SQLQueryUIComponents.this.databaseComboBox.revalidate();
        }
    };
    private final List<String> previousQueries;
    private final JButton prevQueryButton;
    private final JButton nextQueryButton;
    private int prevQueryPosition;
    private WindowListener windowListener = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent arg0) {
            SQLQueryUIComponents.this.closingDialogOwner();
        }
    };
    private JButton executeButton;
    private JButton stopButton;
    private JButton clearButton;
    private JButton dbcsManagerButton;
    private DatabaseConnectionManager dbConnectionManager;
    private final List<TableChangeListener> tableListeners;
    private Document searchDocument;
    private boolean showSearchOnResults = true;
    private StatementExecutor stmtExecutor = null;
    private final List<StreamingRowSetListener> rowSetListeners = new ArrayList<StreamingRowSetListener>();
    private final SQLDatabaseMapping databaseMapping;

    public void closingDialogOwner() {
        logger.debug((Object)"attempting to close");
        boolean commitedOrRollBacked = this.closeConMap();
        if (commitedOrRollBacked) {
            logger.debug((Object)"removing DatabaseListChangeListener and closing window");
            this.disconnectListeners();
            Window w = SwingUtilities.getWindowAncestor(this.dialogOwner);
            if (w != null) {
                w.setVisible(false);
            }
        }
    }

    public boolean closeConMap() {
        boolean commitedOrRollBacked = true;
        Iterator<Map.Entry<SQLDatabase, ConnectionAndStatementBean>> iterator = this.conMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<SQLDatabase, ConnectionAndStatementBean> entry = iterator.next();
            try {
                Connection con = entry.getValue().getConnection();
                if (!con.isClosed()) {
                    if (!con.getAutoCommit() && entry.getValue().isConnectionUncommitted()) {
                        commitedOrRollBacked = false;
                        int result = JOptionPane.showOptionDialog(this.dialogOwner, Messages.getString("SQLQuery.commitOrRollback", entry.getKey().getName()), Messages.getString("SQLQuery.commitOrRollbackTitle"), 1, 3, null, new Object[]{Messages.getString("SQLQuery.commit"), Messages.getString("SQLQuery.rollback"), "Cancel"}, Messages.getString("SQLQuery.commit"));
                        if (result == 0) {
                            con.commit();
                            commitedOrRollBacked = true;
                        } else if (result == 1) {
                            con.rollback();
                            commitedOrRollBacked = true;
                        } else if (result == 2) {
                            return false;
                        }
                    }
                    con.close();
                }
                iterator.remove();
            }
            catch (SQLException e) {
                logger.warn((Object)("Failed to close connection " + entry.getValue() + ". Skipping it."), (Throwable)e);
            }
        }
        return commitedOrRollBacked;
    }

    public SQLQueryUIComponents(SwingWorkerRegistry s, DataSourceCollection ds, SQLDatabaseMapping mapping, JComponent dialogOwner, StatementExecutor stmtExecutor) {
        this(s, ds, mapping, dialogOwner);
        this.stmtExecutor = stmtExecutor;
    }

    public SQLQueryUIComponents(SwingWorkerRegistry s, DataSourceCollection dsCollection, SQLDatabaseMapping mapping, JComponent dialogOwner) {
        this.databaseMapping = mapping;
        this.previousQueries = new ArrayList<String>();
        this.dialogOwner = dialogOwner;
        this.swRegistry = s;
        this.dsCollection = dsCollection;
        this.errorTextArea.setEditable(false);
        dsCollection.addDatabaseListChangeListener(this.dbListChangeListener);
        this.resultTabPane = new JTabbedPane();
        this.firstResultPanel = new JPanel(new BorderLayout());
        this.logTextArea = new JTextArea();
        this.logTextArea.setEditable(false);
        this.logTextArea.addMouseListener(this.logPopUpMouseListener);
        this.resultTabPane.add(Messages.getString("SQLQuery.log"), new JScrollPane(this.logTextArea));
        this.resultJTables = new ArrayList();
        this.tableToSQLMap = new HashMap<JTable, String>();
        this.tableListeners = new ArrayList<TableChangeListener>();
        this.dbConnectionManager = new DatabaseConnectionManager(dsCollection);
        this.executeAction = new AbstractSQLQueryAction(dialogOwner, Messages.getString("SQLQuery.execute")){

            @Override
            public void actionPerformed(ActionEvent e) {
                String sql = SQLQueryUIComponents.this.queryArea.getText();
                if (SQLQueryUIComponents.this.queryArea.getSelectedText() != null && SQLQueryUIComponents.this.queryArea.getSelectedText().trim().length() > 0) {
                    sql = SQLQueryUIComponents.this.queryArea.getSelectedText();
                }
                SQLQueryUIComponents.this.executeQuery(sql);
            }
        };
        this.autoCommitToggleButton = new JToggleButton(new AbstractSQLQueryAction(dialogOwner, Messages.getString("SQLQuery.autoCommit")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SQLQueryUIComponents.this.databaseComboBox.getSelectedItem() == null) {
                    return;
                }
                Connection con = ((ConnectionAndStatementBean)SQLQueryUIComponents.this.conMap.get(SQLQueryUIComponents.this.databaseMapping.getDatabase((JDBCDataSource)SQLQueryUIComponents.this.databaseComboBox.getSelectedItem()))).getConnection();
                if (con == null) {
                    return;
                }
                try {
                    boolean isPressed = SQLQueryUIComponents.this.autoCommitToggleButton.getModel().isSelected();
                    if (isPressed && ((ConnectionAndStatementBean)SQLQueryUIComponents.this.conMap.get(SQLQueryUIComponents.this.databaseMapping.getDatabase((JDBCDataSource)SQLQueryUIComponents.this.databaseComboBox.getSelectedItem()))).isConnectionUncommitted()) {
                        int result = JOptionPane.showOptionDialog(this.dialogOwner, Messages.getString("SQLQuery.commitOrRollbackBeforeAutoCommit"), Messages.getString("SQLQuery.commitOrRollbackTitle"), 1, 3, null, new Object[]{Messages.getString("SQLQuery.commit"), Messages.getString("SQLQuery.cancel"), Messages.getString("SQLQuery.rollback")}, Messages.getString("SQLQuery.commit"));
                        if (result == 0) {
                            SQLQueryUIComponents.this.commitCurrentDB();
                        } else if (result == 2) {
                            SQLQueryUIComponents.this.rollbackCurrentDB();
                        } else {
                            ((JToggleButton)e.getSource()).setSelected(con.getAutoCommit());
                            return;
                        }
                    }
                    con.setAutoCommit(isPressed);
                    logger.debug((Object)("The auto commit button is toggled " + isPressed));
                }
                catch (SQLException ex) {
                    SPSUtils.showExceptionDialogNoReport(this.dialogOwner, Messages.getString("SQLQuery.failedAutoCommit"), ex);
                }
            }
        });
        this.autoCommitToggleButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SQLQueryUIComponents.this.updateStatus();
            }
        });
        this.commitButton = new JButton(new AbstractSQLQueryAction(dialogOwner, Messages.getString("SQLQuery.commit")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SQLQueryUIComponents.this.databaseComboBox.getSelectedItem() == null) {
                    return;
                }
                SQLQueryUIComponents.this.commitCurrentDB();
            }
        });
        this.rollbackButton = new JButton(new AbstractSQLQueryAction(dialogOwner, Messages.getString("SQLQuery.rollback")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SQLQueryUIComponents.this.databaseComboBox.getSelectedItem() == null) {
                    return;
                }
                SQLQueryUIComponents.this.rollbackCurrentDB();
            }
        });
        this.rowLimitSpinner = new JSpinner(new SpinnerNumberModel(Integer.MAX_VALUE, 0, Integer.MAX_VALUE, 1));
        this.queryArea = new RSyntaxTextArea();
        this.queryArea.restoreDefaultSyntaxScheme();
        this.queryArea.setSyntaxEditingStyle("text/sql");
        this.undoManager = new UndoManager();
        this.queryArea.getDocument().addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent e) {
                SQLQueryUIComponents.this.undoManager.addEdit(e.getEdit());
            }
        });
        this.queryArea.getActionMap().put(UNDO_SQL_EDIT, this.undoSQLStatementAction);
        this.queryArea.getInputMap().put(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), UNDO_SQL_EDIT);
        this.queryArea.getActionMap().put(REDO_SQL_EDIT, this.redoSQLStatementAction);
        this.queryArea.getInputMap().put(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 1), REDO_SQL_EDIT);
        this.conMap = new HashMap<SQLDatabase, ConnectionAndStatementBean>();
        this.databaseComboBox = new JComboBox<Object>(dsCollection.getConnections(JDBCDataSource.class).toArray());
        this.databaseComboBox.setSelectedItem(null);
        this.databaseComboBox.addItemListener(new DatabaseItemListener());
        dialogOwner.getInputMap(1).put(KeyStroke.getKeyStroke(10, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), EXECUTE_QUERY_ACTION);
        dialogOwner.getActionMap().put(EXECUTE_QUERY_ACTION, this.executeAction);
        this.executeButton = new JButton(this.executeAction);
        this.stopButton = new JButton(new AbstractSQLQueryAction(dialogOwner, Messages.getString("SQLQuery.stop")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Statement stmt;
                ConnectionAndStatementBean conBean = (ConnectionAndStatementBean)SQLQueryUIComponents.this.conMap.get(SQLQueryUIComponents.this.databaseMapping.getDatabase((JDBCDataSource)SQLQueryUIComponents.this.databaseComboBox.getSelectedItem()));
                if (conBean != null && (stmt = conBean.getCurrentStmt()) != null) {
                    try {
                        logger.debug((Object)"stmt is being cancelled...supposely");
                        stmt.cancel();
                        if (SQLQueryUIComponents.this.sqlExecuteWorker != null) {
                            SQLQueryUIComponents.this.queuedSQLStatement = null;
                            SQLQueryUIComponents.this.sqlExecuteWorker.kill();
                            SQLQueryUIComponents.this.sqlExecuteWorker = null;
                        }
                    }
                    catch (SQLException e) {
                        SPSUtils.showExceptionDialogNoReport(this.dialogOwner, Messages.getString("SQLQuery.stopException", SQLQueryUIComponents.this.databaseMapping.getDatabase((JDBCDataSource)SQLQueryUIComponents.this.databaseComboBox.getSelectedItem()).getName()), e);
                    }
                }
                SQLQueryUIComponents.this.updateStatus();
            }
        });
        this.clearButton = new JButton(new AbstractSQLQueryAction(dialogOwner, Messages.getString("SQLQuery.clear")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SQLQueryUIComponents.this.queryArea.setText("");
            }
        });
        this.dbcsManagerButton = new JButton(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window w = SwingUtilities.getWindowAncestor(SQLQueryUIComponents.this.dbcsManagerButton);
                SQLQueryUIComponents.this.dbConnectionManager.showDialog(w);
            }
        });
        this.prevQueryButton = new JButton(new AbstractAction("Prev"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SQLQueryUIComponents.this.prevQueryPosition > 0) {
                    SQLQueryUIComponents.this.prevQueryPosition--;
                    SQLQueryUIComponents.this.queryArea.setText((String)SQLQueryUIComponents.this.previousQueries.get(SQLQueryUIComponents.this.prevQueryPosition));
                }
                SQLQueryUIComponents.this.getPrevQueryButton().setEnabled(SQLQueryUIComponents.this.prevQueryPosition > 0);
                SQLQueryUIComponents.this.getNextQueryButton().setEnabled(SQLQueryUIComponents.this.prevQueryPosition < SQLQueryUIComponents.this.previousQueries.size() - 1);
            }
        });
        this.nextQueryButton = new JButton(new AbstractAction("Next"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SQLQueryUIComponents.this.prevQueryPosition < SQLQueryUIComponents.this.previousQueries.size() - 1) {
                    SQLQueryUIComponents.this.prevQueryPosition++;
                    SQLQueryUIComponents.this.queryArea.setText((String)SQLQueryUIComponents.this.previousQueries.get(SQLQueryUIComponents.this.prevQueryPosition));
                }
                SQLQueryUIComponents.this.getPrevQueryButton().setEnabled(SQLQueryUIComponents.this.prevQueryPosition > 0);
                SQLQueryUIComponents.this.getNextQueryButton().setEnabled(SQLQueryUIComponents.this.prevQueryPosition < SQLQueryUIComponents.this.previousQueries.size() - 1);
            }
        });
        this.getPrevQueryButton().setEnabled(false);
        this.getNextQueryButton().setEnabled(false);
        this.dbcsManagerButton.setText(Messages.getString("SQLQuery.manageConnections"));
        this.undoButton = new JButton(this.undoSQLStatementAction);
        this.redoButton = new JButton(this.redoSQLStatementAction);
        new DropTarget((Component)this.queryArea, new QueryTextAreaDropListener((JTextArea)this.queryArea));
        this.updateStatus();
    }

    private void updateStatus() {
        boolean dbSelected = this.databaseComboBox.getSelectedItem() != null;
        this.executeAction.setEnabled(this.stmtExecutor != null || dbSelected);
        this.executeButton.setEnabled(this.stmtExecutor != null || dbSelected);
        boolean autoCommit = this.autoCommitToggleButton.isSelected();
        this.rollbackButton.setEnabled(!autoCommit && dbSelected);
        this.commitButton.setEnabled(!autoCommit && dbSelected);
        if (this.stmtExecutor != null) {
            this.stopButton.setEnabled(this.stmtExecutor.isRunning());
        } else {
            this.stopButton.setEnabled(false);
        }
    }

    public synchronized void executeQuery(String sql) {
        if (this.stmtExecutor == null) {
            if (this.databaseComboBox.getSelectedItem() != null) {
                this.executeQuery(new DefaultStatementExecutor(this.databaseMapping.getDatabase((JDBCDataSource)this.databaseComboBox.getSelectedItem()), sql, (Integer)this.rowLimitSpinner.getValue()));
            }
        } else {
            this.executeQuery(this.stmtExecutor);
        }
    }

    public synchronized void executeQuery(StatementExecutor stmtExecutor) {
        if (this.sqlExecuteWorker != null && !this.sqlExecuteWorker.isFinished()) {
            if (stmtExecutor != null) {
                this.queuedSQLStatement = stmtExecutor;
            }
            return;
        }
        if (this.sqlExecuteWorker != null && this.sqlExecuteWorker.isFinished()) {
            if (stmtExecutor != null) {
                this.queuedSQLStatement = null;
            } else if (stmtExecutor == null && this.queuedSQLStatement != null) {
                StatementExecutor tempSQL = stmtExecutor;
                stmtExecutor = this.queuedSQLStatement;
                this.queuedSQLStatement = tempSQL;
            }
            this.sqlExecuteWorker.removeTaskTerminationListener(this.sqlExecuteTerminationListener);
            this.sqlExecuteWorker = null;
        }
        if (stmtExecutor == null) {
            return;
        }
        if (this.databaseComboBox.getSelectedIndex() == -1) {
            return;
        }
        ConnectionAndStatementBean conBean = this.conMap.get(this.databaseMapping.getDatabase((JDBCDataSource)this.databaseComboBox.getSelectedItem()));
        try {
            if (conBean != null && !conBean.getConnection().getAutoCommit()) {
                conBean.setConnectionUncommitted(true);
            }
        }
        catch (SQLException e1) {
            SPSUtils.showExceptionDialogNoReport(this.dialogOwner, Messages.getString("SQLQuery.failedRetrievingConnection", this.databaseMapping.getDatabase((JDBCDataSource)this.databaseComboBox.getSelectedItem()).getName()), e1);
        }
        this.prevQueryPosition = this.previousQueries.size();
        this.previousQueries.add(stmtExecutor.getStatement());
        this.getPrevQueryButton().setEnabled(this.prevQueryPosition > 0);
        this.getNextQueryButton().setEnabled(this.prevQueryPosition < this.previousQueries.size() - 1);
        logger.debug((Object)("Executing SQL using executor type " + stmtExecutor.getClass()));
        this.sqlExecuteWorker = new ExecuteSQLWorker(this.swRegistry, stmtExecutor);
        this.sqlExecuteWorker.addTaskTerminationListener(this.sqlExecuteTerminationListener);
        new Thread(this.sqlExecuteWorker).start();
    }

    public static JComponent createQueryPanel(SwingWorkerRegistry swRegistry, DataSourceCollection ds, SQLDatabaseMapping mapping, Window owner) {
        return SQLQueryUIComponents.createQueryPanel(swRegistry, ds, mapping, owner, null, null);
    }

    public static JComponent createQueryPanel(SwingWorkerRegistry swRegistry, DataSourceCollection dsCollection, SQLDatabaseMapping mapping, Window owner, SQLDatabase db, String initialSQL) {
        JPanel defaultQueryPanel = new JPanel();
        SQLQueryUIComponents queryParts = new SQLQueryUIComponents(swRegistry, dsCollection, mapping, defaultQueryPanel);
        queryParts.addWindowListener(owner);
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.add(queryParts.getPrevQueryButton());
        toolbar.add(queryParts.getNextQueryButton());
        toolbar.addSeparator();
        toolbar.add(queryParts.getExecuteButton());
        toolbar.add(queryParts.getStopButton());
        toolbar.add(queryParts.getClearButton());
        toolbar.addSeparator();
        toolbar.add(queryParts.getAutoCommitToggleButton());
        toolbar.add(queryParts.getCommitButton());
        toolbar.add(queryParts.getRollbackButton());
        toolbar.addSeparator();
        toolbar.add(queryParts.getUndoButton());
        toolbar.add(queryParts.getRedoButton());
        FormLayout textAreaLayout = new FormLayout("pref:grow, 10dlu, pref, 10dlu, pref, 10dlu, pref", "pref, pref, fill:max(100dlu;pref):grow");
        DefaultFormBuilder textAreaBuilder = new DefaultFormBuilder(textAreaLayout, defaultQueryPanel);
        textAreaBuilder.setDefaultDialogBorder();
        textAreaBuilder.append((Component)toolbar, 7);
        textAreaBuilder.nextLine();
        textAreaBuilder.append((Component)queryParts.getDatabaseComboBox());
        textAreaBuilder.append((Component)queryParts.getDbcsManagerButton());
        textAreaBuilder.append(Messages.getString("SQLQuery.rowLimit"));
        JSpinner rowlimitSpinner = queryParts.getRowLimitSpinner();
        rowlimitSpinner.setValue(new Integer(1000));
        textAreaBuilder.append((Component)rowlimitSpinner);
        textAreaBuilder.nextLine();
        textAreaBuilder.append((Component)new RTextScrollPane((RTextArea)queryParts.getQueryArea(), true), 7);
        JSplitPane queryPane = new JSplitPane(0);
        queryPane.add((Component)defaultQueryPanel, "top");
        queryPane.add((Component)queryParts.getResultTabPane(), "bottom");
        if (db != null && initialSQL != null && dsCollection.getConnections().contains(db.getDataSource())) {
            queryParts.getDatabaseComboBox().setSelectedItem(db.getDataSource());
            queryParts.getQueryArea().setText(initialSQL);
            queryParts.executeQuery(initialSQL);
        }
        return queryPane;
    }

    private void commitCurrentDB() {
        ConnectionAndStatementBean conBean = this.conMap.get(this.databaseMapping.getDatabase((JDBCDataSource)this.databaseComboBox.getSelectedItem()));
        Connection con = conBean.getConnection();
        if (con == null) {
            return;
        }
        try {
            if (!con.getAutoCommit()) {
                con.commit();
                conBean.setConnectionUncommitted(false);
            }
        }
        catch (SQLException ex) {
            SPSUtils.showExceptionDialogNoReport(this.dialogOwner, Messages.getString("SQlQuery.failedCommit"), ex);
        }
    }

    private void rollbackCurrentDB() {
        ConnectionAndStatementBean conBean = this.conMap.get(this.databaseMapping.getDatabase((JDBCDataSource)this.databaseComboBox.getSelectedItem()));
        Connection con = conBean.getConnection();
        if (con == null) {
            return;
        }
        try {
            if (!con.getAutoCommit()) {
                con.rollback();
                conBean.setConnectionUncommitted(false);
            }
        }
        catch (SQLException ex) {
            SPSUtils.showExceptionDialogNoReport(this.dialogOwner, Messages.getString("SQLQuery.failedRollback"), ex);
        }
    }

    private synchronized void createResultSetTables(List<CachedRowSet> resultSets, StatementExecutor executor) throws SQLException {
        this.clearResultTables(true);
        for (StreamingRowSetListener rowSetListener : this.rowSetListeners) {
            rowSetListener.disconnect();
        }
        this.rowSetListeners.clear();
        this.searchDocument = new DefaultStyledDocument();
        for (CachedRowSet rs : resultSets) {
            FormLayout tableAreaLayout = new FormLayout("pref, 3dlu, pref:grow", "pref, fill:min(pref;50dlu):grow");
            DefaultFormBuilder tableAreaBuilder = new DefaultFormBuilder(tableAreaLayout);
            if (this.showSearchOnResults) {
                JLabel searchLabel = new JLabel(ICON);
                searchLabel.setToolTipText("Search");
                JTextField tableFilterTextField = new JTextField(this.searchDocument, null, 0);
                tableAreaBuilder.append((Component)searchLabel, (Component)tableFilterTextField);
            }
            ResultSetTableModel model = new ResultSetTableModel(rs);
            StreamingRowSetListener rowSetListener = new StreamingRowSetListener(rs, model);
            rs.addRowSetListener(rowSetListener);
            this.rowSetListeners.add(rowSetListener);
            final FancyExportableJTable tempTable = new FancyExportableJTable((TableModel)model, this.searchDocument);
            TableModelListener tableListener = new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    tempTable.createDefaultColumnsFromModel();
                }
            };
            model.addTableModelListener(tableListener);
            tempTable.setCellSelectionEnabled(true);
            tableAreaBuilder.nextLine();
            JScrollPane tableScrollPane = new JScrollPane(tempTable);
            tableScrollPane.setPreferredSize(new Dimension((int)tableScrollPane.getPreferredSize().getWidth(), 0));
            this.resultJTableScrollPanes.put(tempTable, tableScrollPane);
            tableAreaBuilder.append((Component)tableScrollPane, 3);
            this.resultJTables.add(tempTable);
            this.tableToSQLMap.put(tempTable, executor.getStatement());
            JPanel tempResultPanel = tableAreaBuilder.getPanel();
            this.resultTabPane.add(Messages.getString("SQLQuery.result"), tempResultPanel);
            this.resultTabPane.setSelectedIndex(1);
        }
        for (JTable table : this.resultJTables) {
            for (TableChangeListener l : this.tableListeners) {
                l.tableAdded(new TableChangeEvent(this, table));
            }
        }
    }

    private void clearResultTables(boolean removeTabs) {
        this.tableToSQLMap.clear();
        for (JTable table : this.resultJTables) {
            for (int i = this.tableListeners.size() - 1; i >= 0; --i) {
                this.tableListeners.get(i).tableRemoved(new TableChangeEvent(this, table));
            }
        }
        if (removeTabs) {
            this.resultJTables.clear();
            this.resultJTableScrollPanes.clear();
            if (this.resultTabPane.getComponentCount() > 1) {
                for (int i = this.resultTabPane.getComponentCount() - 1; i >= 1; --i) {
                    this.resultTabPane.remove(i);
                }
            }
        }
    }

    void addConnection(SQLDatabase db) throws SQLObjectException {
        if (!this.conMap.containsKey(db)) {
            Connection con = db.getConnection();
            this.conMap.put(db, new ConnectionAndStatementBean(con));
        }
        try {
            this.autoCommitToggleButton.setSelected(this.conMap.get(db).getConnection().getAutoCommit());
        }
        catch (SQLException ex) {
            SPSUtils.showExceptionDialogNoReport(this.dialogOwner, Messages.getString("SQLQuery.failedConnectingToDB"), ex);
        }
        this.updateStatus();
        this.logTextArea.append("\n" + JDBCDataSource.getConnectionInfoString(db.getDataSource(), false) + "\n\n");
        this.logTextArea.setCaretPosition(this.logTextArea.getDocument().getLength());
    }

    public void addWindowListener(Window container) {
        container.addWindowListener(this.windowListener);
    }

    public JButton getExecuteButton() {
        return this.executeButton;
    }

    public JButton getStopButton() {
        return this.stopButton;
    }

    public JButton getClearButton() {
        return this.clearButton;
    }

    public JToggleButton getAutoCommitToggleButton() {
        return this.autoCommitToggleButton;
    }

    public JButton getCommitButton() {
        return this.commitButton;
    }

    public JButton getRollbackButton() {
        return this.rollbackButton;
    }

    public JButton getUndoButton() {
        return this.undoButton;
    }

    public JButton getRedoButton() {
        return this.redoButton;
    }

    public JComboBox getDatabaseComboBox() {
        return this.databaseComboBox;
    }

    public JButton getDbcsManagerButton() {
        return this.dbcsManagerButton;
    }

    public JSpinner getRowLimitSpinner() {
        return this.rowLimitSpinner;
    }

    public void setRowLimitSpinner(JSpinner newRowLimitSpinner) {
        this.rowLimitSpinner = newRowLimitSpinner;
    }

    public RSyntaxTextArea getQueryArea() {
        return this.queryArea;
    }

    public JTabbedPane getResultTabPane() {
        return this.resultTabPane;
    }

    public ArrayList<JTable> getResultTables() {
        return this.resultJTables;
    }

    public void addTableChangeListener(TableChangeListener l) {
        this.tableListeners.add(l);
    }

    public void removeTableChangeListener(TableChangeListener l) {
        this.tableListeners.remove(l);
    }

    public JTextArea getLogTextArea() {
        return this.logTextArea;
    }

    public JPanel getFirstResultPanel() {
        return this.firstResultPanel;
    }

    public String getQueryForJTable(JTable table) {
        return this.tableToSQLMap.get(table);
    }

    public void disconnectListeners() {
        this.dsCollection.removeDatabaseListChangeListener(this.dbListChangeListener);
        for (StreamingRowSetListener rowSetListener : this.rowSetListeners) {
            rowSetListener.disconnect();
        }
    }

    public Document getSearchDocument() {
        return this.searchDocument;
    }

    public void setShowSearchOnResults(boolean showSearchOnResults) {
        this.showSearchOnResults = showSearchOnResults;
    }

    void setCurrentDataSource(SPDataSource ds) {
        this.databaseComboBox.getModel().setSelectedItem(ds);
    }

    ExecuteSQLWorker getSqlExecuteWorker() {
        return this.sqlExecuteWorker;
    }

    public JButton getNextQueryButton() {
        return this.nextQueryButton;
    }

    public JButton getPrevQueryButton() {
        return this.prevQueryButton;
    }

    public static String createErrorStringMessage(Throwable e) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter traceWriter = new PrintWriter(stringWriter);
        stringWriter.write(Messages.getString("SQLQuery.queryFailed"));
        e.printStackTrace(traceWriter);
        stringWriter.write("\n\n");
        stringWriter.write(Messages.getString("SQLQuery.queryFailedSeeAbove", SPSUtils.getRootCause(e).getMessage()));
        return stringWriter.toString();
    }

    private class StreamingRowSetListener
    implements RowSetChangeListener {
        private AtomicBoolean hasUpdates = new AtomicBoolean(false);
        private final Timer timer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StreamingRowSetListener.this.hasUpdates.get()) {
                    StreamingRowSetListener.this.listeningTableModel.dataChanged();
                    StreamingRowSetListener.this.hasUpdates.set(false);
                }
            }
        });
        private final CachedRowSet rowSet;
        private final ResultSetTableModel listeningTableModel;

        public StreamingRowSetListener(CachedRowSet rowSet, ResultSetTableModel tableModel) {
            this.rowSet = rowSet;
            this.listeningTableModel = tableModel;
            this.timer.setInitialDelay(0);
            this.timer.setCoalesce(true);
            this.timer.setRepeats(true);
            this.timer.start();
        }

        public void disconnect() {
            this.timer.stop();
            this.rowSet.removeRowSetListener(this);
        }

        @Override
        public void rowAdded(RowSetChangeEvent e) {
            this.hasUpdates.set(true);
        }
    }

    private class QueryTextAreaDropListener
    implements DropTargetListener {
        private final JTextArea queryArea;

        public QueryTextAreaDropListener(JTextArea textArea) {
            this.queryArea = textArea;
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            logger.debug((Object)"We are in drag enter");
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
            logger.debug((Object)"We are in drag Exit");
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            this.queryArea.setCaretPosition(this.queryArea.viewToModel(dtde.getLocation()));
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            DataFlavor[] flavours = dtde.getTransferable().getTransferDataFlavors();
            String[] droppedStrings = null;
            boolean isCommaSeperated = false;
            try {
                for (int i = 0; i < flavours.length; ++i) {
                    String mimeType = flavours[i].getMimeType();
                    if (mimeType.equals("application/x-java-serialized-object; class=\"[Ljava.lang.String;\"")) {
                        dtde.acceptDrop(1);
                        logger.debug((Object)("Accepting drop of type: " + mimeType));
                        droppedStrings = (String[])dtde.getTransferable().getTransferData(flavours[i]);
                        isCommaSeperated = true;
                        break;
                    }
                    if (mimeType.equals("application/x-java-serialized-object; class=java.lang.String")) {
                        dtde.acceptDrop(1);
                        logger.debug((Object)("Accepting drop of type: " + mimeType));
                        String text = (String)dtde.getTransferable().getTransferData(flavours[i]);
                        droppedStrings = new String[]{text};
                        break;
                    }
                    if (mimeType.equals("application/x-java-file-list; class=java.util.List")) {
                        dtde.acceptDrop(1);
                        List fileList = (List)dtde.getTransferable().getTransferData(flavours[i]);
                        droppedStrings = new String[fileList.size()];
                        for (int j = 0; j < droppedStrings.length; ++j) {
                            StringBuffer fileContent = new StringBuffer();
                            try {
                                String str;
                                BufferedReader bufferedReader = new BufferedReader(new FileReader((File)fileList.get(j)));
                                while ((str = bufferedReader.readLine()) != null) {
                                    fileContent.append(str);
                                    fileContent.append("\n");
                                }
                                droppedStrings[j] = fileContent.toString();
                                bufferedReader.close();
                                continue;
                            }
                            catch (IOException iOException) {
                                logger.debug((Object)(" Can't open file " + ((File)fileList.get(j)).getName()));
                            }
                        }
                        break;
                    }
                    logger.debug((Object)("Unsupported flavour: " + mimeType + ". continuing..."));
                }
            }
            catch (UnsupportedFlavorException e) {
                dtde.dropComplete(false);
                throw new IllegalStateException("DnD system says it doesn't support a data flavour it already offered to us!", e);
            }
            catch (IOException e) {
                dtde.dropComplete(false);
                throw new RuntimeException("Drop failed due to an I/O error", e);
            }
            if (droppedStrings == null) {
                logger.debug((Object)"No supported data flavours found. Rejecting drop.");
                dtde.rejectDrop();
                return;
            }
            StringBuilder buf = new StringBuilder();
            boolean first = true;
            for (void var10_19 : droppedStrings) {
                if (!first && isCommaSeperated) {
                    buf.append(", ");
                }
                buf.append((String)var10_19);
                first = false;
            }
            this.queryArea.insert(buf.toString(), this.queryArea.getCaretPosition());
            dtde.dropComplete(true);
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
            logger.debug((Object)"We are in dropActionChanged");
        }
    }

    private class DefaultStatementExecutor
    implements StatementExecutor {
        private final SQLDatabase db;
        private final String sqlString;
        private final int rowLimit;
        private final List<ResultSet> resultSets = new ArrayList<ResultSet>();
        private final List<Integer> updateCounts = new ArrayList<Integer>();
        private final List<StatementExecutorListener> executorListeners = new ArrayList<StatementExecutorListener>();
        private int resultPosition;
        private final List<RowSetChangeListener> rowSetChangeListeners = new ArrayList<RowSetChangeListener>();
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

        public DefaultStatementExecutor(SQLDatabase db, String sqlString, int rowLimit) {
            this.rowLimit = rowLimit;
            this.sqlString = sqlString;
            this.db = db;
            this.resultPosition = 0;
        }

        @Override
        public boolean isRunning() {
            ConnectionAndStatementBean selectedConnection;
            boolean dbSelected;
            boolean bl = dbSelected = SQLQueryUIComponents.this.databaseComboBox.getSelectedItem() != null;
            if (dbSelected) {
                JDBCDataSource selectedDS = (JDBCDataSource)SQLQueryUIComponents.this.databaseComboBox.getSelectedItem();
                selectedConnection = (ConnectionAndStatementBean)SQLQueryUIComponents.this.conMap.get(SQLQueryUIComponents.this.databaseMapping.getDatabase(selectedDS));
            } else {
                selectedConnection = null;
            }
            return dbSelected && selectedConnection != null && selectedConnection.getCurrentStmt() != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean executeStatement() throws SQLException {
            this.resultPosition = 0;
            Connection con = null;
            Statement stmt = null;
            try {
                boolean initialResult;
                this.fireQueryExecutionStart();
                con = ((ConnectionAndStatementBean)SQLQueryUIComponents.this.conMap.get(this.db)).getConnection();
                stmt = con.createStatement();
                ((ConnectionAndStatementBean)SQLQueryUIComponents.this.conMap.get(this.db)).setCurrentStmt(stmt);
                stmt.setMaxRows(this.rowLimit);
                boolean sqlResult = initialResult = stmt.execute(this.sqlString);
                boolean hasNext = true;
                while (hasNext) {
                    if (sqlResult) {
                        CachedRowSet crs = new CachedRowSet();
                        crs.setMakeUppercase(false);
                        crs.populate(stmt.getResultSet());
                        this.resultSets.add(crs);
                    } else {
                        this.resultSets.add(null);
                    }
                    this.updateCounts.add(stmt.getUpdateCount());
                    sqlResult = stmt.getMoreResults();
                    hasNext = sqlResult || stmt.getUpdateCount() != -1;
                }
                boolean bl = initialResult;
                return bl;
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException ex) {
                        ex.printStackTrace();
                    }
                    ((ConnectionAndStatementBean)SQLQueryUIComponents.this.conMap.get(this.db)).setCurrentStmt(null);
                }
                this.fireQueryExecutionStop();
            }
        }

        @Override
        public ResultSet getResultSet() {
            if (this.resultPosition >= this.resultSets.size()) {
                return null;
            }
            return this.resultSets.get(this.resultPosition);
        }

        @Override
        public String getStatement() {
            return this.sqlString;
        }

        @Override
        public int getUpdateCount() {
            if (this.resultPosition >= this.updateCounts.size()) {
                return -1;
            }
            return this.updateCounts.get(this.resultPosition);
        }

        @Override
        public boolean getMoreResults() {
            ++this.resultPosition;
            return this.resultPosition < this.resultSets.size() && this.resultSets.get(this.resultPosition) != null;
        }

        public void addRowSetChangeListener(RowSetChangeListener l) {
            this.rowSetChangeListeners.add(l);
        }

        public void removeRowSetChangeListener(RowSetChangeListener l) {
            this.rowSetChangeListeners.remove(l);
        }

        private void fireQueryExecutionStart() {
            for (StatementExecutorListener listener : this.executorListeners) {
                listener.queryStarted();
            }
        }

        private void fireQueryExecutionStop() {
            for (StatementExecutorListener listener : this.executorListeners) {
                listener.queryStopped();
            }
        }

        @Override
        public void addStatementExecutorListener(StatementExecutorListener qcl) {
            this.executorListeners.add(qcl);
        }

        @Override
        public void removeStatementExecutorListener(StatementExecutorListener qcl) {
            this.executorListeners.remove(qcl);
        }
    }

    private class ExecuteSQLWorker
    extends SPSwingWorker {
        private List<CachedRowSet> resultSets;
        private List<Integer> rowsAffected;
        private final SQLDatabase db;
        private long startExecutionTime;
        private final StatementExecutor stmtExecutor;
        private final StatementExecutorListener executorListener;

        public ExecuteSQLWorker(SwingWorkerRegistry registry, StatementExecutor stmtExecutor) {
            super(registry, stmtExecutor);
            this.resultSets = new ArrayList<CachedRowSet>();
            this.rowsAffected = new ArrayList<Integer>();
            this.executorListener = new StatementExecutorListener(){

                @Override
                public void queryStopped() {
                    SQLQueryUIComponents.this.stopButton.setEnabled(false);
                }

                @Override
                public void queryStarted() {
                    SQLQueryUIComponents.this.stopButton.setEnabled(true);
                }
            };
            this.stmtExecutor = stmtExecutor;
            if (stmtExecutor.getStatement().equals("")) {
                logger.debug((Object)"Empty String");
                SQLQueryUIComponents.this.firstResultPanel.removeAll();
                SQLQueryUIComponents.this.firstResultPanel.revalidate();
            }
            this.stmtExecutor.addStatementExecutorListener(this.executorListener);
            this.db = SQLQueryUIComponents.this.databaseMapping.getDatabase((JDBCDataSource)SQLQueryUIComponents.this.databaseComboBox.getSelectedItem());
            try {
                SQLQueryUIComponents.this.rowLimitSpinner.commitEdit();
            }
            catch (ParseException e1) {
                SQLQueryUIComponents.this.rowLimitSpinner.setValue(SQLQueryUIComponents.this.rowLimitSpinner.getValue());
            }
            SQLQueryUIComponents.this.updateStatus();
            this.setJobSize(null);
            this.setProgress(0);
            if (this.db != null) {
                this.setMessage(Messages.getString("SQLQuery.workerMessage", this.db.getName()));
            } else {
                this.setMessage(Messages.getString("SQLQuery.queryingNullDB"));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cleanup() throws Exception {
            try {
                long finishExecutionTime = System.currentTimeMillis();
                DateFormat formatter = DateFormat.getDateTimeInstance(2, 1);
                SQLQueryUIComponents.this.logTextArea.append("Executed at " + formatter.format(new Date(this.startExecutionTime)) + ", took " + (finishExecutionTime - this.startExecutionTime) + " milliseconds\n");
                Throwable e = this.getDoStuffException();
                if (e != null) {
                    String errorMessage = SQLQueryUIComponents.createErrorStringMessage(e);
                    SQLQueryUIComponents.this.logTextArea.append(errorMessage + "\n");
                    logger.error((Object)e.getStackTrace());
                    SQLQueryUIComponents.this.clearResultTables(false);
                    for (Map.Entry entry : SQLQueryUIComponents.this.resultJTableScrollPanes.entrySet()) {
                        JPanel panel = new JPanel(new BorderLayout());
                        panel.add((Component)((JTable)entry.getKey()).getTableHeader(), "North");
                        panel.add(new JTextArea(Messages.getString("SQLQuery.queryFailedSeeLog", e.getMessage())));
                        ((JScrollPane)entry.getValue()).getViewport().setView(panel);
                    }
                    return;
                }
                if (SQLQueryUIComponents.this.queuedSQLStatement == null) {
                    SQLQueryUIComponents.this.createResultSetTables(this.resultSets, this.stmtExecutor);
                }
                this.resultSets.clear();
                for (Integer i : this.rowsAffected) {
                    SQLQueryUIComponents.this.logTextArea.append(Messages.getString("SQLQuery.rowsAffected", i.toString()));
                    SQLQueryUIComponents.this.logTextArea.append("\n");
                }
            }
            finally {
                SQLQueryUIComponents.this.logTextArea.append("\n");
                SQLQueryUIComponents.this.updateStatus();
                SQLQueryUIComponents.this.logTextArea.setCaretPosition(SQLQueryUIComponents.this.logTextArea.getDocument().getLength());
                this.stmtExecutor.removeStatementExecutorListener(this.executorListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doStuff() throws Exception {
            try {
                this.startExecutionTime = System.currentTimeMillis();
                logger.debug((Object)("Starting execute action of \"" + this.stmtExecutor.getStatement() + "\"."));
                if (this.db == null) {
                    return;
                }
                if (this.stmtExecutor.getStatement().trim().length() == 0) {
                    return;
                }
                if (SQLQueryUIComponents.this.conMap.get(this.db) == null || ((ConnectionAndStatementBean)SQLQueryUIComponents.this.conMap.get(this.db)).getConnection() == null || ((ConnectionAndStatementBean)SQLQueryUIComponents.this.conMap.get(this.db)).getConnection().isClosed()) {
                    SQLQueryUIComponents.this.addConnection(this.db);
                }
                SQLQueryUIComponents.this.updateStatus();
                logger.debug((Object)("Executing statement " + this.stmtExecutor.getStatement()));
                boolean sqlResult = this.stmtExecutor.executeStatement();
                logger.debug((Object)"Finished execution");
                boolean hasNext = true;
                while (hasNext) {
                    if (sqlResult) {
                        CachedRowSet rowSet;
                        ResultSet rs = this.stmtExecutor.getResultSet();
                        logger.debug((Object)"Populating cached row set");
                        if (rs instanceof CachedRowSet) {
                            rowSet = (CachedRowSet)rs;
                        } else {
                            rowSet = new CachedRowSet();
                            rowSet.populate(rs);
                        }
                        logger.debug((Object)("Result set row count is " + rowSet.size()));
                        this.resultSets.add(rowSet);
                        this.rowsAffected.add(new Integer(rowSet.size()));
                        rs.close();
                    } else {
                        this.rowsAffected.add(new Integer(this.stmtExecutor.getUpdateCount()));
                        logger.debug((Object)("Update count is : " + this.stmtExecutor.getUpdateCount()));
                    }
                    sqlResult = this.stmtExecutor.getMoreResults();
                    hasNext = sqlResult || this.stmtExecutor.getUpdateCount() != -1;
                }
                logger.debug((Object)"Finished Execute method");
            }
            finally {
                SQLQueryUIComponents.this.updateStatus();
            }
        }
    }

    private class SaveDocumentAction
    extends AbstractAction {
        private final Document doc;
        private final Component parent;
        private final boolean append;

        public SaveDocumentAction(Document doc, Component parent, boolean append) {
            super("Save As...");
            this.doc = doc;
            this.parent = parent;
            this.append = append;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            chooser.addChoosableFileFilter(SPSUtils.LOG_FILE_FILTER);
            chooser.addChoosableFileFilter(SPSUtils.TEXT_FILE_FILTER);
            chooser.setFileFilter(SPSUtils.LOG_FILE_FILTER);
            int retval = chooser.showSaveDialog(this.parent);
            if (retval == 0) {
                if (logger.isDebugEnabled()) {
                    try {
                        logger.debug((Object)("Log has length " + this.doc.getLength() + " and text " + this.doc.getText(0, this.doc.getLength()) + " when writing to file."));
                    }
                    catch (BadLocationException e1) {
                        throw new RuntimeException(e1);
                    }
                }
                logger.debug((Object)("Are we appending? " + this.append));
                String filePath = chooser.getSelectedFile().getAbsolutePath();
                if (!chooser.getSelectedFile().getName().contains(".")) {
                    filePath = chooser.getFileFilter() == SPSUtils.TEXT_FILE_FILTER ? filePath + ".txt" : filePath + ".log";
                }
                if (this.append) {
                    FileAppender appender = null;
                    Logger logAppender = null;
                    try {
                        appender = new FileAppender((Layout)new PatternLayout("%m\n"), filePath);
                        logAppender = Logger.getLogger((String)"SQLQueryUIComponents Log Appender");
                        logAppender.addAppender((Appender)appender);
                        logAppender.info((Object)this.doc.getText(0, this.doc.getLength()));
                    }
                    catch (Exception e1) {
                        throw new RuntimeException(e1);
                    }
                    finally {
                        if (logAppender != null && appender != null) {
                            logAppender.removeAppender((Appender)appender);
                        }
                    }
                }
                try {
                    FileWriter writer = new FileWriter(filePath);
                    writer.write(this.doc.getText(0, this.doc.getLength()));
                    writer.flush();
                    writer.close();
                }
                catch (Exception e1) {
                    throw new RuntimeException(e1);
                }
            }
        }
    }

    private class DatabaseItemListener
    implements ItemListener {
        private DatabaseItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() != 1) {
                SQLQueryUIComponents.this.updateStatus();
                return;
            }
            JDBCDataSource ds = (JDBCDataSource)e.getItem();
            SQLDatabase db = SQLQueryUIComponents.this.databaseMapping.getDatabase(ds);
            try {
                SQLQueryUIComponents.this.addConnection(db);
            }
            catch (SQLObjectException e1) {
                SQLQueryUIComponents.this.logTextArea.append(SQLQueryUIComponents.createErrorStringMessage(e1));
                SQLQueryUIComponents.this.logTextArea.setCaretPosition(SQLQueryUIComponents.this.logTextArea.getDocument().getLength());
            }
        }
    }
}

