/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui.table;

import ca.sqlpower.swingui.table.Arrow;
import ca.sqlpower.swingui.table.CleanupTableModel;
import ca.sqlpower.swingui.table.TableModelWrapper;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class TableModelSortDecorator
extends AbstractTableModel
implements CleanupTableModel,
TableModelWrapper {
    private final AtomicBoolean arraysUpToDate = new AtomicBoolean(false);
    private static final Logger logger = Logger.getLogger(TableModelSortDecorator.class);
    protected TableModel tableModel;
    public static final int DESCENDING = -1;
    public static final int NOT_SORTED = 0;
    public static final int ASCENDING = 1;
    private static Directive EMPTY_DIRECTIVE = new Directive(-1, 0);
    public static final Comparator COMPARABLE_COMAPRATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((Comparable)o1).compareTo(o2);
        }
    };
    public static final Comparator LEXICAL_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            return o1.toString().compareTo(o2.toString());
        }
    };
    private Row[] viewToModel;
    private int[] modelToView;
    private JTableHeader tableHeader;
    private MouseListener mouseListener;
    private TableModelListener tableModelListener;
    private Map<Class, Comparator> columnComparators = new HashMap<Class, Comparator>();
    private List<Directive> sortingColumns = new ArrayList<Directive>();
    private Integer headerLabelYLoc = null;
    private Integer headerLabelHeight = null;

    public TableModelSortDecorator() {
        logger.debug((Object)"Constructing table model sort decorator");
        this.mouseListener = new MouseHandler();
        this.tableModelListener = new TableModelHandler();
    }

    public TableModelSortDecorator(TableModel tableModel) {
        this();
        this.setWrappedModel(tableModel);
    }

    public TableModelSortDecorator(TableModel tableModel, JTableHeader tableHeader) {
        this();
        this.setTableHeader(tableHeader);
        this.setWrappedModel(tableModel);
    }

    private void clearSortingState() {
        this.viewToModel = null;
        this.modelToView = null;
    }

    @Override
    public TableModel getWrappedModel() {
        return this.tableModel;
    }

    @Override
    public void setWrappedModel(TableModel tableModel) {
        if (this.tableModel != null) {
            this.tableModel.removeTableModelListener(this.tableModelListener);
        }
        this.arraysUpToDate.set(false);
        this.tableModel = tableModel;
        if (this.tableModel != null) {
            this.tableModel.addTableModelListener(this.tableModelListener);
        }
        this.clearSortingState();
        this.fireTableStructureChanged();
    }

    public JTableHeader getTableHeader() {
        return this.tableHeader;
    }

    public void setTableHeader(JTableHeader tableHeader) {
        if (this.tableHeader != null) {
            this.tableHeader.removeMouseListener(this.mouseListener);
            TableCellRenderer defaultRenderer = this.tableHeader.getDefaultRenderer();
            if (defaultRenderer instanceof SortableHeaderRenderer) {
                this.tableHeader.setDefaultRenderer(((SortableHeaderRenderer)defaultRenderer).tableCellRenderer);
            }
        }
        this.tableHeader = tableHeader;
        if (this.tableHeader != null) {
            this.tableHeader.addMouseListener(this.mouseListener);
            this.tableHeader.setDefaultRenderer(new SortableHeaderRenderer(this.tableHeader.getDefaultRenderer()));
        }
    }

    public boolean isSorting() {
        return this.sortingColumns.size() != 0;
    }

    private Directive getDirective(int column) {
        for (int i = 0; i < this.sortingColumns.size(); ++i) {
            Directive directive = this.sortingColumns.get(i);
            if (directive.column != column) continue;
            return directive;
        }
        return EMPTY_DIRECTIVE;
    }

    public int getSortingStatus(int column) {
        return this.getDirective(column).direction;
    }

    private void sortingStatusChanged() {
        this.clearSortingState();
        this.fireTableDataChanged();
        if (this.tableHeader != null) {
            this.tableHeader.repaint();
        }
    }

    public void setSortingStatus(int column, int status) {
        LinkedHashMap<Integer, Integer> columnMap = new LinkedHashMap<Integer, Integer>();
        columnMap.put(column, status);
        this.setSortingStatus(columnMap);
    }

    public void setSortingStatus(LinkedHashMap<Integer, Integer> columnToStatusMap) {
        for (Map.Entry<Integer, Integer> entry : columnToStatusMap.entrySet()) {
            logger.debug((Object)("Sorting status changed. Setting column number " + entry.getKey() + " to status " + entry.getValue()), (Throwable)new Exception());
            Directive directive = this.getDirective(entry.getKey());
            if (directive != EMPTY_DIRECTIVE) {
                this.sortingColumns.remove(directive);
            }
            if (entry.getValue() == 0) continue;
            this.sortingColumns.add(new Directive(entry.getKey(), entry.getValue()));
        }
        this.sortingStatusChanged();
    }

    protected Icon getHeaderRendererIcon(int column, int size) {
        Directive directive = this.getDirective(column);
        if (directive == EMPTY_DIRECTIVE) {
            return null;
        }
        return new Arrow(directive.direction == -1, size, this.sortingColumns.indexOf(directive));
    }

    private void cancelSorting() {
        this.sortingColumns.clear();
        this.sortingStatusChanged();
    }

    public void setColumnComparator(Class type, Comparator comparator) {
        if (comparator == null) {
            this.columnComparators.remove(type);
        } else {
            this.columnComparators.put(type, comparator);
        }
    }

    protected Comparator getComparator(int column) {
        Class<?> columnType = this.tableModel.getColumnClass(column);
        Comparator comparator = this.columnComparators.get(columnType);
        if (comparator != null) {
            return comparator;
        }
        if (Comparable.class.isAssignableFrom(columnType)) {
            return COMPARABLE_COMAPRATOR;
        }
        return LEXICAL_COMPARATOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateArrays() {
        this.viewToModel = null;
        this.modelToView = null;
        TableModel tableModel = this.tableModel;
        synchronized (tableModel) {
            int tableModelRowCount = this.tableModel.getRowCount();
            this.viewToModel = new Row[tableModelRowCount];
            if (this.viewToModel != null) {
                for (int row = 0; row < tableModelRowCount; ++row) {
                    this.viewToModel[row] = new Row(row);
                }
                if (this.isSorting()) {
                    Arrays.sort(this.viewToModel);
                }
                int n = this.viewToModel.length;
                this.modelToView = new int[n];
                for (int i = 0; i < n; ++i) {
                    this.modelToView[((Row)this.viewToModel[i]).modelIndex] = i;
                }
                this.arraysUpToDate.set(true);
            }
        }
    }

    private Row[] getViewToModel() {
        if (!this.arraysUpToDate.get() || this.viewToModel == null) {
            this.updateArrays();
        }
        return this.viewToModel;
    }

    public int modelIndex(int viewIndex) {
        return this.getViewToModel()[viewIndex].modelIndex;
    }

    private int[] getModelToView() {
        if (!this.arraysUpToDate.get() || this.modelToView == null) {
            this.updateArrays();
        }
        return this.modelToView;
    }

    @Override
    public int getRowCount() {
        return this.tableModel == null ? 0 : this.tableModel.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.tableModel == null ? 0 : this.tableModel.getColumnCount();
    }

    @Override
    public String getColumnName(int column) {
        return this.tableModel.getColumnName(column);
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return this.tableModel.getColumnClass(column);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this.tableModel.isCellEditable(this.modelIndex(row), column);
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.tableModel.getValueAt(this.modelIndex(row), column);
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        this.tableModel.setValueAt(aValue, this.modelIndex(row), column);
    }

    public void setTableHeaderYBounds(int yLoc, int height) {
        this.headerLabelYLoc = yLoc;
        this.headerLabelHeight = height;
    }

    @Override
    public void cleanup() {
        if (this.tableModel instanceof CleanupTableModel) {
            ((CleanupTableModel)((Object)this.tableModel)).cleanup();
        }
    }

    private static class Directive {
        private int column;
        private int direction;

        public Directive(int column, int direction) {
            this.column = column;
            this.direction = direction;
        }

        public int getColumn() {
            return this.column;
        }

        public int getDirection() {
            return this.direction;
        }
    }

    private class SortableHeaderRenderer
    implements TableCellRenderer {
        private TableCellRenderer tableCellRenderer;

        public SortableHeaderRenderer(TableCellRenderer tableCellRenderer) {
            this.tableCellRenderer = tableCellRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = this.tableCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (c instanceof JLabel) {
                JLabel l = (JLabel)c;
                if (TableModelSortDecorator.this.headerLabelYLoc == null) {
                    TableModelSortDecorator.this.headerLabelYLoc = 0;
                }
                l.setHorizontalTextPosition(2);
                int modelColumn = table.convertColumnIndexToModel(column);
                l.setIcon(TableModelSortDecorator.this.getHeaderRendererIcon(modelColumn, l.getFont().getSize()));
            }
            return c;
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            JTableHeader h = (JTableHeader)e.getSource();
            TableColumnModel columnModel = h.getColumnModel();
            Integer height = TableModelSortDecorator.this.headerLabelHeight;
            if (height == null) {
                height = h.getHeight();
            }
            logger.debug((Object)("Y mouse click at " + e.getY() + " header label y location " + TableModelSortDecorator.this.headerLabelYLoc + " header label height " + height));
            if (e.getY() > TableModelSortDecorator.this.headerLabelYLoc && e.getY() < TableModelSortDecorator.this.headerLabelYLoc + height) {
                logger.debug((Object)"Table header was clicked");
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                if (viewColumn < 0) {
                    return;
                }
                int column = columnModel.getColumn(viewColumn).getModelIndex();
                if (column != -1) {
                    int status = TableModelSortDecorator.this.getSortingStatus(column);
                    LinkedHashMap<Integer, Integer> newSortingStatus = new LinkedHashMap<Integer, Integer>();
                    if (!e.isControlDown()) {
                        for (Directive d : TableModelSortDecorator.this.sortingColumns) {
                            if (d.getDirection() == 0) continue;
                            newSortingStatus.put(d.getColumn(), 0);
                        }
                    }
                    status += e.isShiftDown() ? -1 : 1;
                    status = (status + 4) % 3 - 1;
                    newSortingStatus.put(column, status);
                    TableModelSortDecorator.this.setSortingStatus(newSortingStatus);
                }
            }
        }
    }

    private class TableModelHandler
    implements TableModelListener {
        private TableModelHandler() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (!TableModelSortDecorator.this.isSorting()) {
                if (e.getType() == 1) {
                    TableModelSortDecorator.this.clearSortingState();
                }
                TableModelSortDecorator.this.fireTableChanged(e);
                return;
            }
            if (e.getFirstRow() == -1) {
                TableModelSortDecorator.this.cancelSorting();
                TableModelSortDecorator.this.fireTableChanged(e);
                return;
            }
            int column = e.getColumn();
            if (e.getFirstRow() == e.getLastRow() && column != -1 && TableModelSortDecorator.this.getSortingStatus(column) == 0 && TableModelSortDecorator.this.modelToView != null) {
                int viewIndex = TableModelSortDecorator.this.getModelToView()[e.getFirstRow()];
                TableModelSortDecorator.this.fireTableChanged(new TableModelEvent(TableModelSortDecorator.this, viewIndex, viewIndex, column, e.getType()));
                return;
            }
            if (e.getType() == 1) {
                TableModelSortDecorator.this.clearSortingState();
            }
            TableModelSortDecorator.this.fireTableDataChanged();
        }
    }

    private class Row
    implements Comparable {
        private int modelIndex;

        public Row(int index) {
            this.modelIndex = index;
        }

        public int compareTo(Object o) {
            int row1 = this.modelIndex;
            int row2 = ((Row)o).modelIndex;
            for (Directive directive : TableModelSortDecorator.this.sortingColumns) {
                int column = directive.column;
                Object o1 = TableModelSortDecorator.this.tableModel.getValueAt(row1, column);
                Object o2 = TableModelSortDecorator.this.tableModel.getValueAt(row2, column);
                int comparison = 0;
                comparison = o1 == null && o2 == null ? 0 : (o1 == null ? -1 : (o2 == null ? 1 : TableModelSortDecorator.this.getComparator(column).compare(o1, o2)));
                if (comparison == 0) continue;
                return directive.direction == -1 ? -comparison : comparison;
            }
            return 0;
        }
    }
}

