/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.testutil;

import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.annotation.Accessor;
import ca.sqlpower.object.annotation.Mutator;
import ca.sqlpower.object.annotation.NonBound;
import ca.sqlpower.object.annotation.NonProperty;
import ca.sqlpower.object.annotation.Transient;
import ca.sqlpower.testutil.GenericNewValueMaker;
import ca.sqlpower.testutil.NewValueMaker;
import ca.sqlpower.testutil.SPObjectRoot;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.commons.beanutils.PropertyUtils;

public class TestUtils
extends TestCase {
    public static void testPropertiesFireEvents(Object target, Collection<String> propertiesToIgnore, NewValueMaker valueMaker) {
    }

    public static Map<String, Object> setAllInterestingProperties(Object target, Set<String> propertiesToIgnore) throws Exception {
        return TestUtils.setAllInterestingProperties(target, propertiesToIgnore, new GenericNewValueMaker(new SPObjectRoot()));
    }

    public static Map<String, Object> setAllInterestingProperties(Object target, Set<String> propertiesToIgnore, NewValueMaker valueMaker) throws Exception {
        PropertyDescriptor[] props = PropertyUtils.getPropertyDescriptors((Object)target);
        for (int i = 0; i < props.length; ++i) {
            Object oldVal = null;
            if (PropertyUtils.isReadable((Object)target, (String)props[i].getName()) && props[i].getReadMethod() != null && !propertiesToIgnore.contains(props[i].getName())) {
                oldVal = PropertyUtils.getProperty((Object)target, (String)props[i].getName());
            }
            if (!PropertyUtils.isWriteable((Object)target, (String)props[i].getName()) || props[i].getWriteMethod() == null || propertiesToIgnore.contains(props[i].getName())) continue;
            Object newVal = valueMaker.makeNewValue(props[i].getPropertyType(), oldVal, props[i].getName());
            System.out.println("Changing property \"" + props[i].getName() + "\" to \"" + newVal + "\"");
            PropertyUtils.setProperty((Object)target, (String)props[i].getName(), (Object)newVal);
        }
        return TestUtils.getAllInterestingProperties(target, propertiesToIgnore);
    }

    public static Map<String, Object> getAllInterestingProperties(Object target, Set<String> propertiesToIgnore) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        HashMap<String, Object> newDescription = new HashMap<String, Object>();
        PropertyDescriptor[] props = PropertyUtils.getPropertyDescriptors((Object)target);
        for (int i = 0; i < props.length; ++i) {
            if (!PropertyUtils.isReadable((Object)target, (String)props[i].getName()) || props[i].getReadMethod() == null || propertiesToIgnore.contains(props[i].getName())) continue;
            newDescription.put(props[i].getName(), PropertyUtils.getProperty((Object)target, (String)props[i].getName()));
        }
        return newDescription;
    }

    public static Set<String> findPersistableBeanProperties(SPObject objectUnderTest, boolean includeTransient, boolean includeConstructorMutators) throws Exception {
        return TestUtils.findPersistableBeanProperties(objectUnderTest.getClass(), includeTransient, includeConstructorMutators);
    }

    public static Set<String> findPersistableBeanProperties(Class<? extends SPObject> objectUnderTest, boolean includeTransient, boolean includeConstructorMutators) throws Exception {
        HashSet<String> getters = new HashSet<String>();
        HashSet<String> setters = new HashSet<String>();
        for (Method m : objectUnderTest.getMethods()) {
            if (m.getName().equals("getClass") || !Modifier.isPublic(m.getModifiers()) || Modifier.isStatic(m.getModifiers())) continue;
            if (m.getName().startsWith("get") || m.getName().startsWith("is")) {
                Class<? extends SPObject> parentClass = objectUnderTest;
                boolean accessor = false;
                boolean ignored = false;
                boolean isTransient = false;
                parentClass.getMethod(m.getName(), m.getParameterTypes());
                while (parentClass != null) {
                    Method parentMethod;
                    try {
                        parentMethod = parentClass.getMethod(m.getName(), m.getParameterTypes());
                    }
                    catch (NoSuchMethodException e) {
                        parentClass = parentClass.getSuperclass();
                        continue;
                    }
                    if (parentMethod.getAnnotation(Accessor.class) != null) {
                        accessor = true;
                        if (parentMethod.getAnnotation(Transient.class) == null) break;
                        isTransient = true;
                        break;
                    }
                    if (parentMethod.getAnnotation(NonProperty.class) != null || parentMethod.getAnnotation(NonBound.class) != null) {
                        ignored = true;
                        break;
                    }
                    parentClass = parentClass.getSuperclass();
                }
                if (accessor) {
                    if (!includeTransient && isTransient) continue;
                    if (m.getName().startsWith("get")) {
                        getters.add(m.getName().substring(3));
                        continue;
                    }
                    if (!m.getName().startsWith("is")) continue;
                    getters.add(m.getName().substring(2));
                    continue;
                }
                if (ignored) continue;
                TestUtils.fail((String)("The method " + m.getName() + " of " + objectUnderTest.toString() + " is a getter that is not annotated " + "to be an accessor or transient. The exiting annotations are " + Arrays.toString(m.getAnnotations())));
                continue;
            }
            if (!m.getName().startsWith("set")) continue;
            if (m.getAnnotation(Mutator.class) != null) {
                if (!includeTransient && m.getAnnotation(Transient.class) != null || !includeConstructorMutators && m.getAnnotation(Mutator.class).constructorMutator()) continue;
                setters.add(m.getName().substring(3));
                continue;
            }
            if (m.getAnnotation(NonProperty.class) != null || m.getAnnotation(NonBound.class) != null) continue;
            TestUtils.fail((String)("The method " + m.getName() + " is a setter that is not annotated " + "to be a mutator or transient."));
        }
        HashSet<String> beanNames = new HashSet<String>();
        for (String beanName : getters) {
            if (!setters.contains(beanName)) continue;
            String firstLetter = new String(new char[]{beanName.charAt(0)});
            beanNames.add(beanName.replaceFirst(firstLetter, firstLetter.toLowerCase()));
        }
        return beanNames;
    }
}

