/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.util;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.SortedSetMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class HashTreeSetMultimap<K, V>
implements SortedSetMultimap<K, V> {
    private final Map<K, TreeSet<V>> map = new HashMap<K, TreeSet<V>>();
    private final Comparator<V> valueComparator;

    public HashTreeSetMultimap(Comparator<V> valueComparator) {
        this.valueComparator = valueComparator;
    }

    public Set<Map.Entry<K, V>> entries() {
        HashSet<Map.Entry<K, V>> entries = new HashSet<Map.Entry<K, V>>();
        for (final K k : this.map.keySet()) {
            for (final V v : this.map.get(k)) {
                entries.add(new Map.Entry<K, V>(){

                    @Override
                    public K getKey() {
                        return k;
                    }

                    @Override
                    public V getValue() {
                        return v;
                    }

                    @Override
                    public V setValue(V value) {
                        throw new IllegalStateException();
                    }
                });
            }
        }
        return entries;
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsEntry(Object k, Object v) {
        return this.map.get(k).contains(v);
    }

    public boolean containsKey(Object k) {
        return this.map.containsKey(k);
    }

    public boolean containsValue(Object v) {
        for (Map.Entry<K, TreeSet<V>> entry : this.map.entrySet()) {
            if (!entry.getValue().contains(v)) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public Multiset<K> keys() {
        return HashMultiset.create(this.map.keySet());
    }

    public boolean put(K k, V v) {
        TreeSet<V> set = this.map.get(k);
        if (set == null) {
            set = new TreeSet<V>(this.valueComparator);
            this.map.put(k, set);
        }
        return set.add(v);
    }

    public boolean putAll(Multimap<? extends K, ? extends V> newValues) {
        for (Map.Entry entry : newValues.entries()) {
            this.put(entry.getKey(), entry.getValue());
        }
        return false;
    }

    public boolean putAll(K k, Iterable<? extends V> values) {
        boolean mapChanged = false;
        for (V v : values) {
            mapChanged = mapChanged || this.put(k, v);
        }
        return mapChanged;
    }

    public boolean remove(Object k, Object v) {
        if (this.map.get(k) == null) {
            return false;
        }
        boolean removed = this.map.get(k).remove(v);
        if (this.map.get(k).isEmpty()) {
            this.map.remove(k);
        }
        return removed;
    }

    public int size() {
        return this.values().size();
    }

    public Collection<V> values() {
        ArrayList values = new ArrayList();
        for (K k : this.map.keySet()) {
            values.addAll(this.map.get(k));
        }
        return null;
    }

    public Map<K, Collection<V>> asMap() {
        return Collections.unmodifiableMap(this.map);
    }

    public SortedSet<V> get(K k) {
        if (this.map.get(k) == null) {
            return new TreeSet();
        }
        return Collections.unmodifiableSortedSet((SortedSet)this.map.get(k));
    }

    public SortedSet<V> removeAll(Object k) {
        return this.map.remove(k);
    }

    public SortedSet<V> replaceValues(K k, Iterable<? extends V> values) {
        TreeSet<V> replacedValues = new TreeSet<V>();
        for (V v : values) {
            if (this.remove(k, v)) {
                replacedValues.add(v);
            }
            this.put(k, v);
        }
        return replacedValues;
    }

    public Comparator<? super V> valueComparator() {
        return this.valueComparator;
    }
}

