/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.log4j.Logger;

public abstract class JarScanClassLoader
extends ClassLoader {
    private static final Logger logger = Logger.getLogger(JarScanClassLoader.class);
    private List<String> drivers;
    private int count = 0;
    private JarURLConnection jarConnection;
    private JarFile jf;

    public JarScanClassLoader(URL jarLocation) throws IOException {
        URL jarURL = new URL("jar:" + jarLocation + "!/");
        this.jarConnection = (JarURLConnection)jarURL.openConnection();
        this.jf = this.jarConnection.getJarFile();
    }

    public synchronized double getFraction() {
        double retval = 0.0;
        if (this.jf != null) {
            retval = (double)this.count / (double)this.jf.size();
        }
        return retval;
    }

    public List<String> scanForDrivers() {
        this.drivers = new LinkedList<String>();
        logger.debug((Object)("********* " + this.jf.getName() + " has " + this.jf.size() + " files."));
        Enumeration<JarEntry> entries = this.jf.entries();
        while (entries.hasMoreElements()) {
            ++this.count;
            ZipEntry ent = entries.nextElement();
            if (!ent.getName().endsWith(".class")) continue;
            try {
                String[] s = ent.getName().split("\\.");
                this.findClass(s[0].replace('/', '.'));
            }
            catch (ClassFormatError ex) {
                logger.warn((Object)("JAR entry " + ent.getName() + " ends in .class but is not a class"), (Throwable)ex);
            }
            catch (NoClassDefFoundError ex) {
                logger.warn((Object)("JAR does not contain dependency needed by: " + ent.getName()));
            }
            catch (Throwable ex) {
                logger.warn((Object)("Unexpected exception while scanning JAR file " + this.jf.getName()), ex);
            }
        }
        return this.drivers;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            ZipEntry ent = this.jf.getEntry(name.replace('.', '/') + ".class");
            if (ent == null) {
                throw new ClassNotFoundException("No class file " + name + " is in my jar file");
            }
            Class<?> clazz = this.findLoadedClass(name);
            if (clazz != null) {
                return clazz;
            }
            InputStream is = this.jf.getInputStream(ent);
            return this.readAndCheckClass(is, (int)ent.getSize(), name);
        }
        catch (IOException ex) {
            throw new ClassNotFoundException("IO Exception reading class from jar file", ex);
        }
    }

    private Class<?> readAndCheckClass(InputStream is, int size, String expectedName) throws IOException, ClassFormatError {
        Class<?> clazz;
        int offs;
        int n;
        byte[] buf = new byte[size];
        for (offs = 0; (n = is.read(buf, offs, size - offs)) >= 0 && offs < size; offs += n) {
        }
        int total = offs;
        if (total != size) {
            logger.warn((Object)("Only read " + total + " bytes of class " + expectedName + " from JAR file; exptected " + size));
        }
        if (this.checkClass(clazz = this.defineClass(expectedName, buf, 0, total))) {
            logger.info((Object)("Found jdbc driver " + clazz.getName()));
            this.drivers.add(clazz.getName());
        }
        return clazz;
    }

    protected abstract boolean checkClass(Class<?> var1);
}

