/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.mstor.connector.mbox;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.mail.Message;
import javax.mail.MessagingException;
import net.fortuna.mstor.connector.DelegateException;
import net.fortuna.mstor.connector.FolderDelegate;
import net.fortuna.mstor.connector.MessageDelegate;
import net.fortuna.mstor.connector.mbox.AbstractMetaFolder;
import net.fortuna.mstor.connector.mbox.MetaMessage;
import net.fortuna.mstor.data.xml.DocumentBinding;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaFolder
extends AbstractMetaFolder<MetaMessage> {
    private static final String ELEMENT_FOLDER = "folder";
    private static final String ELEMENT_LAST_UID = "last-uid";
    private static final String ELEMENT_UID_VALIDITY = "uid-validity";
    public static final String FILE_EXTENSION = ".emf";
    private DocumentBinding binding;

    public MetaFolder(FolderDelegate<MessageDelegate> delegate) {
        super(delegate);
        this.binding = new DocumentBinding(this.getFile(), ELEMENT_FOLDER);
    }

    public MetaFolder(Namespace namespace, FolderDelegate<MessageDelegate> delegate) {
        super(delegate);
        this.binding = new DocumentBinding(this.getFile(), namespace, ELEMENT_FOLDER);
    }

    public MetaFolder getParent() {
        return new MetaFolder(this.getDelegate().getParent());
    }

    public MetaFolder getFolder(String name) throws MessagingException {
        return new MetaFolder(this.getDelegate().getFolder(name));
    }

    public MetaFolder[] list(String pattern) {
        ArrayList<MetaFolder> folders = new ArrayList<MetaFolder>();
        FolderDelegate<MessageDelegate>[] delegateList = this.getDelegate().list(pattern);
        for (int i = 0; i < delegateList.length; ++i) {
            folders.add(new MetaFolder(delegateList[i]));
        }
        return folders.toArray(new MetaFolder[folders.size()]);
    }

    @Override
    public final MetaMessage getMessage(int messageNumber) throws DelegateException {
        MetaMessage md = null;
        for (Element messageElement : this.binding.getDocument().getRootElement().getChildren("message", this.binding.getNamespace())) {
            try {
                if (Integer.parseInt(messageElement.getAttributeValue("messageNumber")) != messageNumber) continue;
                md = new MetaMessage(messageElement, this, this.binding.getNamespace());
                break;
            }
            catch (Exception e) {
                throw new DelegateException("Caught exception parsing message number", e);
            }
        }
        if (md == null) {
            md = this.createMessage(messageNumber);
            this.allocateUid(md);
        }
        return md;
    }

    @Override
    protected final MetaMessage createMessage(int messageNumber) {
        MetaMessage delegate = new MetaMessage(messageNumber, this, this.binding.getNamespace());
        if (messageNumber > 0) {
            this.addMessage(delegate);
        }
        return delegate;
    }

    private void addMessage(MessageDelegate message) {
        this.binding.getDocument().getRootElement().addContent((Content)((MetaMessage)message).getElement());
    }

    protected MetaMessage[] removeMessages(Message[] messages) {
        ArrayList<MetaMessage> metas = new ArrayList<MetaMessage>();
        Iterator i = this.binding.getDocument().getRootElement().getChildren("message", this.binding.getNamespace()).iterator();
        block0: while (i.hasNext()) {
            Element messageElement = (Element)i.next();
            int messageNumber = Integer.parseInt(messageElement.getAttributeValue("messageNumber"));
            for (int n = 0; n < messages.length; ++n) {
                if (messages[n].getMessageNumber() != messageNumber) continue;
                i.remove();
                metas.add(new MetaMessage(messageElement, this, this.binding.getNamespace()));
                this.updateMessageNumbers(messageNumber, -1);
                continue block0;
            }
        }
        return metas.toArray(new MetaMessage[metas.size()]);
    }

    private void updateMessageNumbers(int startIndex, int delta) {
        for (Element messageElement : this.binding.getDocument().getRootElement().getChildren("message", this.binding.getNamespace())) {
            int messageNumber = Integer.parseInt(messageElement.getAttributeValue("messageNumber"));
            if (messageNumber < startIndex) continue;
            messageElement.setAttribute("messageNumber", String.valueOf(messageNumber + delta));
        }
    }

    private Element getLastUidElement() {
        Element lastUidElement = this.binding.getDocument().getRootElement().getChild(ELEMENT_LAST_UID, this.binding.getNamespace());
        if (lastUidElement == null) {
            lastUidElement = new Element(ELEMENT_LAST_UID, this.binding.getNamespace());
            lastUidElement.setText("0");
            this.binding.getDocument().getRootElement().addContent((Content)lastUidElement);
        }
        return lastUidElement;
    }

    @Override
    public final long getLastUid() {
        Element lastUidElement = this.getLastUidElement();
        return Long.parseLong(lastUidElement.getText());
    }

    @Override
    public final long getUidValidity() throws UnsupportedOperationException, MessagingException {
        Element uidValidityElement = this.binding.getDocument().getRootElement().getChild(ELEMENT_UID_VALIDITY, this.binding.getNamespace());
        if (uidValidityElement == null) {
            uidValidityElement = new Element(ELEMENT_UID_VALIDITY, this.binding.getNamespace());
            uidValidityElement.setText(String.valueOf(this.newUidValidity()));
            this.binding.getDocument().getRootElement().addContent((Content)uidValidityElement);
            try {
                this.save();
            }
            catch (DelegateException de) {
                throw new MessagingException("Error in delegate", (Exception)de);
            }
        }
        return Long.parseLong(uidValidityElement.getText());
    }

    @Override
    protected final void setLastUid(long uid) throws DelegateException {
        Element lastUidElement = this.getLastUidElement();
        lastUidElement.setText(String.valueOf(uid));
        this.save();
    }

    @Override
    protected String getFileExtension() {
        return FILE_EXTENSION;
    }

    @Override
    public final void save() throws DelegateException {
        try {
            this.binding.save();
        }
        catch (IOException ioe) {
            throw new DelegateException("Error saving changes", ioe);
        }
    }
}

