/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.mstor.search;

import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.search.SearchTerm;
import net.fortuna.mstor.tag.Taggable;
import net.fortuna.mstor.tag.Tags;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TagsTerm
extends SearchTerm {
    private Log log = LogFactory.getLog(TagsTerm.class);
    private static final long serialVersionUID = 7893903141033644620L;
    private Tags tags;

    public TagsTerm() {
        this(new Tags());
    }

    public TagsTerm(Tags tags) {
        this.tags = tags;
    }

    public final boolean match(Message m) {
        try {
            Taggable message = (Taggable)m;
            return message.getTags().containsAll(this.tags);
        }
        catch (ClassCastException cce) {
            this.log.error((Object)"Invalid message type", (Throwable)cce);
        }
        catch (MessagingException me) {
            this.log.error((Object)"Exception occured", (Throwable)me);
        }
        return false;
    }

    public final Tags getTags() {
        return this.tags;
    }
}

