/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.IOException;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobPriority;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.JobSubmitter;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskCompletionEvent;
import org.apache.hadoop.mapreduce.TaskReport;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.filecache.DistributedCache;
import org.apache.hadoop.mapreduce.protocol.ClientProtocol;
import org.apache.hadoop.mapreduce.task.JobContextImpl;
import org.apache.hadoop.mapreduce.util.ConfigUtil;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ReservationId;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class Job
extends JobContextImpl
implements JobContext {
    private static final Log LOG = LogFactory.getLog(Job.class);
    private static final long MAX_JOBSTATUS_AGE = 2000L;
    public static final String OUTPUT_FILTER = "mapreduce.client.output.filter";
    public static final String COMPLETION_POLL_INTERVAL_KEY = "mapreduce.client.completion.pollinterval";
    static final int DEFAULT_COMPLETION_POLL_INTERVAL = 5000;
    public static final String PROGRESS_MONITOR_POLL_INTERVAL_KEY = "mapreduce.client.progressmonitor.pollinterval";
    static final int DEFAULT_MONITOR_POLL_INTERVAL = 1000;
    public static final String USED_GENERIC_PARSER = "mapreduce.client.genericoptionsparser.used";
    public static final String SUBMIT_REPLICATION = "mapreduce.client.submit.file.replication";
    public static final int DEFAULT_SUBMIT_REPLICATION = 10;
    private JobState state = JobState.DEFINE;
    private JobStatus status;
    private long statustime;
    private Cluster cluster;
    private ReservationId reservationId;

    @Deprecated
    public Job() throws IOException {
        this(new JobConf(new Configuration()));
    }

    @Deprecated
    public Job(Configuration conf) throws IOException {
        this(new JobConf(conf));
    }

    @Deprecated
    public Job(Configuration conf, String jobName) throws IOException {
        this(new JobConf(conf));
        this.setJobName(jobName);
    }

    Job(JobConf conf) throws IOException {
        super(conf, null);
        this.credentials.mergeAll(this.ugi.getCredentials());
        this.cluster = null;
    }

    Job(JobStatus status, JobConf conf) throws IOException {
        this(conf);
        this.setJobID(status.getJobID());
        this.status = status;
        this.state = JobState.RUNNING;
    }

    public static Job getInstance() throws IOException {
        return Job.getInstance(new Configuration());
    }

    public static Job getInstance(Configuration conf) throws IOException {
        JobConf jobConf = new JobConf(conf);
        return new Job(jobConf);
    }

    public static Job getInstance(Configuration conf, String jobName) throws IOException {
        Job result = Job.getInstance(conf);
        result.setJobName(jobName);
        return result;
    }

    public static Job getInstance(JobStatus status, Configuration conf) throws IOException {
        return new Job(status, new JobConf(conf));
    }

    @Deprecated
    public static Job getInstance(Cluster ignored) throws IOException {
        return Job.getInstance();
    }

    @Deprecated
    public static Job getInstance(Cluster ignored, Configuration conf) throws IOException {
        return Job.getInstance(conf);
    }

    @InterfaceAudience.Private
    public static Job getInstance(Cluster cluster, JobStatus status, Configuration conf) throws IOException {
        Job job = Job.getInstance(status, conf);
        job.setCluster(cluster);
        return job;
    }

    private void ensureState(JobState state) throws IllegalStateException {
        if (state != this.state) {
            throw new IllegalStateException("Job in state " + (Object)((Object)this.state) + " instead of " + (Object)((Object)state));
        }
        if (state == JobState.RUNNING && this.cluster == null) {
            throw new IllegalStateException("Job in state " + (Object)((Object)this.state) + ", but it isn't attached to any job tracker!");
        }
    }

    synchronized void ensureFreshStatus() throws IOException {
        if (System.currentTimeMillis() - this.statustime > 2000L) {
            this.updateStatus();
        }
    }

    synchronized void updateStatus() throws IOException {
        try {
            this.status = (JobStatus)this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<JobStatus>(){

                @Override
                public JobStatus run() throws IOException, InterruptedException {
                    return Job.this.cluster.getClient().getJobStatus(Job.this.getJobID());
                }
            });
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
        if (this.status == null) {
            throw new IOException("Job status not available ");
        }
        this.statustime = System.currentTimeMillis();
    }

    public JobStatus getStatus() throws IOException, InterruptedException {
        this.ensureState(JobState.RUNNING);
        this.updateStatus();
        return this.status;
    }

    public JobStatus.State getJobState() throws IOException, InterruptedException {
        this.ensureState(JobState.RUNNING);
        this.updateStatus();
        return this.status.getState();
    }

    public String getTrackingURL() {
        this.ensureState(JobState.RUNNING);
        return this.status.getTrackingUrl().toString();
    }

    public String getJobFile() {
        this.ensureState(JobState.RUNNING);
        return this.status.getJobFile();
    }

    public long getStartTime() {
        this.ensureState(JobState.RUNNING);
        return this.status.getStartTime();
    }

    public long getFinishTime() throws IOException, InterruptedException {
        this.ensureState(JobState.RUNNING);
        this.updateStatus();
        return this.status.getFinishTime();
    }

    public String getSchedulingInfo() {
        this.ensureState(JobState.RUNNING);
        return this.status.getSchedulingInfo();
    }

    public org.apache.hadoop.mapreduce.JobPriority getPriority() throws IOException, InterruptedException {
        this.ensureState(JobState.RUNNING);
        this.updateStatus();
        return this.status.getPriority();
    }

    @Override
    public String getJobName() {
        if (this.state == JobState.DEFINE || this.status == null) {
            return super.getJobName();
        }
        this.ensureState(JobState.RUNNING);
        return this.status.getJobName();
    }

    public String getHistoryUrl() throws IOException, InterruptedException {
        this.ensureState(JobState.RUNNING);
        this.updateStatus();
        return this.status.getHistoryFile();
    }

    public boolean isRetired() throws IOException, InterruptedException {
        this.ensureState(JobState.RUNNING);
        this.updateStatus();
        return this.status.isRetired();
    }

    @InterfaceAudience.Private
    public Cluster getCluster() {
        return this.cluster;
    }

    @InterfaceAudience.Private
    private void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }

    public String toString() {
        this.ensureState(JobState.RUNNING);
        String reasonforFailure = " ";
        int numMaps = 0;
        int numReduces = 0;
        try {
            this.updateStatus();
            if (this.status.getState().equals((Object)JobStatus.State.FAILED)) {
                reasonforFailure = this.getTaskFailureEventString();
            }
            numMaps = this.getTaskReports(TaskType.MAP).length;
            numReduces = this.getTaskReports(TaskType.REDUCE).length;
        }
        catch (IOException e) {
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        StringBuffer sb = new StringBuffer();
        sb.append("Job: ").append(this.status.getJobID()).append("\n");
        sb.append("Job File: ").append(this.status.getJobFile()).append("\n");
        sb.append("Job Tracking URL : ").append(this.status.getTrackingUrl());
        sb.append("\n");
        sb.append("Uber job : ").append(this.status.isUber()).append("\n");
        sb.append("Number of maps: ").append(numMaps).append("\n");
        sb.append("Number of reduces: ").append(numReduces).append("\n");
        sb.append("map() completion: ");
        sb.append(this.status.getMapProgress()).append("\n");
        sb.append("reduce() completion: ");
        sb.append(this.status.getReduceProgress()).append("\n");
        sb.append("Job state: ");
        sb.append((Object)this.status.getState()).append("\n");
        sb.append("retired: ").append(this.status.isRetired()).append("\n");
        sb.append("reason for failure: ").append(reasonforFailure);
        return sb.toString();
    }

    String getTaskFailureEventString() throws IOException, InterruptedException {
        org.apache.hadoop.mapreduce.TaskCompletionEvent[] events;
        int failCount = 1;
        org.apache.hadoop.mapreduce.TaskCompletionEvent lastEvent = null;
        for (org.apache.hadoop.mapreduce.TaskCompletionEvent event : events = (org.apache.hadoop.mapreduce.TaskCompletionEvent[])this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<org.apache.hadoop.mapreduce.TaskCompletionEvent[]>(){

            @Override
            public org.apache.hadoop.mapreduce.TaskCompletionEvent[] run() throws IOException, InterruptedException {
                return Job.this.cluster.getClient().getTaskCompletionEvents(Job.this.status.getJobID(), 0, 10);
            }
        })) {
            if (!event.getStatus().equals((Object)TaskCompletionEvent.Status.FAILED)) continue;
            ++failCount;
            lastEvent = event;
        }
        if (lastEvent == null) {
            return "There are no failed tasks for the job. Job is failed due to some other reason and reason can be found in the logs.";
        }
        String[] taskAttemptID = lastEvent.getTaskAttemptId().toString().split("_", 2);
        String taskID = taskAttemptID[1].substring(0, taskAttemptID[1].length() - 2);
        return " task " + taskID + " failed " + failCount + " times " + "For details check tasktracker at: " + lastEvent.getTaskTrackerHttp();
    }

    public TaskReport[] getTaskReports(TaskType type) throws IOException, InterruptedException {
        this.ensureState(JobState.RUNNING);
        final TaskType tmpType = type;
        return (TaskReport[])this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<TaskReport[]>(){

            @Override
            public TaskReport[] run() throws IOException, InterruptedException {
                return Job.this.cluster.getClient().getTaskReports(Job.this.getJobID(), tmpType);
            }
        });
    }

    public float mapProgress() throws IOException {
        this.ensureState(JobState.RUNNING);
        this.ensureFreshStatus();
        return this.status.getMapProgress();
    }

    public float reduceProgress() throws IOException {
        this.ensureState(JobState.RUNNING);
        this.ensureFreshStatus();
        return this.status.getReduceProgress();
    }

    public float cleanupProgress() throws IOException, InterruptedException {
        this.ensureState(JobState.RUNNING);
        this.ensureFreshStatus();
        return this.status.getCleanupProgress();
    }

    public float setupProgress() throws IOException {
        this.ensureState(JobState.RUNNING);
        this.ensureFreshStatus();
        return this.status.getSetupProgress();
    }

    public boolean isComplete() throws IOException {
        this.ensureState(JobState.RUNNING);
        this.updateStatus();
        return this.status.isJobComplete();
    }

    public boolean isSuccessful() throws IOException {
        this.ensureState(JobState.RUNNING);
        this.updateStatus();
        return this.status.getState() == JobStatus.State.SUCCEEDED;
    }

    public void killJob() throws IOException {
        this.ensureState(JobState.RUNNING);
        try {
            this.cluster.getClient().killJob(this.getJobID());
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    public void setPriority(org.apache.hadoop.mapreduce.JobPriority priority) throws IOException, InterruptedException {
        if (this.state == JobState.DEFINE) {
            this.conf.setJobPriority(JobPriority.valueOf(priority.name()));
        } else {
            this.ensureState(JobState.RUNNING);
            final org.apache.hadoop.mapreduce.JobPriority tmpPriority = priority;
            this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws IOException, InterruptedException {
                    Job.this.cluster.getClient().setJobPriority(Job.this.getJobID(), tmpPriority.toString());
                    return null;
                }
            });
        }
    }

    public org.apache.hadoop.mapreduce.TaskCompletionEvent[] getTaskCompletionEvents(final int startFrom, final int numEvents) throws IOException, InterruptedException {
        this.ensureState(JobState.RUNNING);
        return (org.apache.hadoop.mapreduce.TaskCompletionEvent[])this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<org.apache.hadoop.mapreduce.TaskCompletionEvent[]>(){

            @Override
            public org.apache.hadoop.mapreduce.TaskCompletionEvent[] run() throws IOException, InterruptedException {
                return Job.this.cluster.getClient().getTaskCompletionEvents(Job.this.getJobID(), startFrom, numEvents);
            }
        });
    }

    public TaskCompletionEvent[] getTaskCompletionEvents(int startFrom) throws IOException {
        try {
            org.apache.hadoop.mapreduce.TaskCompletionEvent[] events = this.getTaskCompletionEvents(startFrom, 10);
            TaskCompletionEvent[] retEvents = new TaskCompletionEvent[events.length];
            for (int i = 0; i < events.length; ++i) {
                retEvents[i] = TaskCompletionEvent.downgrade(events[i]);
            }
            return retEvents;
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    @InterfaceAudience.Private
    public boolean killTask(final TaskAttemptID taskId, final boolean shouldFail) throws IOException {
        this.ensureState(JobState.RUNNING);
        try {
            return (Boolean)this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws IOException, InterruptedException {
                    return Job.this.cluster.getClient().killTask(taskId, shouldFail);
                }
            });
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    public void killTask(TaskAttemptID taskId) throws IOException {
        this.killTask(taskId, false);
    }

    public void failTask(TaskAttemptID taskId) throws IOException {
        this.killTask(taskId, true);
    }

    public Counters getCounters() throws IOException {
        this.ensureState(JobState.RUNNING);
        try {
            return (Counters)this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Counters>(){

                @Override
                public Counters run() throws IOException, InterruptedException {
                    return Job.this.cluster.getClient().getJobCounters(Job.this.getJobID());
                }
            });
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    public String[] getTaskDiagnostics(final TaskAttemptID taskid) throws IOException, InterruptedException {
        this.ensureState(JobState.RUNNING);
        return (String[])this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String[]>(){

            @Override
            public String[] run() throws IOException, InterruptedException {
                return Job.this.cluster.getClient().getTaskDiagnostics(taskid);
            }
        });
    }

    public void setNumReduceTasks(int tasks) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setNumReduceTasks(tasks);
    }

    public void setWorkingDirectory(Path dir) throws IOException {
        this.ensureState(JobState.DEFINE);
        this.conf.setWorkingDirectory(dir);
    }

    public void setInputFormatClass(Class<? extends InputFormat> cls) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setClass("mapreduce.job.inputformat.class", cls, InputFormat.class);
    }

    public void setOutputFormatClass(Class<? extends OutputFormat> cls) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setClass("mapreduce.job.outputformat.class", cls, OutputFormat.class);
    }

    public void setMapperClass(Class<? extends Mapper> cls) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setClass("mapreduce.job.map.class", cls, Mapper.class);
    }

    public void setJarByClass(Class<?> cls) {
        this.ensureState(JobState.DEFINE);
        this.conf.setJarByClass(cls);
    }

    public void setJar(String jar) {
        this.ensureState(JobState.DEFINE);
        this.conf.setJar(jar);
    }

    public void setUser(String user) {
        this.ensureState(JobState.DEFINE);
        this.conf.setUser(user);
    }

    public void setCombinerClass(Class<? extends Reducer> cls) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setClass("mapreduce.job.combine.class", cls, Reducer.class);
    }

    public void setReducerClass(Class<? extends Reducer> cls) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setClass("mapreduce.job.reduce.class", cls, Reducer.class);
    }

    public void setPartitionerClass(Class<? extends Partitioner> cls) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setClass("mapreduce.job.partitioner.class", cls, Partitioner.class);
    }

    public void setMapOutputKeyClass(Class<?> theClass) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setMapOutputKeyClass(theClass);
    }

    public void setMapOutputValueClass(Class<?> theClass) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setMapOutputValueClass(theClass);
    }

    public void setOutputKeyClass(Class<?> theClass) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setOutputKeyClass(theClass);
    }

    public void setOutputValueClass(Class<?> theClass) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setOutputValueClass(theClass);
    }

    public void setCombinerKeyGroupingComparatorClass(Class<? extends RawComparator> cls) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setCombinerKeyGroupingComparator(cls);
    }

    public void setSortComparatorClass(Class<? extends RawComparator> cls) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setOutputKeyComparatorClass(cls);
    }

    public void setGroupingComparatorClass(Class<? extends RawComparator> cls) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setOutputValueGroupingComparator(cls);
    }

    public void setJobName(String name) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setJobName(name);
    }

    public void setSpeculativeExecution(boolean speculativeExecution) {
        this.ensureState(JobState.DEFINE);
        this.conf.setSpeculativeExecution(speculativeExecution);
    }

    public void setMapSpeculativeExecution(boolean speculativeExecution) {
        this.ensureState(JobState.DEFINE);
        this.conf.setMapSpeculativeExecution(speculativeExecution);
    }

    public void setReduceSpeculativeExecution(boolean speculativeExecution) {
        this.ensureState(JobState.DEFINE);
        this.conf.setReduceSpeculativeExecution(speculativeExecution);
    }

    public void setJobSetupCleanupNeeded(boolean needed) {
        this.ensureState(JobState.DEFINE);
        this.conf.setBoolean("mapreduce.job.committer.setup.cleanup.needed", needed);
    }

    public void setCacheArchives(URI[] archives) {
        this.ensureState(JobState.DEFINE);
        DistributedCache.setCacheArchives(archives, this.conf);
    }

    public void setCacheFiles(URI[] files) {
        this.ensureState(JobState.DEFINE);
        DistributedCache.setCacheFiles(files, this.conf);
    }

    public void addCacheArchive(URI uri) {
        this.ensureState(JobState.DEFINE);
        DistributedCache.addCacheArchive(uri, this.conf);
    }

    public void addCacheFile(URI uri) {
        this.ensureState(JobState.DEFINE);
        DistributedCache.addCacheFile(uri, this.conf);
    }

    public void addFileToClassPath(Path file) throws IOException {
        this.ensureState(JobState.DEFINE);
        DistributedCache.addFileToClassPath(file, this.conf, file.getFileSystem((Configuration)this.conf));
    }

    public void addArchiveToClassPath(Path archive) throws IOException {
        this.ensureState(JobState.DEFINE);
        DistributedCache.addArchiveToClassPath(archive, this.conf, archive.getFileSystem((Configuration)this.conf));
    }

    @Deprecated
    public void createSymlink() {
        this.ensureState(JobState.DEFINE);
        DistributedCache.createSymlink(this.conf);
    }

    public void setMaxMapAttempts(int n) {
        this.ensureState(JobState.DEFINE);
        this.conf.setMaxMapAttempts(n);
    }

    public void setMaxReduceAttempts(int n) {
        this.ensureState(JobState.DEFINE);
        this.conf.setMaxReduceAttempts(n);
    }

    public void setProfileEnabled(boolean newValue) {
        this.ensureState(JobState.DEFINE);
        this.conf.setProfileEnabled(newValue);
    }

    public void setProfileParams(String value) {
        this.ensureState(JobState.DEFINE);
        this.conf.setProfileParams(value);
    }

    public void setProfileTaskRange(boolean isMap, String newValue) {
        this.ensureState(JobState.DEFINE);
        this.conf.setProfileTaskRange(isMap, newValue);
    }

    private void ensureNotSet(String attr, String msg) throws IOException {
        if (this.conf.get(attr) != null) {
            throw new IOException(attr + " is incompatible with " + msg + " mode.");
        }
    }

    public void setCancelDelegationTokenUponJobCompletion(boolean value) {
        this.ensureState(JobState.DEFINE);
        this.conf.setBoolean("mapreduce.job.complete.cancel.delegation.tokens", value);
    }

    private void setUseNewAPI() throws IOException {
        String mode;
        int numReduces = this.conf.getNumReduceTasks();
        String oldMapperClass = "mapred.mapper.class";
        String oldReduceClass = "mapred.reducer.class";
        this.conf.setBooleanIfUnset("mapred.mapper.new-api", this.conf.get(oldMapperClass) == null);
        if (this.conf.getUseNewMapper()) {
            mode = "new map API";
            this.ensureNotSet("mapred.input.format.class", mode);
            this.ensureNotSet(oldMapperClass, mode);
            if (numReduces != 0) {
                this.ensureNotSet("mapred.partitioner.class", mode);
            } else {
                this.ensureNotSet("mapred.output.format.class", mode);
            }
        } else {
            mode = "map compatability";
            this.ensureNotSet("mapreduce.job.inputformat.class", mode);
            this.ensureNotSet("mapreduce.job.map.class", mode);
            if (numReduces != 0) {
                this.ensureNotSet("mapreduce.job.partitioner.class", mode);
            } else {
                this.ensureNotSet("mapreduce.job.outputformat.class", mode);
            }
        }
        if (numReduces != 0) {
            this.conf.setBooleanIfUnset("mapred.reducer.new-api", this.conf.get(oldReduceClass) == null);
            if (this.conf.getUseNewReducer()) {
                mode = "new reduce API";
                this.ensureNotSet("mapred.output.format.class", mode);
                this.ensureNotSet(oldReduceClass, mode);
            } else {
                mode = "reduce compatability";
                this.ensureNotSet("mapreduce.job.outputformat.class", mode);
                this.ensureNotSet("mapreduce.job.reduce.class", mode);
            }
        }
    }

    private synchronized void connect() throws IOException, InterruptedException, ClassNotFoundException {
        if (this.cluster == null) {
            this.cluster = (Cluster)this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Cluster>(){

                @Override
                public Cluster run() throws IOException, InterruptedException, ClassNotFoundException {
                    return new Cluster(Job.this.getConfiguration());
                }
            });
        }
    }

    boolean isConnected() {
        return this.cluster != null;
    }

    @InterfaceAudience.Private
    public JobSubmitter getJobSubmitter(FileSystem fs, ClientProtocol submitClient) throws IOException {
        return new JobSubmitter(fs, submitClient);
    }

    public void submit() throws IOException, InterruptedException, ClassNotFoundException {
        this.ensureState(JobState.DEFINE);
        this.setUseNewAPI();
        this.connect();
        final JobSubmitter submitter = this.getJobSubmitter(this.cluster.getFileSystem(), this.cluster.getClient());
        this.status = (JobStatus)this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<JobStatus>(){

            @Override
            public JobStatus run() throws IOException, InterruptedException, ClassNotFoundException {
                return submitter.submitJobInternal(Job.this, Job.this.cluster);
            }
        });
        this.state = JobState.RUNNING;
        LOG.info((Object)("The url to track the job: " + this.getTrackingURL()));
    }

    public boolean waitForCompletion(boolean verbose) throws IOException, InterruptedException, ClassNotFoundException {
        if (this.state == JobState.DEFINE) {
            this.submit();
        }
        if (verbose) {
            this.monitorAndPrintJob();
        } else {
            int completionPollIntervalMillis = Job.getCompletionPollInterval(this.cluster.getConf());
            while (!this.isComplete()) {
                try {
                    Thread.sleep(completionPollIntervalMillis);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return this.isSuccessful();
    }

    public boolean monitorAndPrintJob() throws IOException, InterruptedException {
        String lastReport = null;
        Configuration clientConf = this.getConfiguration();
        TaskStatusFilter filter = Job.getTaskOutputFilter(clientConf);
        JobID jobId = this.getJobID();
        LOG.info((Object)("Running job: " + jobId));
        int eventCounter = 0;
        boolean profiling = this.getProfileEnabled();
        Configuration.IntegerRanges mapRanges = this.getProfileTaskRange(true);
        Configuration.IntegerRanges reduceRanges = this.getProfileTaskRange(false);
        int progMonitorPollIntervalMillis = Job.getProgressPollInterval(clientConf);
        boolean reportedAfterCompletion = false;
        boolean reportedUberMode = false;
        while (!this.isComplete() || !reportedAfterCompletion) {
            String report;
            if (this.isComplete()) {
                reportedAfterCompletion = true;
            } else {
                Thread.sleep(progMonitorPollIntervalMillis);
            }
            if (this.status.getState() == JobStatus.State.PREP) continue;
            if (!reportedUberMode) {
                reportedUberMode = true;
                LOG.info((Object)("Job " + jobId + " running in uber mode : " + this.isUber()));
            }
            if (!(report = " map " + StringUtils.formatPercent((double)this.mapProgress(), (int)0) + " reduce " + StringUtils.formatPercent((double)this.reduceProgress(), (int)0)).equals(lastReport)) {
                LOG.info((Object)report);
                lastReport = report;
            }
            org.apache.hadoop.mapreduce.TaskCompletionEvent[] events = this.getTaskCompletionEvents(eventCounter, 10);
            eventCounter += events.length;
            this.printTaskEvents(events, filter, profiling, mapRanges, reduceRanges);
        }
        boolean success = this.isSuccessful();
        if (success) {
            LOG.info((Object)("Job " + jobId + " completed successfully"));
        } else {
            LOG.info((Object)("Job " + jobId + " failed with state " + (Object)((Object)this.status.getState()) + " due to: " + this.status.getFailureInfo()));
        }
        Counters counters = this.getCounters();
        if (counters != null) {
            LOG.info((Object)counters.toString());
        }
        return success;
    }

    private void printTaskEvents(org.apache.hadoop.mapreduce.TaskCompletionEvent[] events, TaskStatusFilter filter, boolean profiling, Configuration.IntegerRanges mapRanges, Configuration.IntegerRanges reduceRanges) throws IOException, InterruptedException {
        block7: for (org.apache.hadoop.mapreduce.TaskCompletionEvent event : events) {
            switch (filter) {
                case NONE: {
                    continue block7;
                }
                case SUCCEEDED: {
                    if (event.getStatus() != TaskCompletionEvent.Status.SUCCEEDED) continue block7;
                    LOG.info((Object)event.toString());
                    continue block7;
                }
                case FAILED: {
                    if (event.getStatus() != TaskCompletionEvent.Status.FAILED) continue block7;
                    LOG.info((Object)event.toString());
                    TaskAttemptID taskId = event.getTaskAttemptId();
                    String[] taskDiagnostics = this.getTaskDiagnostics(taskId);
                    if (taskDiagnostics == null) continue block7;
                    for (String diagnostics : taskDiagnostics) {
                        System.err.println(diagnostics);
                    }
                    continue block7;
                }
                case KILLED: {
                    if (event.getStatus() != TaskCompletionEvent.Status.KILLED) continue block7;
                    LOG.info((Object)event.toString());
                    continue block7;
                }
                case ALL: {
                    LOG.info((Object)event.toString());
                }
            }
        }
    }

    public static int getProgressPollInterval(Configuration conf) {
        int progMonitorPollIntervalMillis = conf.getInt(PROGRESS_MONITOR_POLL_INTERVAL_KEY, 1000);
        if (progMonitorPollIntervalMillis < 1) {
            LOG.warn((Object)"mapreduce.client.progressmonitor.pollinterval has been set to an invalid value;  replacing with 1000");
            progMonitorPollIntervalMillis = 1000;
        }
        return progMonitorPollIntervalMillis;
    }

    public static int getCompletionPollInterval(Configuration conf) {
        int completionPollIntervalMillis = conf.getInt(COMPLETION_POLL_INTERVAL_KEY, 5000);
        if (completionPollIntervalMillis < 1) {
            LOG.warn((Object)"mapreduce.client.completion.pollinterval has been set to an invalid value; replacing with 5000");
            completionPollIntervalMillis = 5000;
        }
        return completionPollIntervalMillis;
    }

    public static TaskStatusFilter getTaskOutputFilter(Configuration conf) {
        return TaskStatusFilter.valueOf(conf.get(OUTPUT_FILTER, "FAILED"));
    }

    public static void setTaskOutputFilter(Configuration conf, TaskStatusFilter newValue) {
        conf.set(OUTPUT_FILTER, newValue.toString());
    }

    public boolean isUber() throws IOException, InterruptedException {
        this.ensureState(JobState.RUNNING);
        this.updateStatus();
        return this.status.isUber();
    }

    public ReservationId getReservationId() {
        return this.reservationId;
    }

    public void setReservationId(ReservationId reservationId) {
        this.reservationId = reservationId;
    }

    static {
        ConfigUtil.loadResources();
    }

    @InterfaceStability.Evolving
    public static enum TaskStatusFilter {
        NONE,
        KILLED,
        FAILED,
        SUCCEEDED,
        ALL;

    }

    @InterfaceStability.Evolving
    public static enum JobState {
        DEFINE,
        RUNNING;

    }
}

