/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import javax.servlet.HttpConstraintElement;
import javax.servlet.HttpMethodConstraintElement;
import javax.servlet.annotation.HttpMethodConstraint;
import javax.servlet.annotation.ServletSecurity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletSecurityElement
extends HttpConstraintElement {
    private final Collection<HttpMethodConstraintElement> httpMethodConstraints;
    private final Collection<String> methodNames;

    public ServletSecurityElement() {
        this.httpMethodConstraints = Collections.emptySet();
        this.methodNames = Collections.emptySet();
    }

    public ServletSecurityElement(HttpConstraintElement defaultHttpConstraintElement) {
        super(defaultHttpConstraintElement.getEmptyRoleSemantic(), defaultHttpConstraintElement.getTransportGuarantee(), defaultHttpConstraintElement.getRolesAllowed());
        this.httpMethodConstraints = Collections.emptySet();
        this.methodNames = Collections.emptySet();
    }

    public ServletSecurityElement(Collection<HttpMethodConstraintElement> httpMethodConstraints) throws IllegalArgumentException {
        this.httpMethodConstraints = httpMethodConstraints;
        this.methodNames = ServletSecurityElement.toMethodNames(httpMethodConstraints);
    }

    public ServletSecurityElement(HttpConstraintElement httpConstraintElement, Collection<HttpMethodConstraintElement> httpMethodConstraints) throws IllegalArgumentException {
        super(httpConstraintElement.getEmptyRoleSemantic(), httpConstraintElement.getTransportGuarantee(), httpConstraintElement.getRolesAllowed());
        this.httpMethodConstraints = Collections.unmodifiableCollection(httpMethodConstraints);
        this.methodNames = ServletSecurityElement.toMethodNames(httpMethodConstraints);
    }

    public ServletSecurityElement(ServletSecurity servletSecurity) throws IllegalArgumentException {
        super(servletSecurity.value().value(), servletSecurity.value().transportGuarantee(), servletSecurity.value().rolesAllowed());
        ArrayList<HttpMethodConstraintElement> httpMethodConstraints = new ArrayList<HttpMethodConstraintElement>();
        for (HttpMethodConstraint constraint : servletSecurity.httpMethodConstraints()) {
            httpMethodConstraints.add(new HttpMethodConstraintElement(constraint.value(), new HttpConstraintElement(constraint.emptyRoleSemantic(), constraint.transportGuarantee(), constraint.rolesAllowed())));
        }
        this.httpMethodConstraints = Collections.unmodifiableCollection(httpMethodConstraints);
        this.methodNames = ServletSecurityElement.toMethodNames(httpMethodConstraints);
    }

    public Collection<HttpMethodConstraintElement> getHttpMethodConstraints() {
        return this.httpMethodConstraints;
    }

    public Collection<String> getMethodNames() {
        return this.methodNames;
    }

    private static Collection<String> toMethodNames(Collection<HttpMethodConstraintElement> constraints) throws IllegalArgumentException {
        LinkedHashSet<String> methodNames = new LinkedHashSet<String>(constraints.size());
        for (HttpMethodConstraintElement constraint : constraints) {
            if (methodNames.add(constraint.getMethodName())) continue;
            throw new IllegalArgumentException("duplicate method name: " + constraint.getMethodName());
        }
        return Collections.unmodifiableCollection(methodNames);
    }
}

