/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.conflictresolution;

import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.builder.SGStateInfo;
import org.exolab.castor.builder.binding.XPathHelper;
import org.exolab.castor.builder.conflictresolution.BaseClassNameCRStrategy;
import org.exolab.castor.builder.conflictresolution.ClassNameCRStrategy;
import org.exolab.castor.builder.info.ClassInfo;
import org.exolab.castor.builder.info.nature.XMLInfoNature;
import org.exolab.castor.util.dialog.ConsoleDialog;
import org.exolab.castor.xml.schema.Annotated;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.SchemaNames;
import org.exolab.castor.xml.schema.Structure;
import org.exolab.javasource.JClass;

public final class InformViaLogClassNameCRStrategy
extends BaseClassNameCRStrategy
implements ClassNameCRStrategy {
    private static final Log LOG = LogFactory.getLog(InformViaLogClassNameCRStrategy.class);
    public static final String NAME = "informViaLog";

    @Override
    public SGStateInfo dealWithClassNameConflict(SGStateInfo state, ClassInfo newClassInfo, JClass conflict) {
        XMLInfoNature xmlNature;
        ElementDecl element;
        ClassInfo oldClassInfo = state.resolve(conflict);
        if (oldClassInfo == newClassInfo) {
            return state;
        }
        Annotated a1 = null;
        Annotated a2 = null;
        Enumeration<?> enumeration = state.keys();
        while (enumeration.hasMoreElements() && (a1 == null || a2 == null)) {
            Object key = enumeration.nextElement();
            if (!(key instanceof Annotated)) continue;
            ClassInfo cInfo = state.resolve(key);
            if (newClassInfo == cInfo) {
                a1 = (Annotated)key;
                continue;
            }
            if (oldClassInfo != cInfo) continue;
            a2 = (Annotated)key;
        }
        StringBuilder message = new StringBuilder();
        message.append("Warning: A class name generation conflict has occured between ");
        if (a1 != null) {
            message.append(SchemaNames.getStructureName(a1));
            message.append(" '");
            if (a1 instanceof ElementDecl) {
                element = (ElementDecl)a1;
                String annotated1XPath = XPathHelper.getSchemaLocation((Structure)a1) + "[/complexType:" + element.getType().getName() + "]";
                message.append(annotated1XPath);
            } else {
                message.append(XPathHelper.getSchemaLocation((Structure)a1));
            }
        } else if (newClassInfo.hasNature(XMLInfoNature.class.getName())) {
            xmlNature = new XMLInfoNature(newClassInfo);
            message.append(xmlNature.getNodeTypeName());
            message.append(" '");
            message.append(xmlNature.getNodeName());
        }
        message.append("' and ");
        if (a2 != null) {
            message.append(SchemaNames.getStructureName((Structure)a2));
            message.append(" '");
            if (a2 instanceof ElementDecl) {
                element = (ElementDecl)a2;
                String annotated2XPath = XPathHelper.getSchemaLocation((Structure)a2) + "[/complexType:" + element.getType().getName() + "]";
                message.append(annotated2XPath);
            } else {
                message.append(XPathHelper.getSchemaLocation((Structure)a2));
            }
        } else if (oldClassInfo.hasNature(XMLInfoNature.class.getName())) {
            xmlNature = new XMLInfoNature(oldClassInfo);
            message.append(xmlNature.getNodeTypeName());
            message.append(" '");
            message.append(xmlNature.getNodeName());
        }
        message.append("'. Please use a Binding file to solve this problem.");
        LOG.warn((Object)message);
        return state;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void setConsoleDialog(ConsoleDialog dialog) {
    }

    @Override
    public boolean dealWithFileOverwrite(String filename) {
        LOG.warn((Object)(filename + " already exists, but will be overwritten."));
        return true;
    }
}

