/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.printing;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.builder.BuilderConfiguration;
import org.exolab.castor.builder.printing.JClassPrinterFactory;

public class JClassPrinterFactoryRegistry {
    private final Log _log = LogFactory.getLog(JClassPrinterFactoryRegistry.class);
    private Map<String, JClassPrinterFactory> _factories = new HashMap<String, JClassPrinterFactory>();

    public JClassPrinterFactoryRegistry(BuilderConfiguration config) {
        String[] factoryClassNames;
        String jClassPrinterFactories = config.getJClassPrinterFactories();
        for (String factoryClassName : factoryClassNames = StringUtils.split((String)jClassPrinterFactories, (char)',')) {
            JClassPrinterFactory factory;
            try {
                factory = (JClassPrinterFactory)Class.forName(factoryClassName).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException("Property entry '" + factoryClassName + "' does" + " not represent a valid class name.");
            }
            this._factories.put(factory.getName(), factory);
        }
    }

    public String[] getJClassPrinterFactoryNames() {
        String[] names = new String[this._factories.size()];
        return this._factories.keySet().toArray(names);
    }

    public JClassPrinterFactory getJClassPrinterFactory(String name) {
        JClassPrinterFactory factory = this._factories.get(name);
        if (factory == null) {
            String msg = "The JClassPrinterFactory '" + name + "' " + "does not exist in the Castor XML code generator properties file " + "and is therefore not supported.";
            this._log.error((Object)msg);
            throw new IllegalArgumentException(msg);
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Returning JClassPrinterFactory with name " + name));
        }
        return factory;
    }
}

