/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.types;

import org.exolab.castor.builder.types.AbstractRangeFacet;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.javasource.JSourceCode;

public abstract class AbstractDigitsFacet
extends AbstractRangeFacet {
    private final boolean _fractionDigitsZeroOnly;
    private int _totalDigits = -1;
    private int _fractionDigits = -1;

    protected AbstractDigitsFacet() {
        this(true);
    }

    protected AbstractDigitsFacet(boolean fractionDigitsZeroOnly) {
        this._fractionDigitsZeroOnly = fractionDigitsZeroOnly;
    }

    public final int getTotalDigits() {
        return this._totalDigits;
    }

    public final void setTotalDigits(int totalDigits) {
        if (totalDigits <= 0) {
            throw new IllegalArgumentException(this.getName() + ": the totalDigits facet must be positive: " + totalDigits);
        }
        this._totalDigits = totalDigits;
    }

    public final int getFractionDigits() {
        return this._fractionDigits;
    }

    public final void setFractionDigits(int fractionDigits) {
        if (fractionDigits < 0) {
            throw new IllegalArgumentException(this.getName() + ": the fractionDigits facet must be positive: " + fractionDigits);
        }
        if (this._fractionDigitsZeroOnly && fractionDigits > 0) {
            throw new IllegalArgumentException(this.getName() + ": only '0' allowed for fractionDigits facet: " + fractionDigits);
        }
        this._fractionDigits = fractionDigits;
    }

    @Override
    protected final void setFacet(Facet facet) {
        super.setFacet(facet);
        this.setDigitsFacet(facet);
    }

    protected final void setDigitsFacet(Facet facet) {
        String name = facet.getName();
        if ("totalDigits".equals(name)) {
            this.setTotalDigits(facet.toInt());
        } else if ("fractionDigits".equals(name)) {
            this.setFractionDigits(facet.toInt());
        }
    }

    protected final void codeDigitsFacet(JSourceCode jsc, String validatorName) {
        if (this.getTotalDigits() != -1) {
            jsc.add("{0}.setTotalDigits({1});", validatorName, Integer.toString(this.getTotalDigits()));
        }
        if (!this._fractionDigitsZeroOnly && this.getFractionDigits() != -1) {
            jsc.add("{0}.setFractionDigits({1});", validatorName, Integer.toString(this.getFractionDigits()));
        }
    }
}

