/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

import java.util.Vector;
import org.exolab.javasource.JAnnotatedElementHelper;
import org.exolab.javasource.JDocComment;
import org.exolab.javasource.JMember;
import org.exolab.javasource.JMethod;
import org.exolab.javasource.JModifiers;
import org.exolab.javasource.JNaming;
import org.exolab.javasource.JSourceWriter;

public final class JEnumConstant
extends JAnnotatedElementHelper
implements JMember {
    private String _name;
    private String[] _arguments;
    private JDocComment _comment = new JDocComment();
    private final Vector<JMethod> _methods = new Vector();

    public JEnumConstant(String name) {
        this(name, null);
    }

    public JEnumConstant(String name, String[] arguments) {
        this.setName(name);
        this._comment.appendComment("Constant " + name);
        this._arguments = arguments;
    }

    @Override
    public JModifiers getModifiers() {
        throw new RuntimeException("Not implemented.");
    }

    public void setArguments(String[] args) {
        this._arguments = args;
    }

    public String[] getArguments() {
        return this._arguments;
    }

    public int getArgumentCount() {
        return this._arguments.length;
    }

    public void addMethod(JMethod jMethod) {
        this.addMethod(jMethod, true);
    }

    public void addMethod(JMethod jMethod, boolean importReturnType) {
        if (jMethod == null) {
            throw new IllegalArgumentException("Class methods cannot be null");
        }
        boolean added = false;
        JModifiers modifiers = jMethod.getModifiers();
        if (modifiers.isAbstract()) {
            this.getModifiers().setAbstract(true);
        }
        for (int i = 0; i < this._methods.size(); ++i) {
            JMethod tmp = this._methods.elementAt(i);
            if (tmp.getModifiers().isPrivate() && !modifiers.isPrivate()) {
                this._methods.insertElementAt(jMethod, i);
                added = true;
                break;
            }
            if (jMethod.getName().compareTo(tmp.getName()) >= 0) continue;
            this._methods.insertElementAt(jMethod, i);
            added = true;
            break;
        }
        if (!added) {
            this._methods.add(jMethod);
        }
    }

    public void addMethods(JMethod[] jMethods) {
        for (JMethod jMethod : jMethods) {
            this.addMethod(jMethod);
        }
    }

    public JMethod[] getMethods() {
        return this._methods.toArray(new JMethod[this._methods.size()]);
    }

    public int getMethodCount() {
        return this._methods.size();
    }

    public JMethod getMethod(String name, int startIndex) {
        for (JMethod jMethod : this._methods) {
            if (!jMethod.getName().equals(name)) continue;
            return jMethod;
        }
        return null;
    }

    public JMethod getMethod(int index) {
        return this._methods.elementAt(index);
    }

    public void setName(String name) {
        if (!JNaming.isValidJavaIdentifier(name)) {
            String err = "'" + name + "' is ";
            err = JNaming.isKeyword(name) ? err + "a reserved word and may not be used as  a field name." : err + "not a valid Java identifier.";
            throw new IllegalArgumentException(err);
        }
        this._name = name;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void setComment(JDocComment comment) {
        this._comment = comment;
    }

    public void setComment(String comment) {
        if (this._comment == null) {
            this._comment = new JDocComment();
        }
        this._comment.setComment(comment);
    }

    public JDocComment getComment() {
        return this._comment;
    }

    public void print(JSourceWriter jsw) {
        if (this._comment != null) {
            this._comment.print(jsw);
        }
        if (this.printAnnotations(jsw)) {
            jsw.writeln();
        }
        jsw.write(this._name);
        if (this._arguments != null && this._arguments.length > 0) {
            jsw.write("(");
            for (int a = 0; a < this._arguments.length; ++a) {
                jsw.write(this._arguments[a]);
                if (a >= this._arguments.length - 1) continue;
                jsw.write(", ");
            }
            jsw.write(")");
        }
        if (!this._methods.isEmpty()) {
            jsw.write(" {");
            jsw.writeln();
            jsw.indent();
            for (int i = 0; i < this._methods.size(); ++i) {
                JMethod jMethod = this._methods.elementAt(i);
                jMethod.print(jsw);
                if (i >= this._methods.size() - 1) continue;
                jsw.writeln();
            }
            jsw.unindent();
            jsw.write("}");
        }
    }
}

