/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

public final class JModifiers {
    private static final String ABSTRACT = "abstract";
    private static final String FINAL = "final";
    private static final String PRIVATE = "private";
    private static final String PROTECTED = "protected";
    private static final String PACKAGE = "";
    private static final String PUBLIC = "public";
    private static final String STATIC = "static";
    private static final String TRANSIENT = "transient";
    private static final short VISIBILITY_PRIVATE = 1;
    private static final short VISIBILITY_PROTECTED = 2;
    private static final short VISIBILITY_PUBLIC = 3;
    private static final short VISIBILITY_PACKAGE = 4;
    private short _visibility = (short)3;
    private boolean _isStatic = false;
    private boolean _isFinal = false;
    private boolean _isAbstract = false;
    private boolean _isTransient = false;

    public JModifiers() {
    }

    private JModifiers(short visibility, boolean isStatic, boolean isFinal) {
        this._visibility = visibility;
        this._isStatic = isStatic;
        this._isFinal = isFinal;
    }

    public JModifiers copy() {
        JModifiers mods = new JModifiers(this._visibility, this._isStatic, this._isFinal);
        mods.setAbstract(this._isAbstract);
        mods.setTransient(this._isTransient);
        return mods;
    }

    public void makePrivate() {
        this._visibility = 1;
    }

    public void makeProtected() {
        this._visibility = (short)2;
    }

    public void makePublic() {
        this._visibility = (short)3;
    }

    public void makePackage() {
        this._visibility = (short)4;
    }

    public boolean isFinal() {
        return this._isFinal;
    }

    public boolean isAbstract() {
        return this._isAbstract;
    }

    public boolean isPrivate() {
        return this._visibility == 1;
    }

    public boolean isProtected() {
        return this._visibility == 2;
    }

    public boolean isPublic() {
        return this._visibility == 3;
    }

    public boolean isPackage() {
        return this._visibility == 4;
    }

    public boolean isStatic() {
        return this._isStatic;
    }

    public boolean isTransient() {
        return this._isTransient;
    }

    public void setAbstract(boolean isAbstract) {
        this._isAbstract = isAbstract;
    }

    public void setFinal(boolean isFinal) {
        this._isFinal = isFinal;
    }

    public void setStatic(boolean isStatic) {
        this._isStatic = isStatic;
    }

    public void setTransient(boolean isTransient) {
        this._isTransient = isTransient;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        switch (this._visibility) {
            case 1: {
                sb.append(PRIVATE);
                break;
            }
            case 2: {
                sb.append(PROTECTED);
                break;
            }
            case 4: {
                sb.append(PACKAGE);
                break;
            }
            default: {
                sb.append(PUBLIC);
            }
        }
        if (this._isStatic) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(STATIC);
        }
        if (this._isFinal) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(FINAL);
        }
        if (this._isAbstract) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(ABSTRACT);
        }
        if (this._isTransient) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(TRANSIENT);
        }
        return sb.toString();
    }
}

