/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core;

import java.util.ArrayList;
import java.util.Iterator;
import org.pentaho.reporting.designer.core.ReportDesignerBoot;
import org.pentaho.reporting.designer.core.ReportDesignerUiPlugin;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class ReportDesignerUiPluginRegistry {
    private static final String PREFIX = "org.pentaho.reporting.designer.modules.ui-extensions.";
    private static ReportDesignerUiPluginRegistry instance;
    private ArrayList<ReportDesignerUiPlugin> factories = new ArrayList();

    public static synchronized ReportDesignerUiPluginRegistry getInstance() {
        if (instance == null) {
            instance = new ReportDesignerUiPluginRegistry();
            instance.register();
        }
        return instance;
    }

    private void register() {
        Configuration configuration = ReportDesignerBoot.getInstance().getGlobalConfig();
        Iterator keys = configuration.findPropertyKeys(PREFIX);
        while (keys.hasNext()) {
            String className;
            ReportDesignerUiPlugin plugin;
            String key = (String)keys.next();
            if (!key.endsWith(".UiPlugin") || (plugin = (ReportDesignerUiPlugin)ObjectUtilities.loadAndInstantiate((String)(className = configuration.getConfigProperty(key)), ReportDesignerUiPluginRegistry.class, ReportDesignerUiPlugin.class)) == null) continue;
            this.factories.add(plugin);
        }
    }

    public void addPlugin(ReportDesignerUiPlugin plugin) {
        if (plugin == null) {
            throw new NullPointerException();
        }
        this.factories.add(plugin);
    }

    public ReportDesignerUiPlugin[] getPlugins() {
        return this.factories.toArray(new ReportDesignerUiPlugin[this.factories.size()]);
    }
}

