/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions;

import org.pentaho.reporting.designer.core.actions.AbstractReportContextAction;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.ReportRenderContext;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.designer.core.model.selection.ReportSelectionEvent;
import org.pentaho.reporting.designer.core.model.selection.ReportSelectionListener;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.event.ReportModelListener;

public abstract class AbstractElementSelectionAction
extends AbstractReportContextAction {
    private DocumentContextSelectionModel selectionModel;
    private SelectionUpdateHandler updateHandler = new SelectionUpdateHandler();
    private UpdatePropertiesForSelectionHandler updateSelectionHandler = new UpdatePropertiesForSelectionHandler();

    protected AbstractElementSelectionAction() {
    }

    protected DocumentContextSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    @Override
    protected void updateActiveContext(ReportRenderContext oldContext, ReportRenderContext newContext) {
        if (this.selectionModel != null) {
            this.selectionModel.removeReportSelectionListener(this.updateHandler);
        }
        if (oldContext != null) {
            oldContext.getReportDefinition().removeReportModelListener((ReportModelListener)this.updateSelectionHandler);
        }
        if (newContext != null) {
            this.selectionModel = newContext.getSelectionModel();
            this.selectionModel.addReportSelectionListener(this.updateHandler);
            this.updateSelection();
        } else {
            this.selectionModel = null;
            this.updateSelection();
        }
        if (newContext != null) {
            newContext.getReportDefinition().addReportModelListener((ReportModelListener)this.updateSelectionHandler);
        }
    }

    protected abstract void selectedElementPropertiesChanged(ReportModelEvent var1);

    protected void updateSelection() {
        if (this.selectionModel == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(this.selectionModel.getSelectionCount() > 0);
    }

    protected boolean isSingleElementSelection() {
        if (this.selectionModel == null) {
            return false;
        }
        return this.selectionModel.getSelectionCount() == 1;
    }

    protected class UpdatePropertiesForSelectionHandler
    implements ReportModelListener {
        private UpdatePropertiesForSelectionHandler() {
        }

        public void nodeChanged(ReportModelEvent event) {
            ReportDocumentContext activeContext = AbstractElementSelectionAction.this.getActiveContext();
            if (activeContext == null) {
                throw new IllegalStateException("Stale Action reference!");
            }
            if (activeContext.getSelectionModel().isSelected(event.getElement())) {
                AbstractElementSelectionAction.this.selectedElementPropertiesChanged(event);
            }
        }
    }

    private class SelectionUpdateHandler
    implements ReportSelectionListener {
        private SelectionUpdateHandler() {
        }

        @Override
        public void selectionAdded(ReportSelectionEvent event) {
            AbstractElementSelectionAction.this.updateSelection();
        }

        @Override
        public void selectionRemoved(ReportSelectionEvent event) {
            AbstractElementSelectionAction.this.updateSelection();
        }

        @Override
        public void leadSelectionChanged(ReportSelectionEvent event) {
            AbstractElementSelectionAction.this.updateSelection();
        }
    }
}

