/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.pentaho.reporting.designer.core.DesignerContextComponent;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.ReportRenderContext;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.designer.core.model.selection.ReportSelectionEvent;
import org.pentaho.reporting.designer.core.model.selection.ReportSelectionListener;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.event.ReportModelListener;

public abstract class ElementSelectionComponentSupport
implements DesignerContextComponent {
    private ReportDesignerContext reportDesignerContext;
    private DocumentContextSelectionModel selectionModel;
    private SelectionUpdateHandler updateHandler = new SelectionUpdateHandler();
    private ActiveContextChangeHandler changeHandler = new ActiveContextChangeHandler();
    private ReportModelChangeHandler modelChangeHandler = new ReportModelChangeHandler();

    protected void updateDesignerContext(ReportDesignerContext oldContext, ReportDesignerContext newContext) {
        if (oldContext != null) {
            oldContext.removePropertyChangeListener("activeContext", this.changeHandler);
            this.updateActiveContext(oldContext.getActiveContext(), null);
        }
        if (newContext != null) {
            newContext.addPropertyChangeListener("activeContext", this.changeHandler);
            this.updateActiveContext(null, newContext.getActiveContext());
        }
    }

    public DocumentContextSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    protected ReportDocumentContext getActiveContext() {
        return this.getReportDesignerContext().getActiveContext();
    }

    protected void updateActiveContext(ReportDocumentContext oldContext, ReportDocumentContext newContext) {
        if (oldContext != null) {
            oldContext.getReportDefinition().removeReportModelListener((ReportModelListener)this.modelChangeHandler);
        }
        if (this.selectionModel != null) {
            this.selectionModel.removeReportSelectionListener(this.updateHandler);
        }
        if (newContext != null) {
            this.selectionModel = newContext.getSelectionModel();
            this.selectionModel.addReportSelectionListener(this.updateHandler);
            this.updateSelection();
            newContext.getReportDefinition().addReportModelListener((ReportModelListener)this.modelChangeHandler);
        } else {
            this.selectionModel = null;
            this.updateSelection();
        }
    }

    protected abstract void updateSelection();

    protected abstract void nodeChanged(ReportModelEvent var1);

    protected boolean isSingleElementSelection() {
        if (this.selectionModel == null) {
            return false;
        }
        return this.selectionModel.getSelectionCount() == 1;
    }

    @Override
    public void setReportDesignerContext(ReportDesignerContext context) {
        ReportDesignerContext old = this.reportDesignerContext;
        this.reportDesignerContext = context;
        this.updateDesignerContext(old, this.reportDesignerContext);
    }

    @Override
    public ReportDesignerContext getReportDesignerContext() {
        return this.reportDesignerContext;
    }

    private class ReportModelChangeHandler
    implements ReportModelListener {
        private ReportModelChangeHandler() {
        }

        public void nodeChanged(ReportModelEvent event) {
            ElementSelectionComponentSupport.this.nodeChanged(event);
        }
    }

    private class SelectionUpdateHandler
    implements ReportSelectionListener {
        private SelectionUpdateHandler() {
        }

        @Override
        public void selectionAdded(ReportSelectionEvent event) {
            ElementSelectionComponentSupport.this.updateSelection();
        }

        @Override
        public void selectionRemoved(ReportSelectionEvent event) {
            ElementSelectionComponentSupport.this.updateSelection();
        }

        @Override
        public void leadSelectionChanged(ReportSelectionEvent event) {
        }
    }

    private class ActiveContextChangeHandler
    implements PropertyChangeListener {
        private ActiveContextChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ReportRenderContext oldContext = (ReportRenderContext)evt.getOldValue();
            ReportRenderContext activeContext = (ReportRenderContext)evt.getNewValue();
            ElementSelectionComponentSupport.this.updateActiveContext(oldContext, activeContext);
        }
    }
}

