/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.elements;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.pentaho.reporting.designer.core.actions.AbstractElementSelectionAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.designer.core.util.undo.CompoundUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.UndoEntry;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.RelationalGroup;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;

public abstract class AbstractLayerAction
extends AbstractElementSelectionAction {
    protected AbstractLayerAction() {
    }

    @Override
    protected void selectedElementPropertiesChanged(ReportModelEvent event) {
    }

    @Override
    protected void updateSelection() {
        this.setEnabled(this.isSingleElementSelection());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ArrayList<UndoEntry> undos;
        AbstractReportDefinition report;
        ReportDocumentContext activeContext = this.getActiveContext();
        if (activeContext == null) {
            return;
        }
        Object[] selectedElements = activeContext.getSelectionModel().getSelectedElements();
        if (!this.collectChange(selectedElements, report = activeContext.getReportDefinition(), undos = new ArrayList<UndoEntry>())) {
            for (int i = undos.size() - 1; i >= 0; --i) {
                UndoEntry undoEntry = undos.get(i);
                undoEntry.undo(activeContext);
            }
        } else {
            UndoEntry[] undoEntries = undos.toArray(new UndoEntry[undos.size()]);
            activeContext.getUndo().addChange(ActionMessages.getString("AbstractLayerAction.UndoName", new Object[0]), new CompoundUndoEntry(undoEntries));
        }
        activeContext.getSelectionModel().setSelectedElements(selectedElements);
    }

    protected abstract boolean collectChange(Object[] var1, AbstractReportDefinition var2, ArrayList<UndoEntry> var3);

    protected boolean move(Object element, AbstractReportDefinition report, ArrayList<UndoEntry> undos) {
        try {
            if (element instanceof Expression) {
                UndoEntry undoEntry = this.moveExpressions(report, element);
                if (undoEntry == null) {
                    return false;
                }
                undos.add(undoEntry);
            } else if (element instanceof ParameterDefinitionEntry) {
                UndoEntry undoEntry = this.moveParameters(report, element);
                if (undoEntry == null) {
                    return false;
                }
                undos.add(undoEntry);
            } else if (element instanceof DataFactory) {
                UndoEntry undoEntry = this.moveDataFactories(report, element);
                if (undoEntry == null) {
                    return false;
                }
                undos.add(undoEntry);
            } else if (element instanceof RelationalGroup) {
                UndoEntry undoEntry = this.moveGroup((RelationalGroup)element);
                if (undoEntry == null) {
                    return false;
                }
                undos.add(undoEntry);
            } else if (element instanceof Element) {
                UndoEntry undoEntry = this.moveVisualElement(report, (Element)element);
                if (undoEntry == null) {
                    return false;
                }
                undos.add(undoEntry);
            }
        }
        catch (Exception ex) {
            UncaughtExceptionsModel.getInstance().addException(ex);
            return false;
        }
        return true;
    }

    protected abstract UndoEntry moveExpressions(AbstractReportDefinition var1, Object var2);

    protected abstract UndoEntry moveVisualElement(AbstractReportDefinition var1, Element var2);

    protected abstract UndoEntry moveGroup(RelationalGroup var1) throws CloneNotSupportedException;

    protected abstract UndoEntry moveParameters(AbstractReportDefinition var1, Object var2);

    protected abstract UndoEntry moveDataFactories(AbstractReportDefinition var1, Object var2) throws ReportDataFactoryException;
}

