/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.elements;

import java.awt.event.ActionEvent;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.actions.AbstractElementSelectionAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.ReportRenderContext;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;

public class EditSubReportAction
extends AbstractElementSelectionAction {
    public EditSubReportAction() {
        this.putValue("Name", ActionMessages.getString("EditSubReportAction.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("EditSubReportAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("EditSubReportAction.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("EditSubReportAction.Accelerator"));
    }

    @Override
    protected void selectedElementPropertiesChanged(ReportModelEvent event) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ReportDesignerContext designerContext = this.getReportDesignerContext();
        if (designerContext == null) {
            return;
        }
        ReportDocumentContext activeReportContext = this.getActiveContext();
        if (activeReportContext == null) {
            return;
        }
        DocumentContextSelectionModel selectionModel1 = this.getSelectionModel();
        if (selectionModel1 == null) {
            return;
        }
        Object leadSelection = selectionModel1.getLeadSelection();
        if (!(leadSelection instanceof Element)) {
            return;
        }
        Element element = (Element)leadSelection;
        if (element instanceof SubReport) {
            int contextCount = designerContext.getReportRenderContextCount();
            for (int i = 0; i < contextCount; ++i) {
                ReportRenderContext rrc = designerContext.getReportRenderContext(i);
                if (rrc.getReportDefinition() != element) continue;
                designerContext.setActiveDocument(rrc);
                return;
            }
            SubReport report = (SubReport)element;
            try {
                designerContext.addSubReport(activeReportContext, report);
            }
            catch (ReportDataFactoryException e1) {
                UncaughtExceptionsModel.getInstance().addException(e1);
            }
        }
    }
}

