/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.elements;

import java.awt.event.ActionEvent;
import org.pentaho.reporting.designer.core.actions.AbstractElementSelectionAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.designer.core.settings.SettingsListener;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.designer.core.util.undo.UndoEntry;
import org.pentaho.reporting.engine.classic.core.CrosstabCell;
import org.pentaho.reporting.engine.classic.core.CrosstabCellBody;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.filter.types.CrosstabElementType;
import org.pentaho.reporting.engine.classic.core.metadata.MetaData;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public final class InsertCrosstabCellAction
extends AbstractElementSelectionAction
implements SettingsListener {
    private static final long serialVersionUID = 8941387470673515186L;

    public InsertCrosstabCellAction() {
        this.putValue("Name", ActionMessages.getString("InsertCrosstabCellAction.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("InsertCrosstabCellAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("InsertCrosstabCellAction.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("InsertCrosstabCellAction.Accelerator"));
        this.putValue("SmallIcon", IconLoader.getInstance().getGenericSquare());
        this.setVisible(WorkspaceSettings.getInstance().isVisible((MetaData)CrosstabElementType.INSTANCE.getMetaData()));
        WorkspaceSettings.getInstance().addSettingsListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ReportDocumentContext activeContext = this.getActiveContext();
        if (activeContext == null) {
            return;
        }
        try {
            Object selectedElement = null;
            if (this.getSelectionModel().getSelectionCount() > 0) {
                selectedElement = this.getSelectionModel().getSelectedElement(0);
            }
            if (selectedElement instanceof CrosstabCellBody) {
                CrosstabCellBody selectedGroup = (CrosstabCellBody)selectedElement;
                CrosstabCell crosstabCell = new CrosstabCell();
                selectedGroup.addElement(crosstabCell);
                activeContext.getUndo().addChange(ActionMessages.getString("InsertCrosstabCellAction.UndoName", new Object[0]), new InsertCellBodyUndoEntry(selectedGroup.getObjectID(), crosstabCell));
            }
        }
        catch (Exception ex) {
            UncaughtExceptionsModel.getInstance().addException(ex);
        }
    }

    @Override
    protected void selectedElementPropertiesChanged(ReportModelEvent event) {
    }

    @Override
    protected void updateSelection() {
        if (!this.isVisible()) {
            this.setEnabled(false);
            return;
        }
        if (this.getSelectionModel() != null && this.getSelectionModel().getSelectionCount() == 0) {
            this.setEnabled(false);
            return;
        }
        if (!this.isSingleElementSelection()) {
            this.setEnabled(false);
            return;
        }
        Object selectedElement = this.getSelectionModel().getSelectedElement(0);
        if (selectedElement instanceof CrosstabCellBody) {
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }

    @Override
    public void settingsChanged() {
        this.setVisible(WorkspaceSettings.getInstance().isVisible((MetaData)CrosstabElementType.INSTANCE.getMetaData()));
    }

    private static class InsertCellBodyUndoEntry
    implements UndoEntry {
        private static final long serialVersionUID = 6615171451777587555L;
        private InstanceID target;
        private CrosstabCell cell;

        private InsertCellBodyUndoEntry(InstanceID target, CrosstabCell cell) {
            this.target = target;
            this.cell = cell;
        }

        @Override
        public void undo(ReportDocumentContext renderContext) {
            CrosstabCellBody selectedGroup = (CrosstabCellBody)ModelUtility.findElementById(renderContext.getReportDefinition(), this.target);
            selectedGroup.removeElement((Element)this.cell);
        }

        @Override
        public void redo(ReportDocumentContext renderContext) {
            CrosstabCellBody selectedGroup = (CrosstabCellBody)ModelUtility.findElementById(renderContext.getReportDefinition(), this.target);
            selectedGroup.addElement(this.cell);
        }

        @Override
        public UndoEntry merge(UndoEntry newEntry) {
            return null;
        }
    }
}

