/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.elements;

import java.awt.event.ActionEvent;
import org.pentaho.reporting.designer.core.actions.AbstractElementSelectionAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.designer.core.settings.SettingsListener;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.designer.core.util.undo.UndoEntry;
import org.pentaho.reporting.engine.classic.core.CrosstabGroup;
import org.pentaho.reporting.engine.classic.core.CrosstabOtherGroup;
import org.pentaho.reporting.engine.classic.core.CrosstabOtherGroupBody;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupBody;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.filter.types.CrosstabElementType;
import org.pentaho.reporting.engine.classic.core.metadata.MetaData;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public final class InsertCrosstabOtherGroupAction
extends AbstractElementSelectionAction
implements SettingsListener {
    private static final long serialVersionUID = 8941387470673515186L;

    public InsertCrosstabOtherGroupAction() {
        this.putValue("Name", ActionMessages.getString("InsertCrosstabOtherGroupAction.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("InsertCrosstabOtherGroupAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("InsertCrosstabOtherGroupAction.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("InsertCrosstabOtherGroupAction.Accelerator"));
        this.putValue("SmallIcon", IconLoader.getInstance().getGenericSquare());
        this.setVisible(WorkspaceSettings.getInstance().isVisible((MetaData)CrosstabElementType.INSTANCE.getMetaData()));
        WorkspaceSettings.getInstance().addSettingsListener(this);
    }

    @Override
    protected void selectedElementPropertiesChanged(ReportModelEvent event) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ReportDocumentContext activeContext = this.getActiveContext();
        if (activeContext == null) {
            return;
        }
        CrosstabOtherGroup newGroup = new CrosstabOtherGroup();
        try {
            CrosstabOtherGroupBody newGroupBody;
            GroupBody oldGroupBody;
            CrosstabOtherGroup selectedGroup;
            Object selectedElement = null;
            if (this.getSelectionModel().getSelectionCount() > 0) {
                selectedElement = this.getSelectionModel().getSelectedElement(0);
            }
            if (selectedElement instanceof CrosstabOtherGroup) {
                selectedGroup = (CrosstabOtherGroup)selectedElement;
                oldGroupBody = selectedGroup.getBody();
                newGroupBody = new CrosstabOtherGroupBody(newGroup);
                selectedGroup.setBody((GroupBody)newGroupBody);
                newGroup.setBody(oldGroupBody);
                activeContext.getUndo().addChange(ActionMessages.getString("InsertCrosstabOtherGroupAction.UndoName", new Object[0]), new InsertGroupBodyOnGroupUndoEntry(selectedGroup.getObjectID(), oldGroupBody, (GroupBody)newGroupBody));
            }
            if (selectedElement instanceof CrosstabGroup) {
                selectedGroup = (CrosstabGroup)selectedElement;
                oldGroupBody = selectedGroup.getBody();
                newGroupBody = new CrosstabOtherGroupBody(newGroup);
                selectedGroup.setBody((GroupBody)newGroupBody);
                newGroup.setBody(oldGroupBody);
                activeContext.getUndo().addChange(ActionMessages.getString("InsertCrosstabOtherGroupAction.UndoName", new Object[0]), new InsertGroupBodyOnGroupUndoEntry(selectedGroup.getObjectID(), oldGroupBody, (GroupBody)newGroupBody));
            }
        }
        catch (Exception ex) {
            UncaughtExceptionsModel.getInstance().addException(ex);
        }
    }

    @Override
    protected void updateSelection() {
        if (!this.isVisible()) {
            this.setEnabled(false);
            return;
        }
        if (this.getSelectionModel() != null && this.getSelectionModel().getSelectionCount() == 0) {
            this.setEnabled(false);
            return;
        }
        if (!this.isSingleElementSelection()) {
            this.setEnabled(false);
            return;
        }
        Object selectedElement = this.getSelectionModel().getSelectedElement(0);
        if (selectedElement instanceof CrosstabOtherGroup) {
            this.setEnabled(true);
            return;
        }
        if (selectedElement instanceof CrosstabGroup) {
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }

    @Override
    public void settingsChanged() {
        this.setVisible(WorkspaceSettings.getInstance().isVisible((MetaData)CrosstabElementType.INSTANCE.getMetaData()));
    }

    private static class InsertGroupBodyOnGroupUndoEntry
    implements UndoEntry {
        private static final long serialVersionUID = 6615171451777587555L;
        private InstanceID target;
        private GroupBody newRootGroup;
        private GroupBody oldRootGroup;

        private InsertGroupBodyOnGroupUndoEntry(InstanceID target, GroupBody oldRootGroup, GroupBody newRootGroup) {
            this.target = target;
            this.oldRootGroup = oldRootGroup;
            this.newRootGroup = newRootGroup;
        }

        @Override
        public void undo(ReportDocumentContext renderContext) {
            Group selectedGroup = (Group)ModelUtility.findElementById(renderContext.getReportDefinition(), this.target);
            selectedGroup.setBody(this.oldRootGroup);
        }

        @Override
        public void redo(ReportDocumentContext renderContext) {
            Group selectedGroup = (Group)ModelUtility.findElementById(renderContext.getReportDefinition(), this.target);
            selectedGroup.setBody(this.newRootGroup);
        }

        @Override
        public UndoEntry merge(UndoEntry newEntry) {
            return null;
        }
    }
}

