/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.elements;

import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.util.Locale;
import javax.swing.ImageIcon;
import org.pentaho.reporting.designer.core.actions.AbstractElementSelectionAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.report.elements.CrosstabConfigureHandler;
import org.pentaho.reporting.designer.core.editor.report.elements.SubreportConfigureHandler;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.designer.core.settings.SettingsListener;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.designer.core.util.undo.ElementEditUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.UndoManager;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.CrosstabElement;
import org.pentaho.reporting.engine.classic.core.DetailsFooter;
import org.pentaho.reporting.engine.classic.core.DetailsHeader;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.PageFooter;
import org.pentaho.reporting.engine.classic.core.PageHeader;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.RootLevelBand;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.Watermark;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.metadata.MetaData;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.libraries.designtime.swing.FocusTracker;

public class InsertElementAction
extends AbstractElementSelectionAction
implements SettingsListener {
    private static final long serialVersionUID = 4113715870254584033L;
    protected static final Float DEFAULT_WIDTH = new Float(100.0f);
    protected static final Float DEFAULT_HEIGHT = new Float(20.0f);
    private ElementMetaData metaData;
    private FocusUpdateHandler focusTracker;

    public InsertElementAction(ElementMetaData metaData) {
        this.metaData = metaData;
        this.putValue("Name", ActionMessages.getString("InsertElementAction.Name", metaData.getDisplayName(Locale.getDefault())));
        Image image = metaData.getIcon(Locale.getDefault(), 2);
        if (image != null) {
            this.putValue("SmallIcon", new ImageIcon(image));
        }
        this.setEnabled(false);
        this.focusTracker = new FocusUpdateHandler();
        this.settingsChanged();
        WorkspaceSettings.getInstance().addSettingsListener(this);
    }

    @Override
    public void settingsChanged() {
        this.setVisible(WorkspaceSettings.getInstance().isVisible((MetaData)this.metaData));
    }

    @Override
    protected void selectedElementPropertiesChanged(ReportModelEvent event) {
    }

    @Override
    protected void updateSelection() {
        ReportDocumentContext activeContext = this.getActiveContext();
        if (activeContext == null) {
            this.setEnabled(false);
            return;
        }
        Object selectedElement = null;
        DocumentContextSelectionModel selectionModel1 = this.getSelectionModel();
        if (selectionModel1 == null) {
            this.setEnabled(false);
            return;
        }
        if (selectionModel1.getSelectionCount() > 0) {
            selectedElement = selectionModel1.getSelectedElement(0);
        }
        if (selectedElement instanceof Band) {
            if ("sub-report".equals(this.metaData.getName())) {
                Element rootBand = this.findRootBand((Element)selectedElement);
                if (rootBand == null || rootBand instanceof PageHeader || rootBand instanceof PageFooter || rootBand instanceof DetailsHeader || rootBand instanceof DetailsFooter || rootBand instanceof Watermark) {
                    this.setEnabled(false);
                } else {
                    this.setEnabled(true);
                }
                return;
            }
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object selectedElement = null;
        DocumentContextSelectionModel selectionModel1 = this.getSelectionModel();
        if (selectionModel1 == null) {
            return;
        }
        if (selectionModel1.getSelectionCount() > 0) {
            selectedElement = selectionModel1.getSelectedElement(0);
        }
        if (!(selectedElement instanceof Band)) {
            return;
        }
        Band band = (Band)selectedElement;
        try {
            ElementType type = this.metaData.create();
            Element visualElement = (Element)type.create();
            if (this.isSubReportProhibited(band, visualElement)) {
                return;
            }
            ElementStyleSheet styleSheet = visualElement.getStyle();
            styleSheet.setStyleProperty(ElementStyleKeys.MIN_WIDTH, (Object)DEFAULT_WIDTH);
            styleSheet.setStyleProperty(ElementStyleKeys.MIN_HEIGHT, (Object)DEFAULT_HEIGHT);
            type.configureDesignTimeDefaults((ReportElement)visualElement, Locale.getDefault());
            if (visualElement instanceof CrosstabElement) {
                CrosstabElement sr = (CrosstabElement)visualElement;
                CrosstabConfigureHandler.configureDefaults(sr);
                CrosstabConfigureHandler handler = new CrosstabConfigureHandler(sr, band, this.getReportDesignerContext(), this.getActiveContext());
                handler.run();
            } else if (visualElement instanceof SubReport) {
                SubReport sr = (SubReport)visualElement;
                SubreportConfigureHandler.configureDefaults(sr);
                SubreportConfigureHandler handler = new SubreportConfigureHandler(sr, band, this.getReportDesignerContext(), this.getActiveContext());
                handler.run();
            } else {
                ReportDocumentContext context = this.getActiveContext();
                UndoManager undo = context.getUndo();
                undo.addChange(ActionMessages.getString("InsertElementAction.UndoName", new Object[0]), new ElementEditUndoEntry(band.getObjectID(), band.getElementCount(), null, visualElement));
                band.addElement(visualElement);
            }
        }
        catch (Exception ex) {
            UncaughtExceptionsModel.getInstance().addException(ex);
        }
    }

    protected boolean isSubReportProhibited(Band band, Element visualElement) {
        Element rootBand;
        return visualElement instanceof SubReport && ((rootBand = this.findRootBand((Element)band)) == null || rootBand instanceof PageHeader || rootBand instanceof PageFooter || rootBand instanceof DetailsHeader || rootBand instanceof DetailsFooter || rootBand instanceof Watermark);
    }

    private Element findRootBand(Element element) {
        while (element != null && !(element instanceof RootLevelBand)) {
            element = element.getParent();
        }
        if (element != null) {
            return element;
        }
        return null;
    }

    private class FocusUpdateHandler
    extends FocusTracker {
        private FocusUpdateHandler() {
        }

        protected void focusChanged(Component c) {
            InsertElementAction.this.updateSelection();
        }
    }
}

