/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.elements.align;

import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.List;
import org.pentaho.reporting.designer.core.actions.AbstractElementSelectionAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.editor.report.drag.MoveDragOperation;
import org.pentaho.reporting.designer.core.editor.report.snapping.EmptySnapModel;
import org.pentaho.reporting.designer.core.model.CachedLayoutData;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.designer.core.util.undo.MassElementStyleUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.MassElementStyleUndoEntryBuilder;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;

public final class AlignCenterAction
extends AbstractElementSelectionAction {
    private static final Point2D.Double ORIGIN_POINT = new Point2D.Double();

    public AlignCenterAction() {
        this.putValue("Name", ActionMessages.getString("AlignCenterAction.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("AlignCenterAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("AlignCenterAction.Mnemonic"));
        this.putValue("SmallIcon", IconLoader.getInstance().getAlignCenterIcon());
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("AlignCenterAction.Accelerator"));
    }

    @Override
    protected void selectedElementPropertiesChanged(ReportModelEvent event) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DocumentContextSelectionModel model = this.getSelectionModel();
        if (model == null) {
            return;
        }
        List<Element> visualElements = model.getSelectedElementsOfType(Element.class);
        if (visualElements.size() <= 1) {
            return;
        }
        Element[] carrier = new Element[1];
        List<Element> objects = ModelUtility.filterParents(visualElements);
        MassElementStyleUndoEntryBuilder builder = new MassElementStyleUndoEntryBuilder(objects);
        long minX = Long.MAX_VALUE;
        long maxX = Long.MIN_VALUE;
        for (Element object : objects) {
            CachedLayoutData data = ModelUtility.getCachedLayoutData(object);
            long x1 = data.getX();
            long x2 = x1 + data.getWidth();
            if (x2 > maxX) {
                maxX = x2;
            }
            if (x1 >= minX) continue;
            minX = x1;
        }
        long centerPoint = minX + (maxX - minX) / 2L;
        for (Element object : objects) {
            CachedLayoutData data = ModelUtility.getCachedLayoutData(object);
            long elementCenter = data.getX() + data.getWidth() / 2L;
            long delta = centerPoint - elementCenter;
            if (delta == 0L) continue;
            carrier[0] = object;
            MoveDragOperation mop = new MoveDragOperation(Arrays.asList(carrier), ORIGIN_POINT, EmptySnapModel.INSTANCE, EmptySnapModel.INSTANCE);
            mop.update(new Point2D.Double(StrictGeomUtility.toExternalValue((long)delta), 0.0), 1.0);
            mop.finish();
        }
        MassElementStyleUndoEntry massElementStyleUndoEntry = builder.finish();
        this.getActiveContext().getUndo().addChange(ActionMessages.getString("AlignCenterAction.UndoName", new Object[0]), massElementStyleUndoEntry);
    }
}

