/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.elements.format;

import java.awt.Dimension;
import java.util.List;
import javax.swing.JComboBox;
import org.pentaho.reporting.designer.core.DesignerContextComponent;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.actions.ElementSelectionComponentSupport;
import org.pentaho.reporting.designer.core.actions.elements.format.ApplyFontFamilyAction;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.designtime.swing.FontFamilyComboBox;

public final class FontFamilySelectorComponent
extends FontFamilyComboBox
implements DesignerContextComponent {
    private ApplyFontFamilyAction applyFontAction = new ApplyFontFamilyAction((JComboBox)((Object)this));
    private SelectionUpdateHelper updateHelper = new SelectionUpdateHelper();

    public FontFamilySelectorComponent() {
        this.setFocusable(false);
        this.setMaximumSize(new Dimension(250, this.getPreferredSize().height));
        this.setAction(this.applyFontAction);
    }

    @Override
    public void setReportDesignerContext(ReportDesignerContext context) {
        this.applyFontAction.setReportDesignerContext(context);
        this.updateHelper.setReportDesignerContext(context);
    }

    @Override
    public ReportDesignerContext getReportDesignerContext() {
        return this.applyFontAction.getReportDesignerContext();
    }

    private class SelectionUpdateHelper
    extends ElementSelectionComponentSupport {
        private Element lastSelection;

        private SelectionUpdateHelper() {
        }

        @Override
        protected void updateSelection() {
            if (this.getSelectionModel() == null) {
                FontFamilySelectorComponent.this.setEnabled(false);
                FontFamilySelectorComponent.this.setValueFromModel(null);
                this.lastSelection = null;
            } else {
                List<Element> visualElements = this.getSelectionModel().getSelectedElementsOfType(Element.class);
                if (visualElements.isEmpty()) {
                    FontFamilySelectorComponent.this.setValueFromModel(null);
                    FontFamilySelectorComponent.this.setEnabled(false);
                    this.lastSelection = null;
                } else {
                    this.lastSelection = visualElements.get(0);
                    Object color = this.lastSelection.getStyle().getStyleProperty(TextStyleKeys.FONT);
                    for (int i = 1; i < visualElements.size(); ++i) {
                        Element element = visualElements.get(i);
                        Object otherColor = element.getStyle().getStyleProperty(TextStyleKeys.FONT);
                        if (ObjectUtilities.equal((Object)color, (Object)otherColor)) continue;
                        FontFamilySelectorComponent.this.setEnabled(true);
                        FontFamilySelectorComponent.this.setValueFromModel(null);
                        return;
                    }
                    FontFamilySelectorComponent.this.setEnabled(true);
                    FontFamilySelectorComponent.this.setValueFromModel(color);
                }
            }
        }

        @Override
        protected void nodeChanged(ReportModelEvent event) {
            if (event.getElement() == this.lastSelection) {
                Object color = this.lastSelection.getStyle().getStyleProperty(TextStyleKeys.FONT);
                FontFamilySelectorComponent.this.setValueFromModel(color);
            }
        }
    }
}

