/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.elements.format;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.reporting.designer.core.actions.AbstractElementSelectionAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.actions.ToggleStateAction;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.designer.core.util.undo.AttributeEditUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.CompoundUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.UndoEntry;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.designtime.ReportModelEventFilter;
import org.pentaho.reporting.engine.classic.core.designtime.ReportModelEventFilterFactory;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;

public final class HideElementAction
extends AbstractElementSelectionAction
implements ToggleStateAction {
    private final ReportModelEventFilter eventFilter;

    public HideElementAction() {
        this.putValue("SwingSelectedKey", Boolean.FALSE);
        this.putValue("Name", ActionMessages.getString("HideElementAction.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("HideElementAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("HideElementAction.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("HideElementAction.Accelerator"));
        this.eventFilter = new ReportModelEventFilterFactory().createAttributeFilter("http://reporting.pentaho.org/namespaces/report-designer/2.0", "hideInLayoutGUI");
    }

    @Override
    public boolean isSelected() {
        return Boolean.TRUE.equals(this.getValue("SwingSelectedKey"));
    }

    public void setSelected(boolean selected) {
        this.putValue("SwingSelectedKey", selected);
    }

    @Override
    protected void selectedElementPropertiesChanged(ReportModelEvent event) {
        if (this.eventFilter.isFilteredEvent(event)) {
            this.updateSelection();
        }
    }

    @Override
    protected void updateSelection() {
        boolean selected;
        super.updateSelection();
        DocumentContextSelectionModel model = this.getSelectionModel();
        if (model == null) {
            return;
        }
        List<Element> visualElements = model.getSelectedElementsOfType(Element.class);
        if (visualElements.size() == 0) {
            selected = false;
        } else {
            selected = true;
            for (Element visualElement : visualElements) {
                selected &= ModelUtility.isHideInLayoutGui((ReportElement)visualElement);
            }
        }
        this.setSelected(selected);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DocumentContextSelectionModel model = this.getSelectionModel();
        if (model == null) {
            return;
        }
        List<Element> visualElements = model.getSelectedElementsOfType(Element.class);
        Boolean value = null;
        ArrayList<AttributeEditUndoEntry> undos = new ArrayList<AttributeEditUndoEntry>();
        for (Element element : visualElements) {
            if (value == null) {
                value = ModelUtility.isHideInLayoutGui((ReportElement)element) ? Boolean.FALSE : Boolean.TRUE;
            }
            Object oldValue = element.getAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "hideInLayoutGUI");
            AttributeEditUndoEntry entry = new AttributeEditUndoEntry(element.getObjectID(), "http://reporting.pentaho.org/namespaces/report-designer/2.0", "hideInLayoutGUI", oldValue, value);
            undos.add(entry);
            element.setAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "hideInLayoutGUI", (Object)value);
        }
        this.getActiveContext().getUndo().addChange(ActionMessages.getString("HideElementAction.UndoName", new Object[0]), new CompoundUndoEntry(undos.toArray(new UndoEntry[undos.size()])));
    }
}

