/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.global;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.pentaho.reporting.designer.core.actions.AbstractElementSelectionAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.designer.core.util.dnd.ClipboardManager;
import org.pentaho.reporting.designer.core.util.dnd.InsertationUtil;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;

public class CopyAction
extends AbstractElementSelectionAction {
    public CopyAction() {
        this.putValue("Name", ActionMessages.getString("CopyAction.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("CopyAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("CopyAction.Mnemonic"));
        this.putValue("SmallIcon", IconLoader.getInstance().getCopyIcon());
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("CopyAction.Accelerator"));
    }

    @Override
    protected void selectedElementPropertiesChanged(ReportModelEvent event) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DocumentContextSelectionModel selectionModel1 = this.getSelectionModel();
        if (selectionModel1 == null) {
            return;
        }
        ReportDocumentContext activeContext = this.getActiveContext();
        Object[] selectedElements = selectionModel1.getSelectedElements();
        if (selectedElements.length == 0) {
            return;
        }
        ArrayList<Object> preparedElements = new ArrayList<Object>(selectedElements.length);
        for (int i = 0; i < selectedElements.length; ++i) {
            Object selectedElement = selectedElements[i];
            Object preparedElement = InsertationUtil.prepareForCopy(activeContext, selectedElement);
            if (preparedElement == null) continue;
            preparedElements.add(preparedElement);
        }
        ClipboardManager.getManager().setContents(preparedElements.toArray());
    }
}

