/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.global;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.actions.AbstractElementSelectionAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.designer.core.util.dnd.ClipboardManager;
import org.pentaho.reporting.designer.core.util.dnd.InsertationUtil;
import org.pentaho.reporting.designer.core.util.undo.BandedSubreportEditUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.CompoundUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.DataSourceEditUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.ElementEditUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.ExpressionAddedUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.ParameterEditUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.UndoEntry;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.CompoundDataFactory;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.PageFooter;
import org.pentaho.reporting.engine.classic.core.PageHeader;
import org.pentaho.reporting.engine.classic.core.ReportFooter;
import org.pentaho.reporting.engine.classic.core.ReportHeader;
import org.pentaho.reporting.engine.classic.core.RootLevelBand;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.Watermark;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.filter.types.bands.SubReportType;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterDefinition;
import org.pentaho.reporting.libraries.designtime.swing.FocusTracker;

public class PasteAction
extends AbstractElementSelectionAction
implements ChangeListener {
    private ClipboardStatus clipboardStatus;
    private Object[] clipboardContents;
    private boolean selectionActive;
    private FocusTracker focusTracker;

    public PasteAction() {
        this.putValue("Name", ActionMessages.getString("PasteAction.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("PasteAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("PasteAction.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("PasteAction.Accelerator"));
        this.putValue("SmallIcon", IconLoader.getInstance().getPasteIcon());
        this.setEnabled(false);
        ClipboardManager.getManager().addChangeListener(this);
        this.stateChanged(null);
        this.focusTracker = new FocusUpdateHandler();
    }

    @Override
    protected void selectedElementPropertiesChanged(ReportModelEvent event) {
    }

    @Override
    protected void updateSelection() {
        ReportDocumentContext activeContext = this.getActiveContext();
        if (activeContext == null) {
            this.setSelectionActive(false);
            return;
        }
        Object rawLeadSelection = InsertationUtil.getInsertationPoint(activeContext);
        if (rawLeadSelection == null) {
            this.setSelectionActive(false);
            return;
        }
        this.setSelectionActive(true);
    }

    public void setSelectionActive(boolean selectionActive) {
        this.selectionActive = selectionActive;
        if (selectionActive) {
            this.setEnabled(this.isGenericElementInsertable());
        } else {
            this.setEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        ReportDocumentContext activeContext = this.getActiveContext();
        if (activeContext == null) {
            return;
        }
        Object rawLeadSelection = InsertationUtil.getInsertationPoint(activeContext);
        if (rawLeadSelection == null) {
            return;
        }
        Object[] fromClipboardArray = InsertationUtil.getFromClipboard();
        if (fromClipboardArray.length == 0) {
            return;
        }
        for (int i = 0; i < fromClipboardArray.length; ++i) {
            fromClipboardArray[i] = this.normalizeElements(fromClipboardArray[i]);
        }
        ArrayList<Object> selectedElements = new ArrayList<Object>();
        AbstractReportDefinition report = activeContext.getReportDefinition();
        ArrayList<UndoEntry> undos = new ArrayList<UndoEntry>();
        try {
            for (int i = 0; i < fromClipboardArray.length; ++i) {
                int index;
                Object o = fromClipboardArray[i];
                Object insertResult = InsertationUtil.insert(rawLeadSelection, report, o);
                if (insertResult != null) {
                    selectedElements.add(insertResult);
                }
                if (insertResult instanceof Element) {
                    undos.add(this.handleInsertElement((Element)insertResult));
                    continue;
                }
                if (insertResult instanceof Expression) {
                    Expression insertExpression = (Expression)insertResult;
                    int index2 = activeContext.getReportDefinition().getExpressions().indexOf(insertExpression);
                    undos.add(new ExpressionAddedUndoEntry(index2, insertExpression));
                    continue;
                }
                if (insertResult instanceof ParameterDefinitionEntry) {
                    ParameterDefinitionEntry insertParam = (ParameterDefinitionEntry)insertResult;
                    ReportParameterDefinition definition = ((MasterReport)activeContext.getContextRoot()).getParameterDefinition();
                    index = definition.getParameterCount() - 1;
                    undos.add(new ParameterEditUndoEntry(index, null, insertParam));
                    continue;
                }
                if (!(insertResult instanceof DataFactory)) continue;
                DataFactory insertDataFactory = (DataFactory)insertResult;
                CompoundDataFactory compoundDataFactory = (CompoundDataFactory)activeContext.getReportDefinition().getDataFactory();
                index = compoundDataFactory.size() - 1;
                undos.add(new DataSourceEditUndoEntry(index, null, insertDataFactory));
            }
            this.getSelectionModel().setSelectedElements(selectedElements.toArray());
        }
        finally {
            this.getActiveContext().getUndo().addChange(ActionMessages.getString("PasteAction.Text", new Object[0]), new CompoundUndoEntry(undos.toArray(new UndoEntry[undos.size()])));
        }
    }

    private UndoEntry handleInsertElement(Element insertElement) {
        Section parent = insertElement.getParentSection();
        if (parent == null) {
            throw new IllegalStateException("Assert Failed: A newly inserted section must have a parent.");
        }
        int position = ModelUtility.findIndexOf(parent, insertElement);
        if (position == -1) {
            if (insertElement instanceof SubReport && parent instanceof RootLevelBand) {
                RootLevelBand arb = (RootLevelBand)parent;
                SubReport subReport = (SubReport)insertElement;
                int subreportPosition = ModelUtility.findSubreportIndexOf(arb, subReport);
                if (subreportPosition == -1) {
                    throw new IllegalStateException("Assert Failed: A newly inserted section must have a position within its parent.");
                }
                return new BandedSubreportEditUndoEntry(parent.getObjectID(), arb.getSubReportCount(), null, subReport);
            }
            throw new IllegalStateException("A newly inserted section must have a position within its parent.");
        }
        return new ElementEditUndoEntry(parent.getObjectID(), position, null, insertElement);
    }

    public Object normalizeElements(Object element) {
        if (element instanceof MasterReport) {
            MasterReport rawMasterReport = (MasterReport)element;
            MasterReport masterReport = (MasterReport)rawMasterReport.derive();
            int result = JOptionPane.showOptionDialog(this.getReportDesignerContext().getView().getParent(), Messages.getString("SubreportReportElementDragHandler.BandedOrInlineSubreportQuestion", new Object[0]), Messages.getString("SubreportReportElementDragHandler.InsertSubreport", new Object[0]), 1, -1, null, new String[]{Messages.getString("SubreportReportElementDragHandler.Inline", new Object[0]), Messages.getString("SubreportReportElementDragHandler.Banded", new Object[0]), Messages.getString("SubreportReportElementDragHandler.Cancel", new Object[0])}, Messages.getString("SubreportReportElementDragHandler.Inline", new Object[0]));
            if (result == -1 || result == 2) {
                return null;
            }
            SubReport subReport = new SubReport();
            subReport.setRootGroup((Group)masterReport.getRootGroup().derive());
            subReport.setReportFooter((ReportFooter)masterReport.getReportFooter().derive());
            subReport.setReportHeader((ReportHeader)masterReport.getReportHeader().derive());
            subReport.setPageFooter((PageFooter)masterReport.getPageFooter().derive());
            subReport.setPageHeader((PageHeader)masterReport.getPageHeader().derive());
            subReport.setWatermark((Watermark)masterReport.getWatermark().derive());
            subReport.setDataFactory(masterReport.getDataFactory().derive());
            masterReport.copyInto((Element)subReport);
            ReportParameterDefinition parameterDefinition = masterReport.getParameterDefinition();
            for (ParameterDefinitionEntry entry : parameterDefinition.getParameterDefinitions()) {
                subReport.addInputParameter(entry.getName(), entry.getName());
            }
            if (subReport.getInputMappings().length == 0) {
                subReport.addInputParameter("*", "*");
            }
            subReport.setElementType((ElementType)SubReportType.INSTANCE);
            if (result == 0) {
                subReport.setAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "subreport-banded-hint", (Object)Boolean.FALSE);
            } else if (result == 1) {
                subReport.setAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "subreport-banded-hint", (Object)Boolean.TRUE);
            }
            return subReport;
        }
        return element;
    }

    public ClipboardStatus getClipboardStatus() {
        return this.clipboardStatus;
    }

    public void setClipboardStatus(ClipboardStatus clipboardStatus) {
        this.clipboardStatus = clipboardStatus;
        if (clipboardStatus == ClipboardStatus.UNKNOWN) {
            this.setEnabled(false);
        } else {
            this.setEnabled(this.isGenericElementInsertable());
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.clipboardContents = null;
        if (ClipboardManager.getManager().isDataAvailable()) {
            this.setClipboardStatus(ClipboardStatus.GENERIC_ELEMENT);
        } else {
            this.setClipboardStatus(ClipboardStatus.EMPTY);
        }
    }

    private boolean isGenericElementInsertable() {
        ReportDocumentContext activeContext = this.getActiveContext();
        if (activeContext == null) {
            return false;
        }
        if (!this.selectionActive) {
            return false;
        }
        if (this.clipboardStatus == ClipboardStatus.GENERIC_ELEMENT) {
            Object[] dataArray;
            if (this.clipboardContents == null) {
                dataArray = InsertationUtil.getFromClipboard();
                this.clipboardContents = dataArray;
            } else {
                dataArray = this.clipboardContents;
            }
            Object rawLeadSelection = InsertationUtil.getInsertationPoint(activeContext);
            for (int i = 0; i < dataArray.length; ++i) {
                Object o = dataArray[i];
                if (!InsertationUtil.isInsertAllowed(rawLeadSelection, o)) continue;
                return true;
            }
        }
        return false;
    }

    private static enum ClipboardStatus {
        EMPTY,
        UNKNOWN,
        GENERIC_ELEMENT;

    }

    private class FocusUpdateHandler
    extends FocusTracker {
        private FocusUpdateHandler() {
        }

        protected void focusChanged(Component c) {
            PasteAction.this.updateSelection();
        }
    }
}

