/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.global;

import java.awt.event.ActionEvent;
import org.pentaho.reporting.designer.core.actions.AbstractReportContextAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.ZoomModel;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.internal.PreviewPaneUtilities;

public class ZoomInAction
extends AbstractReportContextAction {
    private static double[] ZOOM_FACTORS = new double[]{0.5, 0.75, 1.0, 1.25, 1.5, 2.0, 4.0};

    public ZoomInAction() {
        this.putValue("Name", ActionMessages.getString("ZoomInAction.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("ZoomInAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("ZoomInAction.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("ZoomInAction.Accelerator"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ReportDocumentContext activeContext = this.getActiveContext();
        if (activeContext == null) {
            return;
        }
        ZoomModel zoomModel = activeContext.getZoomModel();
        double nextZoomIn = PreviewPaneUtilities.getNextZoomIn((double)zoomModel.getZoomAsPercentage(), (double[])ZOOM_FACTORS);
        if (nextZoomIn == 0.0) {
            return;
        }
        zoomModel.setZoomAsPercentage((float)nextZoomIn);
    }
}

