/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.report;

import java.awt.Component;
import java.awt.event.ActionEvent;
import org.pentaho.reporting.designer.core.actions.AbstractElementSelectionAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.actions.report.ConvertDataSourceAction;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.structuretree.ReportQueryNode;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.designer.core.util.Anonymizer;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.metadata.DataFactoryMetaData;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.libraries.designtime.swing.background.BackgroundCancellableProcessHelper;

public class AnonymizeDataAction
extends AbstractElementSelectionAction {
    public AnonymizeDataAction() {
        this.putValue("SmallIcon", IconLoader.getInstance().getLayoutBandsIcon());
        this.putValue("Name", ActionMessages.getString("AnonymizeDataAction.Text", new Object[0]));
        this.putValue("Default", ActionMessages.getString("AnonymizeDataAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("AnonymizeDataAction.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("AnonymizeDataAction.Accelerator"));
    }

    @Override
    protected void selectedElementPropertiesChanged(ReportModelEvent event) {
    }

    @Override
    protected void updateSelection() {
        DocumentContextSelectionModel model = this.getSelectionModel();
        if (model == null) {
            this.setEnabled(false);
            return;
        }
        Object[] selectedObjects = model.getSelectedElements();
        for (int i = 0; i < selectedObjects.length; ++i) {
            ReportQueryNode queryNode;
            DataFactory dataFactory;
            DataFactoryMetaData metadata;
            Object selectedObject = selectedObjects[i];
            if (!(selectedObject instanceof ReportQueryNode) || !(metadata = (dataFactory = (queryNode = (ReportQueryNode)selectedObject).getDataFactory()).getMetaData()).isEditable()) continue;
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ReportDocumentContext activeContext = this.getActiveContext();
        if (activeContext == null) {
            return;
        }
        Thread thread = new Thread(new AnonymizeDataSourceTask(this.getActiveContext()));
        thread.setName("AnonymizeDataSource-Worker");
        thread.setDaemon(true);
        BackgroundCancellableProcessHelper.executeProcessWithCancelDialog((Thread)thread, null, (Component)this.getReportDesignerContext().getView().getParent(), (String)ActionMessages.getString("AnonymizeDataAction.TaskTitle", new Object[0]));
    }

    private static class AnonymizeDataSourceTask
    extends ConvertDataSourceAction.ConvertDataSourceTask {
        private Anonymizer anonymizer = new Anonymizer();

        private AnonymizeDataSourceTask(ReportDocumentContext activeContext) {
            super(activeContext);
        }

        @Override
        protected Object process(Object o) throws BeanException {
            return this.anonymizer.anonymize(o);
        }
    }
}

