/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.report;

import java.awt.event.ActionEvent;
import java.util.LinkedHashMap;
import javax.swing.JOptionPane;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.actions.AbstractReportContextAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.actions.report.SaveReportAction;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.ReportRenderContext;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public class CloseReportAction
extends AbstractReportContextAction {
    private int tabIndex;

    public CloseReportAction() {
        this.putValue("Name", ActionMessages.getString("CloseReportAction.Text", new Object[0]));
        this.putValue("Default", ActionMessages.getString("CloseReportAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("CloseReportAction.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("CloseReportAction.Accelerator"));
        this.tabIndex = -1;
    }

    public CloseReportAction(int tabIndex) {
        this();
        this.tabIndex = tabIndex;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ReportDesignerContext reportDesignerContext1 = this.getReportDesignerContext();
        if (this.tabIndex == -1) {
            ReportDocumentContext activeContext = this.getActiveContext();
            if (activeContext == null) {
                return;
            }
            CloseReportAction.performCloseReport(reportDesignerContext1, activeContext);
        } else if (this.tabIndex >= 0 && this.tabIndex < reportDesignerContext1.getReportRenderContextCount()) {
            ReportRenderContext context = reportDesignerContext1.getReportRenderContext(this.tabIndex);
            CloseReportAction.performCloseReport(reportDesignerContext1, context);
        }
    }

    public static boolean performCloseReport(ReportDesignerContext context, ReportDocumentContext activeContext) {
        int option;
        if (activeContext.isChanged() && activeContext.getReportDefinition() instanceof MasterReport && ((option = JOptionPane.showConfirmDialog(context.getView().getParent(), ActionMessages.getString("ReportModifiedCloseWarning.Message", new Object[0]), ActionMessages.getString("ReportModifiedCloseWarning.Title", new Object[0]), 1, 2)) == 0 ? !new SaveReportAction().saveReport(context, activeContext, context.getView().getParent()) : option == 2)) {
            return false;
        }
        CloseReportAction.performUnconditionalClose(context, activeContext);
        return true;
    }

    public static void performUnconditionalClose(ReportDesignerContext context, ReportDocumentContext activeContext) {
        int contextCount = context.getReportRenderContextCount();
        AbstractReportDefinition reportDefinition = activeContext.getReportDefinition();
        if (reportDefinition instanceof MasterReport) {
            for (int i = contextCount - 1; i >= 0; --i) {
                ReportRenderContext reportRenderContext = context.getReportRenderContext(i);
                if (reportRenderContext.getMasterReportElement() != reportDefinition) continue;
                context.removeReportRenderContext(i);
            }
            return;
        }
        for (int i = 0; i < contextCount; ++i) {
            ReportRenderContext reportRenderContext = context.getReportRenderContext(i);
            if (reportRenderContext != activeContext) continue;
            context.removeReportRenderContext(i);
            return;
        }
    }

    public static ReportRenderContext[] filterSubreports(ReportDesignerContext context, ReportRenderContext[] closeContexts) {
        LinkedHashMap<InstanceID, ReportRenderContext> map = new LinkedHashMap<InstanceID, ReportRenderContext>();
        for (int i = 0; i < closeContexts.length; ++i) {
            ReportRenderContext closeContext = closeContexts[i];
            InstanceID id = closeContext.getMasterReportElement().getObjectID();
            if (!map.containsKey(id)) {
                map.put(id, closeContext);
                continue;
            }
            if (closeContext.getMasterReportElement() != closeContext.getReportDefinition()) continue;
            map.put(id, closeContext);
        }
        return map.values().toArray(new ReportRenderContext[map.size()]);
    }
}

