/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.report;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.table.TableModel;
import org.pentaho.reporting.designer.core.actions.AbstractElementSelectionAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.actions.report.AddDataFactoryAction;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.structuretree.ReportQueryNode;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataFactoryContext;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.StaticDataRow;
import org.pentaho.reporting.engine.classic.core.TableDataFactory;
import org.pentaho.reporting.engine.classic.core.designtime.DataFactoryChange;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.DesignTimeDataFactoryContext;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.metadata.DataFactoryMetaData;
import org.pentaho.reporting.engine.classic.core.util.TypedTableModel;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.libraries.designtime.swing.background.BackgroundCancellableProcessHelper;

public class ConvertDataSourceAction
extends AbstractElementSelectionAction {
    public ConvertDataSourceAction() {
        this.putValue("Name", ActionMessages.getString("ConvertDataSourceAction.Text", new Object[0]));
        this.putValue("Default", ActionMessages.getString("ConvertDataSourceAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("ConvertDataSourceAction.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("ConvertDataSourceAction.Accelerator"));
    }

    @Override
    protected void selectedElementPropertiesChanged(ReportModelEvent event) {
    }

    @Override
    protected void updateSelection() {
        DocumentContextSelectionModel model = this.getSelectionModel();
        if (model == null) {
            this.setEnabled(false);
            return;
        }
        Object[] selectedObjects = model.getSelectedElements();
        for (int i = 0; i < selectedObjects.length; ++i) {
            ReportQueryNode queryNode;
            DataFactory dataFactory;
            DataFactoryMetaData metadata;
            Object selectedObject = selectedObjects[i];
            if (!(selectedObject instanceof ReportQueryNode) || !(metadata = (dataFactory = (queryNode = (ReportQueryNode)selectedObject).getDataFactory()).getMetaData()).isEditable()) continue;
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ReportDocumentContext activeContext = this.getActiveContext();
        if (activeContext == null) {
            return;
        }
        Thread thread = new Thread(new ConvertDataSourceTask(activeContext));
        thread.setName("ConvertDataSource-Worker");
        thread.setDaemon(true);
        BackgroundCancellableProcessHelper.executeProcessWithCancelDialog((Thread)thread, null, (Component)this.getReportDesignerContext().getView().getParent(), (String)ActionMessages.getString("ConvertDataSourceAction.TaskTitle", new Object[0]));
    }

    public static class ConvertDataSourceTask
    implements Runnable {
        private Object[] selectedElements;
        private ReportDocumentContext activeContext;

        public ConvertDataSourceTask(ReportDocumentContext activeContext) {
            this.activeContext = activeContext;
            this.selectedElements = activeContext.getSelectionModel().getSelectedElements();
        }

        @Override
        public void run() {
            for (int i = 0; i < this.selectedElements.length; ++i) {
                Object element = this.selectedElements[i];
                if (!(element instanceof ReportQueryNode)) continue;
                try {
                    ReportQueryNode queryNode = (ReportQueryNode)element;
                    DataFactory dataFactory = queryNode.getDataFactory().derive();
                    MasterReport report = (MasterReport)this.activeContext.getContextRoot();
                    dataFactory.initialize((DataFactoryContext)new DesignTimeDataFactoryContext(report));
                    if (!dataFactory.isQueryExecutable(queryNode.getQueryName(), (DataRow)new StaticDataRow())) {
                        return;
                    }
                    TableModel tableModel = dataFactory.queryData(queryNode.getQueryName(), (DataRow)new StaticDataRow());
                    TableDataFactory tableDataFactory = new TableDataFactory();
                    tableDataFactory.addTable(queryNode.getQueryName(), this.createModel(tableModel));
                    AddDataFactoryAction.addDataFactory(this.activeContext, (DataFactory)tableDataFactory, new DataFactoryChange[0]);
                }
                catch (Exception e1) {
                    UncaughtExceptionsModel.getInstance().addException(e1);
                }
                break;
            }
        }

        public TableModel createModel(TableModel model) throws BeanException {
            TypedTableModel tableModel = new TypedTableModel();
            int columnCount = model.getColumnCount();
            for (int col = 0; col < columnCount; ++col) {
                tableModel.addColumn(model.getColumnName(col), model.getColumnClass(col));
            }
            int rowCount = model.getRowCount();
            for (int r = 0; r < rowCount; ++r) {
                for (int col = 0; col < columnCount; ++col) {
                    tableModel.setValueAt(this.process(model.getValueAt(r, col)), r, col);
                }
            }
            return tableModel;
        }

        protected Object process(Object o) throws BeanException {
            return o;
        }
    }
}

