/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.report;

import java.awt.Cursor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import org.pentaho.reporting.designer.core.actions.AbstractElementSelectionAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.structuretree.ReportQueryNode;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.designer.core.util.ReportDesignerDesignTimeContext;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.designer.core.util.undo.DataSourceEditUndoEntry;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.CompoundDataFactory;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.designtime.DataSourcePlugin;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeContext;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.metadata.DataFactoryMetaData;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class EditQueryAction
extends AbstractElementSelectionAction {
    private DataFactory editedDataFactory = null;

    public EditQueryAction() {
        this.putValue("Name", ActionMessages.getString("EditQueryAction.Text", new Object[0]));
        this.putValue("Default", ActionMessages.getString("EditQueryAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("EditQueryAction.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("EditQueryAction.Accelerator"));
    }

    @Override
    protected void selectedElementPropertiesChanged(ReportModelEvent event) {
    }

    @Override
    protected void updateSelection() {
        DocumentContextSelectionModel selectionModel1 = this.getSelectionModel();
        if (selectionModel1 == null) {
            this.setEnabled(false);
            this.editedDataFactory = null;
            return;
        }
        Object[] selectedObjects = selectionModel1.getSelectedElements();
        for (int i = 0; i < selectedObjects.length; ++i) {
            ReportQueryNode queryNode;
            DataFactory dataFactory;
            DataFactoryMetaData metadata;
            Object selectedObject = selectedObjects[i];
            if (!(selectedObject instanceof ReportQueryNode) || !(metadata = (dataFactory = (queryNode = (ReportQueryNode)selectedObject).getDataFactory()).getMetaData()).isEditable()) continue;
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ReportDocumentContext activeContext = this.getActiveContext();
        if (activeContext == null) {
            return;
        }
        Object[] selectedElements = this.getSelectionModel().getSelectedElements();
        for (int i = 0; i < selectedElements.length; ++i) {
            Object element = selectedElements[i];
            if (element instanceof ReportQueryNode) {
                ReportQueryNode queryNode = (ReportQueryNode)element;
                try {
                    this.performEdit(queryNode.getDataFactory(), queryNode.getQueryName());
                }
                catch (ReportDataFactoryException e1) {
                    UncaughtExceptionsModel.getInstance().addException(e1);
                }
                break;
            }
            if (!(element instanceof DataFactory)) continue;
            try {
                AbstractReportDefinition report = activeContext.getReportDefinition();
                DataFactory dataFactory = (DataFactory)element;
                this.performEdit(dataFactory, report.getQuery());
            }
            catch (ReportDataFactoryException e1) {
                UncaughtExceptionsModel.getInstance().addException(e1);
            }
            break;
        }
    }

    public void performEdit(DataFactory dataFactory, String queryName) throws ReportDataFactoryException {
        DataFactoryMetaData metadata = dataFactory.getMetaData();
        if (!metadata.isEditable()) {
            return;
        }
        DataSourcePlugin dataSourcePlugin = metadata.createEditor();
        DataFactory storedFactory = dataFactory.derive();
        if (dataSourcePlugin.canHandle(dataFactory)) {
            ReportDocumentContext activeContext = this.getActiveContext();
            AbstractReportDefinition report = activeContext.getReportDefinition();
            boolean editingActiveQuery = EditQueryAction.contains(report.getQuery(), dataFactory.getQueryNames());
            ReportDesignerDesignTimeContext designTimeContext = new ReportDesignerDesignTimeContext(this.getReportDesignerContext());
            this.editedDataFactory = dataSourcePlugin.performEdit((DesignTimeContext)designTimeContext, dataFactory, queryName, null);
            if (this.editedDataFactory == null) {
                return;
            }
            Window parentWindow = designTimeContext.getParentWindow();
            parentWindow.setCursor(Cursor.getPredefinedCursor(3));
            CompoundDataFactory collection = (CompoundDataFactory)report.getDataFactory();
            int dataFactoryCount = collection.size();
            for (int j = 0; j < dataFactoryCount; ++j) {
                DataFactory originalDataFactory = collection.getReference(j);
                if (originalDataFactory != dataFactory) continue;
                collection.remove(j);
                DataFactory editedClone = this.editedDataFactory.derive();
                collection.add(j, this.editedDataFactory);
                activeContext.getUndo().addChange(ActionMessages.getString("EditQueryAction.Text", new Object[0]), new DataSourceEditUndoEntry(j, storedFactory, editedClone));
                report.notifyNodeChildRemoved((Object)originalDataFactory);
                report.notifyNodeChildAdded((Object)this.editedDataFactory);
                parentWindow.setCursor(Cursor.getDefaultCursor());
                if (!editingActiveQuery) {
                    return;
                }
                String[] editedQueries = this.editedDataFactory.getQueryNames();
                if (!EditQueryAction.contains(report.getQuery(), editedQueries)) {
                    report.setQuery(null);
                }
                return;
            }
            throw new IllegalStateException();
        }
    }

    private static boolean contains(String key, String[] haystack) {
        for (int i = 0; i < haystack.length; ++i) {
            if (!ObjectUtilities.equal((Object)haystack[i], (Object)key)) continue;
            return true;
        }
        return false;
    }

    public DataFactory getEditedDataFactory() {
        return this.editedDataFactory;
    }
}

