/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.report;

import java.awt.event.ActionEvent;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.actions.AbstractReportContextAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.editor.styles.styleeditor.StyleDefinitionEditorDialog;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.designer.core.util.undo.AttributeEditUndoEntry;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.style.css.ElementStyleDefinition;

public class EditStyleDefinitionAction
extends AbstractReportContextAction {
    public EditStyleDefinitionAction() {
        this.putValue("Name", ActionMessages.getString("EditStyleDefinitionAction.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("EditStyleDefinitionAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("EditStyleDefinitionAction.Mnemonic"));
        this.putValue("SmallIcon", IconLoader.getInstance().getEmptyIcon());
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("EditStyleDefinitionAction.Accelerator"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ReportDesignerContext context;
        StyleDefinitionEditorDialog dialog;
        ElementStyleDefinition elementStyleDefinition;
        MasterReport masterReportElement = (MasterReport)this.getActiveContext().getContextRoot();
        ElementStyleDefinition styleDefinition = masterReportElement.getStyleDefinition();
        if (styleDefinition != null) {
            styleDefinition = styleDefinition.clone();
        }
        if ((elementStyleDefinition = (dialog = StyleDefinitionEditorDialog.createDialog((context = this.getReportDesignerContext()).getView().getParent(), context)).performEdit(styleDefinition)) == styleDefinition) {
            return;
        }
        masterReportElement.setStyleDefinition(elementStyleDefinition);
        AttributeEditUndoEntry undoEntry = new AttributeEditUndoEntry(masterReportElement.getObjectID(), "http://reporting.pentaho.org/namespaces/engine/attributes/core", "style-sheet", styleDefinition, elementStyleDefinition);
        this.getActiveContext().getUndo().addChange(ActionMessages.getString("EditStyleDefinitionAction.UndoName", new Object[0]), undoEntry);
    }
}

