/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.report;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.actions.AbstractReportContextAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.actions.ToggleStateAction;
import org.pentaho.reporting.designer.core.util.IconLoader;

public class SelectionWaitingAction
extends AbstractReportContextAction
implements ToggleStateAction {
    private PropertyChangeListener selectionWaitingHandler = new SelectionWaitingHandler();

    public SelectionWaitingAction() {
        this.putValue("Name", ActionMessages.getString("SelectionWaitingAction.Text", new Object[0]));
        this.putValue("SmallIcon", IconLoader.getInstance().getRubberbandSelectionIcon());
        this.putValue("ShortDescription", ActionMessages.getString("SelectionWaitingAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("SelectionWaitingAction.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("SelectionWaitingAction.Accelerator"));
    }

    @Override
    protected void updateDesignerContext(ReportDesignerContext oldContext, ReportDesignerContext newContext) {
        super.updateDesignerContext(oldContext, newContext);
        if (oldContext != null) {
            oldContext.removePropertyChangeListener("selectionWaiting", this.selectionWaitingHandler);
        }
        if (newContext != null) {
            newContext.addPropertyChangeListener("selectionWaiting", this.selectionWaitingHandler);
        }
    }

    @Override
    public boolean isSelected() {
        return Boolean.TRUE.equals(this.getValue("SwingSelectedKey"));
    }

    public void setSelected(boolean selected) {
        this.putValue("SwingSelectedKey", selected);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ReportDesignerContext activeContext = this.getReportDesignerContext();
        if (activeContext == null) {
            return;
        }
        activeContext.setSelectionWaiting(!activeContext.isSelectionWaiting());
    }

    private class SelectionWaitingHandler
    implements PropertyChangeListener {
        private SelectionWaitingHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            SelectionWaitingAction.this.putValue("SwingSelectedKey", evt.getNewValue());
        }
    }
}

