/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.report;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.actions.AbstractReportContextAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.ReportRenderContext;
import org.pentaho.reporting.designer.core.inspections.Inspection;
import org.pentaho.reporting.designer.core.inspections.InspectionResult;
import org.pentaho.reporting.designer.core.inspections.InspectionResultListener;
import org.pentaho.reporting.designer.core.inspections.InspectionsMessageDialog;
import org.pentaho.reporting.designer.core.inspections.InspectionsRegistry;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.RootLevelBand;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;
import org.pentaho.reporting.libraries.designtime.swing.background.BackgroundCancellableProcessHelper;
import org.pentaho.reporting.libraries.designtime.swing.background.CancelEvent;
import org.pentaho.reporting.libraries.designtime.swing.background.CancelListener;
import org.pentaho.reporting.libraries.designtime.swing.background.ProgressFeed;

public class ValidateReportAction
extends AbstractReportContextAction {
    public ValidateReportAction() {
        this.putValue("Name", ActionMessages.getString("ValidateReportAction.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("ValidateReportAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("ValidateReportAction.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("ValidateReportAction.Accelerator"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ReportDesignerContext reportDesignerContext = this.getReportDesignerContext();
        RunInspectionTask task = new RunInspectionTask(reportDesignerContext);
        Thread t = new Thread(task);
        t.setDaemon(true);
        BackgroundCancellableProcessHelper.executeProcessWithCancelDialog((Thread)t, (CancelListener)task, (Component)reportDesignerContext.getView().getParent(), (String)"Running Inspections ..", (ProgressFeed)task);
    }

    private static void findLocalSubreports(Section section, ArrayList<SubReport> result) {
        int elementCount = section.getElementCount();
        for (int i = 0; i < elementCount; ++i) {
            Element element = section.getElement(i);
            if (element instanceof SubReport) {
                result.add((SubReport)element);
                continue;
            }
            if (element instanceof RootLevelBand) {
                RootLevelBand rlb = (RootLevelBand)element;
                SubReport[] subReports = rlb.getSubReports();
                result.addAll(Arrays.asList(subReports));
            }
            if (!(element instanceof Section)) continue;
            ValidateReportAction.findLocalSubreports((Section)element, result);
        }
    }

    private static int countReports(AbstractReportDefinition def) {
        ArrayList<SubReport> result = new ArrayList<SubReport>();
        ValidateReportAction.findLocalSubreports((Section)def, result);
        int count = 1;
        for (SubReport subReport : result) {
            count += ValidateReportAction.countReports((AbstractReportDefinition)subReport);
        }
        return count;
    }

    private static class ShowResultTask
    implements Runnable {
        private InspectionResultCollector collector;
        private ReportDesignerContext reportDesignerContext;

        private ShowResultTask(ReportDesignerContext reportDesignerContext, InspectionResultCollector collector) {
            this.reportDesignerContext = reportDesignerContext;
            this.collector = collector;
        }

        @Override
        public void run() {
            if (this.collector.results.isEmpty()) {
                this.reportDesignerContext.setStatusText(ActionMessages.getString("ValidateReportAction.ValidationRunNoResults", new Object[0]));
            } else {
                Window window = LibSwingUtil.getWindowAncestor((Component)this.reportDesignerContext.getView().getParent());
                InspectionsMessageDialog dialog = window instanceof JDialog ? new InspectionsMessageDialog((JDialog)window) : (window instanceof JFrame ? new InspectionsMessageDialog((JFrame)window) : new InspectionsMessageDialog());
                dialog.performShowResult(this.reportDesignerContext, this.collector.toArray());
            }
        }
    }

    private static class RunInspectionTask
    implements Runnable,
    ProgressFeed,
    CancelListener {
        private ReportDesignerContext reportDesignerContext;
        private InspectionResultCollector collector = new InspectionResultCollector();
        private volatile double progress;
        private volatile boolean cancelled;

        private RunInspectionTask(ReportDesignerContext reportDesignerContext) {
            this.reportDesignerContext = reportDesignerContext;
        }

        public void cancelProcessing(CancelEvent event) {
            this.cancelled = true;
        }

        public double queryProgress() {
            return this.progress;
        }

        @Override
        public void run() {
            ReportDocumentContext activeContext = this.reportDesignerContext.getActiveContext();
            MasterReport report = (MasterReport)activeContext.getContextRoot();
            int numberReports = ValidateReportAction.countReports((AbstractReportDefinition)report);
            this.runInspection((AbstractReportDefinition)report, report, this.reportDesignerContext, null, this.collector, 1, numberReports);
            if (!this.cancelled) {
                SwingUtilities.invokeLater(new ShowResultTask(this.reportDesignerContext, this.collector));
            }
        }

        private int runInspection(AbstractReportDefinition def, MasterReport master, ReportDesignerContext reportDesignerContext, ReportRenderContext parentContext, InspectionResultCollector collector, int currentReport, int maxReports) {
            ReportRenderContext r = new ReportRenderContext(master, def, parentContext, reportDesignerContext.getGlobalAuthenticationStore(), true);
            Inspection[] inspections = InspectionsRegistry.getInstance().getInspections();
            if (this.cancelled) {
                return currentReport;
            }
            int counter = currentReport;
            this.progress = (double)counter / (double)maxReports;
            for (int i = 0; i < inspections.length; ++i) {
                Inspection inspection = inspections[i];
                try {
                    inspection.inspect(reportDesignerContext, r, collector);
                    continue;
                }
                catch (Exception e) {
                    UncaughtExceptionsModel.getInstance().addException(e);
                }
            }
            ArrayList subreports = new ArrayList();
            ValidateReportAction.findLocalSubreports((Section)def, subreports);
            for (SubReport subreport : subreports) {
                counter = this.runInspection((AbstractReportDefinition)subreport, master, reportDesignerContext, r, collector, counter + 1, maxReports);
                if (!this.cancelled) continue;
                return counter;
            }
            r.dispose();
            return counter;
        }
    }

    private static class InspectionResultCollector
    implements InspectionResultListener {
        private ArrayList<InspectionResult> results = new ArrayList();

        private InspectionResultCollector() {
        }

        @Override
        public void notifyInspectionStarted() {
        }

        @Override
        public void notifyInspectionResult(InspectionResult result) {
            this.results.add(result);
        }

        public InspectionResult[] toArray() {
            return this.results.toArray(new InspectionResult[this.results.size()]);
        }
    }
}

