/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.report.preview;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.pentaho.reporting.designer.core.actions.AbstractReportContextAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.util.ExternalToolLauncher;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.event.ReportProgressListener;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.PreviewParametersDialog;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ExceptionDialog;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ReportProgressDialog;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.html.FastHtmlContentItems;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.html.FastHtmlExportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.validator.ReportStructureValidator;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.StreamReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.AllItemsHtmlPrinter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.FileSystemURLRewriter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.HtmlPrinter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.StreamHtmlOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.URLRewriter;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.DefaultNameGenerator;
import org.pentaho.reporting.libraries.repository.NameGenerator;
import org.pentaho.reporting.libraries.repository.file.FileRepository;

public final class PreviewHtmlAction
extends AbstractReportContextAction {
    public PreviewHtmlAction() {
        this.putValue("Name", ActionMessages.getString("PreviewHtmlAction.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("PreviewHtmlAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("PreviewHtmlAction.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("PreviewHtmlAction.Accelerator"));
        this.putValue("SmallIcon", IconLoader.getInstance().getPreviewHTMLIcon());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.getActiveContext() == null) {
            return;
        }
        MasterReport reportElement = (MasterReport)this.getActiveContext().getContextRoot();
        Component parent = this.getReportDesignerContext().getView().getParent();
        Window window = LibSwingUtil.getWindowAncestor((Component)parent);
        if (PreviewParametersDialog.process((Window)window, (MasterReport)reportElement)) {
            ReportProgressDialog dialog = window instanceof JDialog ? new ReportProgressDialog((Dialog)((JDialog)window)) : (window instanceof JFrame ? new ReportProgressDialog((Frame)((JFrame)window)) : new ReportProgressDialog());
            Thread t = new Thread(new ExportTask(reportElement, dialog));
            t.setDaemon(true);
            t.start();
        }
    }

    protected static File createTemporaryDirectory(String directoryName) throws IOException {
        Configuration configuration = ClassicEngineBoot.getInstance().getGlobalConfig();
        String s = configuration.getConfigProperty("java.io.tmpdir");
        File tempDir = new File(s);
        if (!tempDir.exists()) {
            tempDir.mkdirs();
        }
        if (!tempDir.exists() || !tempDir.isDirectory()) {
            throw new IOException("Unable to access or create the temp-directory");
        }
        if (!tempDir.canWrite()) {
            throw new IOException("Unable to write to temp-directory.");
        }
        Random randomGenerator = new Random(System.currentTimeMillis());
        for (int i = 1; i < 200; ++i) {
            int random = randomGenerator.nextInt();
            File reportDirectory = new File(s, directoryName + random);
            if (reportDirectory.exists() && !reportDirectory.isDirectory() || !reportDirectory.exists() && !reportDirectory.mkdirs()) continue;
            reportDirectory.deleteOnExit();
            return reportDirectory;
        }
        throw new IOException("Unable to generate the target directory.");
    }

    protected static void markDirectoryContentAsDeletable(File directory) {
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                file.deleteOnExit();
                if (!file.isDirectory()) continue;
                PreviewHtmlAction.markDirectoryContentAsDeletable(file);
            }
        }
    }

    private static class ExportTask
    implements Runnable {
        private MasterReport report;
        private ReportProgressDialog progressDialog;

        private ExportTask(MasterReport report, ReportProgressDialog progressDialog) {
            this.report = report;
            this.progressDialog = progressDialog;
        }

        @Override
        public void run() {
            try {
                File tempDir = PreviewHtmlAction.createTemporaryDirectory("report-designer-html-preview");
                try {
                    FastHtmlExportProcessor reportProcessor;
                    FileRepository targetRepository = new FileRepository(tempDir);
                    ContentLocation targetRoot = targetRepository.getRoot();
                    ReportStructureValidator validator = new ReportStructureValidator();
                    if (!validator.isValidForFastProcessing(this.report)) {
                        StreamHtmlOutputProcessor outputProcessor = new StreamHtmlOutputProcessor(this.report.getConfiguration());
                        AllItemsHtmlPrinter printer = new AllItemsHtmlPrinter(this.report.getResourceManager());
                        printer.setContentWriter(targetRoot, (NameGenerator)new DefaultNameGenerator(targetRoot, "index", "html"));
                        printer.setDataWriter(targetRoot, (NameGenerator)new DefaultNameGenerator(targetRoot, "content"));
                        printer.setUrlRewriter((URLRewriter)new FileSystemURLRewriter());
                        outputProcessor.setPrinter((HtmlPrinter)printer);
                        reportProcessor = new StreamReportProcessor(this.report, (OutputProcessor)outputProcessor);
                    } else {
                        FastHtmlContentItems printer = new FastHtmlContentItems();
                        printer.setContentWriter(targetRoot, (NameGenerator)new DefaultNameGenerator(targetRoot, "index", "html"));
                        printer.setDataWriter(targetRoot, (NameGenerator)new DefaultNameGenerator(targetRoot, "content"));
                        printer.setUrlRewriter((URLRewriter)new FileSystemURLRewriter());
                        reportProcessor = new FastHtmlExportProcessor(this.report, printer);
                    }
                    reportProcessor.addReportProgressListener((ReportProgressListener)this.progressDialog);
                    this.progressDialog.setVisibleInEDT(true);
                    reportProcessor.processReport();
                    reportProcessor.close();
                    reportProcessor.removeReportProgressListener((ReportProgressListener)this.progressDialog);
                    this.progressDialog.setVisibleInEDT(false);
                    File previewFile = new File(tempDir, "index.html");
                    ExternalToolLauncher.openURL(previewFile.toURI().toURL().toExternalForm());
                }
                catch (Exception e1) {
                    UncaughtExceptionsModel.getInstance().addException(e1);
                    this.progressDialog.dispose();
                    String errorMessage = ActionMessages.getString("PreviewReport.Error.Text", new Object[0]);
                    String errorTitle = ActionMessages.getString("PreviewReport.Error.Title", new Object[0]);
                    ExceptionDialog.showExceptionDialog((Component)this.progressDialog.getParent(), (String)errorTitle, (String)errorMessage, (Exception)e1);
                }
                tempDir.deleteOnExit();
                PreviewHtmlAction.markDirectoryContentAsDeletable(tempDir);
            }
            catch (IOException e) {
                UncaughtExceptionsModel.getInstance().addException(e);
            }
        }
    }
}

