/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.selection;

import java.awt.Component;
import java.awt.TextComponent;
import java.awt.event.ActionEvent;
import javax.swing.FocusManager;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;
import org.pentaho.reporting.designer.core.actions.AbstractReportContextAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.editor.report.RootBandRenderComponent;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.RootLevelBand;
import org.pentaho.reporting.engine.classic.core.Section;

public final class SelectAllAction
extends AbstractReportContextAction {
    public SelectAllAction() {
        this.putValue("Name", ActionMessages.getString("SelectAllAction.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("SelectAllAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("SelectAllAction.Text"));
        this.putValue("SmallIcon", IconLoader.getInstance().getSelectAllIcon());
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("SelectAllAction.Accelerator"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Component owner = FocusManager.getCurrentManager().getPermanentFocusOwner();
        if (owner instanceof JTextComponent) {
            JTextComponent textComponent = (JTextComponent)owner;
            textComponent.selectAll();
        } else if (owner instanceof TextComponent) {
            TextComponent textComponent = (TextComponent)owner;
            textComponent.selectAll();
        } else if (owner instanceof JTable) {
            JTable table = (JTable)owner;
            table.selectAll();
        } else if (owner instanceof JList) {
            JList list = (JList)owner;
            list.getSelectionModel().setSelectionInterval(0, list.getModel().getSize());
            list.repaint();
        } else if (owner instanceof JTree) {
            JTree list = (JTree)owner;
            int[] indices = new int[list.getRowCount()];
            for (int i = 0; i < indices.length; ++i) {
                indices[i] = i;
            }
            list.setSelectionRows(indices);
            list.repaint();
        } else if (owner instanceof RootBandRenderComponent) {
            RootBandRenderComponent rc = (RootBandRenderComponent)owner;
            Section reportElement = rc.getRendererRoot().getElement();
            DocumentContextSelectionModel selectionModel = this.getActiveContext().getSelectionModel();
            this.selectRecursively(selectionModel, reportElement);
            if (reportElement instanceof RootLevelBand) {
                RootLevelBand re = (RootLevelBand)reportElement;
                int count = re.getSubReportCount();
                for (int i = 0; i < count; ++i) {
                    selectionModel.add(re.getSubReport(i));
                }
            }
        }
    }

    private void selectRecursively(DocumentContextSelectionModel selectionModel, Section band) {
        if (!(band instanceof RootLevelBand)) {
            selectionModel.add(band);
        }
        int count = band.getElementCount();
        for (int i = 0; i < count; ++i) {
            Element element = band.getElement(i);
            if (element instanceof Band) {
                this.selectRecursively(selectionModel, (Section)((Band)element));
                continue;
            }
            selectionModel.add(element);
        }
    }
}

