/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.attributes.VisualAttributeEditorPanel;
import org.pentaho.reporting.designer.core.editor.expressions.ExpressionPropertiesEditorPanel;
import org.pentaho.reporting.designer.core.editor.styles.StyleEditorPanel;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.designer.core.util.SidePanel;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.function.Expression;

public class ElementPropertiesPanel
extends SidePanel {
    private static final String BLANK_CARD = "Blank";
    private static final String ATTRIBUTES_CARD = "Attributes";
    private static final String EXPRESSIONS_CARD = "Expressions";
    private static final String DATASOURCE_CARD = "Datasource";
    private VisualAttributeEditorPanel attributeEditorPanel;
    private StyleEditorPanel styleEditorPanel;
    private CardLayout cardLayout = new CardLayout();
    private ExpressionPropertiesEditorPanel expressionEditorPanel;
    private JPanel datasourceCarrier;
    private boolean allowAttributeCard = true;
    private boolean allowDataSourceCard = false;
    private boolean allowExpressionCard = false;

    public ElementPropertiesPanel() {
        this.setLayout(this.cardLayout);
        this.attributeEditorPanel = new VisualAttributeEditorPanel();
        this.styleEditorPanel = new StyleEditorPanel();
        this.expressionEditorPanel = new ExpressionPropertiesEditorPanel();
        this.datasourceCarrier = new JPanel(new BorderLayout());
        JPanel blankPanel = new JPanel();
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab(Messages.getString("ElementPropertiesPanel.Style", new Object[0]), this.styleEditorPanel);
        tabbedPane.addTab(Messages.getString("ElementPropertiesPanel.Attributes", new Object[0]), this.attributeEditorPanel);
        this.add((Component)tabbedPane, ATTRIBUTES_CARD);
        this.add((Component)this.expressionEditorPanel, EXPRESSIONS_CARD);
        this.add((Component)this.datasourceCarrier, DATASOURCE_CARD);
        this.add((Component)blankPanel, BLANK_CARD);
    }

    @Override
    public void setReportDesignerContext(ReportDesignerContext reportDesignerContext) {
        super.setReportDesignerContext(reportDesignerContext);
        this.attributeEditorPanel.setReportDesignerContext(reportDesignerContext);
        this.styleEditorPanel.setReportDesignerContext(reportDesignerContext);
        this.expressionEditorPanel.setReportDesignerContext(reportDesignerContext);
    }

    public void setAllowAttributeCard(boolean allowAttributeCard) {
        this.allowAttributeCard = allowAttributeCard;
    }

    public void setAllowDataSourceCard(boolean allowDataSourceCard) {
        this.allowDataSourceCard = allowDataSourceCard;
    }

    public void setAllowExpressionCard(boolean allowExpressionCard) {
        this.allowExpressionCard = allowExpressionCard;
    }

    public void reset(DocumentContextSelectionModel model) {
        this.cardLayout.show(this, BLANK_CARD);
        this.updateSelection(model);
    }

    @Override
    protected void updateSelection(DocumentContextSelectionModel model) {
        this.datasourceCarrier.removeAll();
        if (model.getSelectionCount() < 1) {
            this.cardLayout.show(this, BLANK_CARD);
            return;
        }
        Object o = model.getSelectedElement(0);
        if (o instanceof DataFactory && this.allowDataSourceCard) {
            this.cardLayout.show(this, DATASOURCE_CARD);
            return;
        }
        if (o instanceof Expression && this.allowExpressionCard) {
            this.cardLayout.show(this, EXPRESSIONS_CARD);
            return;
        }
        if (o instanceof ReportElement && this.allowAttributeCard) {
            this.cardLayout.show(this, ATTRIBUTES_CARD);
            return;
        }
        this.cardLayout.show(this, BLANK_CARD);
    }
}

