/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor;

import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.auth.AuthenticationStore;
import org.pentaho.reporting.designer.core.auth.GlobalAuthenticationStore;
import org.pentaho.reporting.designer.core.auth.ReportAuthenticationStore;
import org.pentaho.reporting.designer.core.editor.ReportDataChangeListener;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.ZoomModel;
import org.pentaho.reporting.designer.core.editor.ZoomModelListener;
import org.pentaho.reporting.designer.core.editor.report.layouting.SharedElementRenderer;
import org.pentaho.reporting.designer.core.inspections.AutoInspectionRunner;
import org.pentaho.reporting.designer.core.inspections.InspectionResultListener;
import org.pentaho.reporting.designer.core.inspections.InspectionRunner;
import org.pentaho.reporting.designer.core.inspections.NoOpInspectionRunner;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.designer.core.model.data.AsynchronousDataSchemaManager;
import org.pentaho.reporting.designer.core.model.data.DataSchemaManager;
import org.pentaho.reporting.designer.core.model.selection.DefaultReportSelectionModel;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.designer.core.util.undo.UndoManager;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.CrosstabElement;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.PageDefinition;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.RootLevelBand;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.event.ReportModelListener;
import org.pentaho.reporting.engine.classic.core.wizard.ContextAwareDataSchemaModel;
import org.pentaho.reporting.libraries.base.util.ArgumentNullException;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class ReportRenderContext
implements ReportDocumentContext {
    private static final String AUTHENTICATION_STORE_PROPERTY = "authentication-store";
    private final PropertyChangeSupport propertyChangeSupport;
    private final SharedElementRenderer sharedRenderer;
    private final ZoomModel zoomModel;
    private final MasterReport masterReportElement;
    private final AbstractReportDefinition reportDefinition;
    private final DocumentContextSelectionModel selectionModel;
    private final InspectionRunner inspectionRunner;
    private final UndoManager undo;
    private final NodeDeleteListener deleteListener;
    private final HashMap<String, Object> properties;
    private final DataSchemaManager dataSchemaManager;
    private final boolean bandedContext;
    private final ReportDocumentContext parentContext;
    private final ArrayList<ReportDataChangeListener> dataChangeListeners;
    private String tabName;
    private Icon icon;
    private long changeTracker;

    public ReportRenderContext(MasterReport masterReport) {
        this(masterReport, (AbstractReportDefinition)masterReport, null, new GlobalAuthenticationStore());
    }

    public ReportRenderContext(MasterReport masterReportElement, AbstractReportDefinition report, ReportDocumentContext parentContext, GlobalAuthenticationStore globalAuthenticationStore) {
        this(masterReportElement, report, parentContext, globalAuthenticationStore, false);
    }

    public ReportRenderContext(MasterReport masterReportElement, AbstractReportDefinition report, ReportDocumentContext parentContext, GlobalAuthenticationStore globalAuthenticationStore, boolean computationTarget) {
        if (masterReportElement == null) {
            throw new NullPointerException();
        }
        if (report == null) {
            throw new NullPointerException();
        }
        this.dataChangeListeners = new ArrayList();
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.selectionModel = new DefaultReportSelectionModel();
        this.masterReportElement = masterReportElement;
        this.deleteListener = new NodeDeleteListener();
        this.reportDefinition = report;
        this.reportDefinition.addReportModelListener((ReportModelListener)this.deleteListener);
        this.reportDefinition.addReportModelListener((ReportModelListener)new ReportNameUpdateHandler(this));
        this.zoomModel = new ZoomModel();
        this.zoomModel.addZoomModelListener(new ZoomUpdateHandler());
        this.bandedContext = this.computeBandedContext(parentContext);
        this.parentContext = parentContext;
        this.dataSchemaManager = new AsynchronousDataSchemaManager(masterReportElement, report);
        this.dataSchemaManager.addChangeListener(new DataSchemaManagerUpdateHandler());
        if (!computationTarget) {
            this.inspectionRunner = new AutoInspectionRunner(this);
            this.reportDefinition.addReportModelListener((ReportModelListener)this.inspectionRunner);
            this.undo = this.createUndoManager();
        } else {
            this.inspectionRunner = NoOpInspectionRunner.INSTANCE;
            this.undo = null;
        }
        Object f = this.reportDefinition.getAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "zoom");
        if (f instanceof Float) {
            Float zoomFactor = (Float)f;
            this.zoomModel.setZoomAsPercentage(zoomFactor.floatValue());
        }
        if (parentContext == null) {
            this.properties = new HashMap();
            this.sharedRenderer = new SharedElementRenderer(this);
        } else {
            this.sharedRenderer = parentContext.getSharedRenderer();
            this.properties = parentContext.getProperties();
        }
        this.prepareAuthenticationStore(globalAuthenticationStore);
        this.prepareIcon();
        this.resetChangeTracker();
    }

    private UndoManager createUndoManager() {
        Object o = this.reportDefinition.getAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "undo");
        if (o instanceof UndoManager) {
            return (UndoManager)o;
        }
        return new UndoManager();
    }

    private void prepareAuthenticationStore(GlobalAuthenticationStore globalAuthenticationStore) {
        Object maybeAuthStore = this.getProperty(AUTHENTICATION_STORE_PROPERTY);
        if (maybeAuthStore == null) {
            this.setProperty(AUTHENTICATION_STORE_PROPERTY, new ReportAuthenticationStore(globalAuthenticationStore));
        }
    }

    private void prepareIcon() {
        Image iconImage = this.reportDefinition.getElementType().getMetaData().getIcon(Locale.getDefault(), 1);
        this.icon = iconImage != null ? new ImageIcon(iconImage) : null;
    }

    @Override
    public void addReportDataChangeListener(ReportDataChangeListener l) {
        ArgumentNullException.validate((String)"l", (Object)l);
        this.dataChangeListeners.add(l);
    }

    @Override
    public void removeReportDataChangeListener(ReportDataChangeListener l) {
        ArgumentNullException.validate((String)"l", (Object)l);
        this.dataChangeListeners.remove(l);
    }

    protected void fireDataSourceChangedEvent() {
        if (this.dataChangeListeners.isEmpty()) {
            return;
        }
        for (ReportDataChangeListener listener : this.dataChangeListeners) {
            listener.dataModelChanged(this);
        }
    }

    @Override
    public boolean isBandedContext() {
        return this.bandedContext;
    }

    private boolean computeBandedContext(ReportDocumentContext parentContext) {
        if (parentContext == null) {
            return true;
        }
        if (this.reportDefinition instanceof MasterReport) {
            return true;
        }
        if (!parentContext.isBandedContext()) {
            return false;
        }
        Section parentSection = this.reportDefinition.getParentSection();
        if (!(parentSection instanceof RootLevelBand)) {
            return false;
        }
        RootLevelBand rlb = (RootLevelBand)parentSection;
        for (int i = 0; i < rlb.getSubReportCount(); ++i) {
            if (rlb.getSubReport(i) != this.reportDefinition) continue;
            return true;
        }
        return false;
    }

    @Override
    public SharedElementRenderer getSharedRenderer() {
        return this.sharedRenderer;
    }

    @Override
    public DocumentContextSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    @Override
    public ContextAwareDataSchemaModel getReportDataSchemaModel() {
        return this.dataSchemaManager.getModel();
    }

    protected InspectionRunner getInspectionRunner() {
        return this.inspectionRunner;
    }

    @Override
    public ZoomModel getZoomModel() {
        return this.zoomModel;
    }

    public MasterReport getMasterReportElement() {
        return this.masterReportElement;
    }

    @Override
    public MasterReport getContextRoot() {
        return this.getMasterReportElement();
    }

    @Override
    public AbstractReportDefinition getReportDefinition() {
        return this.reportDefinition;
    }

    @Deprecated
    public PageDefinition getPageDefinition() {
        return this.masterReportElement.getPageDefinition();
    }

    @Override
    public boolean isChanged() {
        if (this.parentContext != null) {
            return this.parentContext.isChanged();
        }
        return this.getMasterReportElement().getChangeTracker() != this.changeTracker;
    }

    @Override
    public void resetChangeTracker() {
        if (this.parentContext != null) {
            this.parentContext.resetChangeTracker();
        } else {
            this.changeTracker = this.getMasterReportElement().getChangeTracker();
        }
    }

    @Override
    public UndoManager getUndo() {
        return this.undo;
    }

    @Override
    public ResourceManager getResourceManager() {
        return this.masterReportElement.getResourceManager();
    }

    @Override
    public void dispose() {
        this.dataSchemaManager.close();
        this.inspectionRunner.dispose();
        this.reportDefinition.removeReportModelListener((ReportModelListener)this.inspectionRunner);
        this.reportDefinition.removeReportModelListener((ReportModelListener)this.deleteListener);
    }

    public void setProperty(String property, Object value) {
        if (value == null) {
            this.properties.remove(property);
            return;
        }
        this.properties.put(property, value);
    }

    public Object getProperty(String property) {
        return this.properties.get(property);
    }

    @Override
    public HashMap<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public AuthenticationStore getAuthenticationStore() {
        return (AuthenticationStore)this.getProperty(AUTHENTICATION_STORE_PROPERTY);
    }

    @Override
    public String getTabName() {
        return this.tabName;
    }

    public void setTabName(String tabName) {
        String oldName = this.tabName;
        if (ObjectUtilities.equal((Object)oldName, (Object)tabName)) {
            return;
        }
        this.tabName = tabName;
        this.firePropertyChange("tabName", oldName, tabName);
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public String getDocumentFile() {
        return (String)this.masterReportElement.getAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "report-save-path");
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public void onDocumentActivated() {
        this.getInspectionRunner().startTimer();
    }

    @Override
    public void addInspectionListener(InspectionResultListener listener) {
        this.getInspectionRunner().addInspectionListener(listener);
    }

    @Override
    public void removeInspectionListener(InspectionResultListener listener) {
        this.getInspectionRunner().removeInspectionListener(listener);
    }

    private class DataSchemaManagerUpdateHandler
    implements ChangeListener {
        private DataSchemaManagerUpdateHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ReportRenderContext.this.fireDataSourceChangedEvent();
        }
    }

    private class ZoomUpdateHandler
    implements ZoomModelListener {
        private ZoomUpdateHandler() {
        }

        @Override
        public void zoomFactorChanged() {
            ReportRenderContext.this.reportDefinition.setAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "zoom", (Object)new Float(ReportRenderContext.this.zoomModel.getZoomAsPercentage()), false);
        }
    }

    private class NodeDeleteListener
    implements ReportModelListener {
        private NodeDeleteListener() {
        }

        public void nodeChanged(ReportModelEvent event) {
            if (event.isNodeDeleteEvent()) {
                DocumentContextSelectionModel selectionModel = ReportRenderContext.this.getSelectionModel();
                AbstractReportDefinition reportDefinition = ReportRenderContext.this.getReportDefinition();
                Object element = event.getElement();
                if (element instanceof Element) {
                    List<Element> selectedElements = selectionModel.getSelectedElementsOfType(Element.class);
                    for (Element selectedElement : selectedElements) {
                        if (ModelUtility.isDescendant((Section)reportDefinition, (ReportElement)selectedElement)) continue;
                        selectionModel.remove(element);
                    }
                } else {
                    selectionModel.remove(element);
                }
            }
        }
    }

    private static class ReportNameUpdateHandler
    implements ReportModelListener {
        private ReportRenderContext context;

        protected ReportNameUpdateHandler(ReportRenderContext context) {
            this.context = context;
            this.context.setTabName(this.computeTabName(this.context.getReportDefinition()));
        }

        public void nodeChanged(ReportModelEvent event) {
            AbstractReportDefinition report = this.context.getReportDefinition();
            if (event.getElement() == report && event.getType() == 0) {
                this.context.setTabName(this.computeTabName(report));
            }
        }

        private String computeTabName(AbstractReportDefinition report) {
            MasterReport mreport;
            Object title;
            if (report instanceof MasterReport && (title = (mreport = (MasterReport)report).getBundle().getMetaData().getBundleAttribute("http://purl.org/dc/elements/1.1/", "title")) instanceof String) {
                return (String)title;
            }
            String name = report.getName();
            if (!StringUtils.isEmpty((String)name)) {
                return name;
            }
            String theSavePath = (String)report.getAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "report-save-path");
            if (!StringUtils.isEmpty((String)theSavePath)) {
                String fileName = IOUtils.getInstance().getFileName(theSavePath);
                return IOUtils.getInstance().stripFileExtension(fileName);
            }
            if (report instanceof MasterReport) {
                return Messages.getString("ReportDesignerFrame.TabName.UntitledReport", new Object[0]);
            }
            if (report instanceof CrosstabElement) {
                return Messages.getString("ReportDesignerFrame.TabName.UntitledCrosstab", new Object[0]);
            }
            return Messages.getString("ReportDesignerFrame.TabName.UntitledSubReport", new Object[0]);
        }
    }
}

