/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor;

import javax.swing.event.EventListenerList;
import org.pentaho.reporting.designer.core.editor.ZoomModelListener;

public class ZoomModel {
    private EventListenerList zoomModelListeners = new EventListenerList();
    private float zoomFactor = 1.0f;

    public float getZoomAsPercentage() {
        return this.zoomFactor;
    }

    public void setZoomAsPercentage(float zoomFactor) {
        float oldZoomFactor = this.zoomFactor;
        this.zoomFactor = zoomFactor;
        if (oldZoomFactor != zoomFactor) {
            this.notifyListeners();
        }
    }

    public void addZoomModelListener(ZoomModelListener zoomModelListener) {
        this.zoomModelListeners.add(ZoomModelListener.class, zoomModelListener);
    }

    public void removeZoomModelListener(ZoomModelListener zoomModelListener) {
        this.zoomModelListeners.remove(ZoomModelListener.class, zoomModelListener);
    }

    private void notifyListeners() {
        ZoomModelListener[] listeners = (ZoomModelListener[])this.zoomModelListeners.getListeners(ZoomModelListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            ZoomModelListener listener = listeners[i];
            listener.zoomFactorChanged();
        }
    }
}

