/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.crosstab;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.UUID;
import javax.swing.DropMode;
import javax.swing.JList;
import javax.swing.TransferHandler;
import org.pentaho.reporting.designer.core.editor.crosstab.CrosstabDialogTransferHandler;
import org.pentaho.reporting.designer.core.editor.crosstab.FieldDragSupport;
import org.pentaho.reporting.designer.core.editor.crosstab.IndexedTransferable;
import org.pentaho.reporting.libraries.designtime.swing.bulk.DefaultBulkListModel;

public class DraggableJList
extends JList
implements FieldDragSupport {
    private DefaultBulkListModel bulkModel;
    private UUID dragId;

    public DraggableJList(DefaultBulkListModel dataModel) {
        super(dataModel);
        this.bulkModel = dataModel;
        this.dragId = UUID.randomUUID();
        this.setTransferHandler(new CrosstabDialogTransferHandler(this));
        this.setDragEnabled(true);
        this.setDropMode(DropMode.ON);
    }

    @Override
    public UUID getDragId() {
        return this.dragId;
    }

    @Override
    public void removeValues(List<IndexedTransferable.FieldTuple> fields) {
        TreeSet<Integer> indexes = new TreeSet<Integer>();
        for (IndexedTransferable.FieldTuple field : fields) {
            indexes.add(field.getIndex());
        }
        ArrayList l = new ArrayList(indexes);
        Collections.reverse(l);
        for (Integer index : indexes) {
            this.bulkModel.remove(index.intValue());
        }
    }

    @Override
    public List<IndexedTransferable.FieldTuple> getSelectedFields() {
        int[] selectedValues = this.getSelectedIndices();
        ArrayList<IndexedTransferable.FieldTuple> retval = new ArrayList<IndexedTransferable.FieldTuple>();
        for (int idx : selectedValues) {
            retval.add(new IndexedTransferable.FieldTuple(idx, String.valueOf(this.bulkModel.get(idx))));
        }
        return retval;
    }

    @Override
    public void insert(TransferHandler.DropLocation point, List<IndexedTransferable.FieldTuple> items, boolean preventDuplicates) {
        int idx = this.getDropLocation().getIndex();
        if (idx == -1) {
            for (int i = 0; i < items.size(); ++i) {
                IndexedTransferable.FieldTuple tuple = items.get(i);
                String value = tuple.getValue();
                if (preventDuplicates && this.bulkModel.contains((Object)value)) continue;
                this.bulkModel.addElement((Object)value);
            }
        } else {
            for (int i = items.size() - 1; i >= 0; --i) {
                IndexedTransferable.FieldTuple tuple = items.get(i);
                String value = tuple.getValue();
                if (preventDuplicates && this.bulkModel.contains((Object)value)) continue;
                this.bulkModel.add(idx, (Object)value);
            }
        }
    }
}

